/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.adtree;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import lu.uni.adtool.Options;
import lu.uni.adtool.ui.ADTreeCanvas;

public class ADTLatexExport {
    private ADTreeCanvas canvas;

    public ADTLatexExport(ADTreeCanvas canvas) {
        this.canvas = canvas;
    }

    public static String escape(String s) {
        String result = s.replace("\\", "\\textbackslash");
        result = result.replace("&", "\\&");
        result = result.replace("%", "\\%");
        result = result.replace("$", "\\$");
        result = result.replace("#", "\\#");
        result = result.replace("_", "\\_");
        result = result.replace("{", "\\{");
        result = result.replace("}", "\\}");
        result = result.replace("~", "\\textasciitilde");
        result = result.replace("\u221e", "$\\infty$");
        String[] lines = (result = result.replace("^", "\\textasciicircum")).split("\n");
        if (lines.length > 1) {
            result = "\\vbox{";
            for (String l : lines) {
                result = result + "\\hbox{\\strut " + l + "}";
            }
            result = result + "}";
        } else {
            result = "{\\strut " + result + "}";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTo(FileOutputStream fileStream) {
        String content = this.getContent();
        try {
            byte[] contentInBytes = content.getBytes();
            fileStream.write(contentInBytes);
            fileStream.flush();
            fileStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fileStream != null) {
                    fileStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getHeader() {
        String shapeDef = "";
        switch (Options.canv_ShapeDef) {
            case ROUNDRECT: 
            case RECTANGLE: {
                shapeDef = "\\Tr[name=#2]{\\psframebox[linecolor=defender,linestyle=solid,framesep=10]{\\psDefBoxNodes{#2}{#3}}}\n";
                break;
            }
            case OVAL: {
                shapeDef = "\\Toval[name=#2,linecolor=defender,linestyle=solid]{\\psDefBoxNodes{#2}{#3}}\n";
            }
        }
        String shapeAtt = "";
        switch (Options.canv_ShapeAtt) {
            case ROUNDRECT: 
            case RECTANGLE: {
                shapeAtt = "\\Tr[name=#2]{\\psframebox[linecolor=attacker,linestyle=solid,framesep=10]{\\psDefBoxNodes{#2}{#3}}}\n";
                break;
            }
            case OVAL: {
                shapeAtt = "\\Toval[name=#2,linecolor=attacker,linestyle=solid]{\\psDefBoxNodes{#2}{#3}}\n";
            }
        }
        String extraHeader = "\\documentclass[a4paper]{article}\\usepackage{pstricks}\n\\usepackage{pst-tree}\n\\usepackage{graphicx}\n\\usepackage{color}\n\\definecolor{attacker}" + this.getDefineColor(Options.canv_BorderColorAtt) + "\n" + "\\definecolor{defender}" + this.getDefineColor(Options.canv_BorderColorDef) + "\n" + "\\definecolor{attFill}" + this.getDefineColor(Options.canv_FillColorAtt) + "\n" + "\\definecolor{defFill}" + this.getDefineColor(Options.canv_FillColorDef) + "\n" + "\\definecolor{editableFill}" + this.getDefineColor(Options.canv_EditableColor) + "\n" + "\\definecolor{edges}" + this.getDefineColor(Options.canv_EdgesColor) + "\n" + "\\definecolor{attText}" + this.getDefineColor(Options.canv_TextColorAtt) + "\n" + "\\definecolor{defText}" + this.getDefineColor(Options.canv_TextColorDef) + "\n" + "\\newcommand{\\NNodeA}[3][]{%\n" + "\\psset{linewidth=" + Options.canv_LineWidth + ",linestyle=solid,fillcolor=attFill,linecolor=edges}%\n" + "\\psset{#1}%\n" + shapeDef + "}\n" + "\\newcommand{\\NNodeAC}[3][]{%\n" + "\\NNodeA[linestyle=dotted,#1]{#2}{#3}}%\n" + "\n" + "\\newcommand{\\NNodeB}[3][]{%\n" + "\\psset{linewidth=" + Options.canv_LineWidth + ",linestyle=solid,fillcolor=defFill,linecolor=edges}%\n" + "\\psset{#1}%\n" + shapeAtt + "}\n" + "\\newcommand{\\NNodeBC}[3][]{%\n" + "\\NNodeB[linestyle=dotted,#1]{#2}{#3}}%\n" + "\n" + "\\newcommand{\\Bogen}[4][]{\n%" + "\\psset{linecolor=edges,linestyle=solid}\n" + "\\psset{#1}%\n" + "\\psellipticarc(!\\psGetNodeCenter{#2} #2.x #2.y)\n" + "     (!\\psGetNodeCenter{#2:tr} \\psGetNodeCenter{#2:bl} #2:tr.x #2:bl.x sub 10 sub 1.8\n" + "     mul\n" + "     #2:tr.y #2:bl.y sub 2.0 mul)\n" + "     {!\\psGetNodeCenter{#3}\n" + "       #3.y #2.y sub #3.x #2.x sub atan}\n" + "     {!\\psGetNodeCenter{#4}\n" + "       #4.y #2.y sub #4.x #2.x sub atan}\n" + "}\n" + "\\begin{document}\n";
        return extraHeader + "\\begin{figure}[htb]\n" + "\\centering\n" + "\\psset{unit=0.5pt," + "levelsep=" + 2.5 * (double)Options.canv_gapBetweenLevels + "," + "fillstyle=solid,nodesep=0}\n";
    }

    private String getDefineColor(Color color) {
        return "{RGB}{" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "}";
    }

    private String getFooter() {
        String extraEnding = "\\end{document}\n";
        return "\\end{figure}\n\\end{document}\n";
    }

    private String getContent() {
        String result = this.getHeader();
        String[] r = this.canvas.getLatex(this.canvas.getTree().getRoot(), 0);
        result = result + r[0] + r[1];
        result = result + this.getFooter();
        return result;
    }
}

