/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.adtree;

import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import lu.uni.adtool.Options;
import lu.uni.adtool.adtree.ADTreeNode;
import lu.uni.adtool.ui.ADTreeCanvas;
import org.abego.treelayout.NodeExtentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADTLocalTNExtendProvider
implements NodeExtentProvider<ADTreeNode> {
    private static final int X_PADDING = 5;
    private static final int Y_PADDING = 5;
    private ADTreeCanvas owner;

    public ADTLocalTNExtendProvider(ADTreeCanvas owner) {
        this.owner = owner;
    }

    public double getWidth(ADTreeNode node) {
        String[] labels = this.owner.getLabelLines(node);
        double result = this.getSizeOfLabels((String[])labels).x;
        return Math.max(this.correctForOval(result, node), this.getHeight(node));
    }

    public double getHeight(ADTreeNode node) {
        String[] labels = this.owner.getLabelLines(node);
        double result = this.getSizeOfLabels((String[])labels).y;
        return this.correctForOval(result, node);
    }

    protected final Point2D.Double getSizeOfLabels(String[] labels) {
        FontMetrics m = Toolkit.getDefaultToolkit().getFontMetrics(Options.canv_Font);
        Point2D.Double result = new Point2D.Double();
        for (String line : labels) {
            result.setLocation(Math.max(result.getX(), (double)m.stringWidth(line)), result.getY() + (double)m.getHeight());
        }
        return new Point2D.Double(result.getX() + 5.0, result.getY() + 5.0);
    }

    protected double correctForOval(double x, ADTreeNode node) {
        double result = x;
        Options.ShapeType shape = node.getType() == Options.canv_Defender ? Options.canv_ShapeDef : Options.canv_ShapeAtt;
        switch (shape) {
            case OVAL: {
                result = 2.0 * x / Math.sqrt(2.0);
                break;
            }
        }
        return result;
    }

    public void setOwner(ADTreeCanvas owner) {
        if (this.owner == null && owner != null) {
            this.owner = owner;
        }
    }

    public ADTreeCanvas getOwner() {
        return this.owner;
    }
}

