/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.adtree;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import lu.uni.adtool.Options;
import lu.uni.adtool.adtree.ADTNode;
import lu.uni.adtool.adtree.ADTreeForGui;
import lu.uni.adtool.adtree.ADTreeNode;
import lu.uni.adtool.domains.ValuationDomain;
import lu.uni.adtool.domains.predefined.Parametrized;
import lu.uni.adtool.domains.rings.Ring;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADTXmlExport {
    private ADTreeForGui tree;
    private HashMap<Integer, ValuationDomain<Ring>> domains;

    public ADTXmlExport(ADTreeForGui node, HashMap<Integer, ValuationDomain<Ring>> map) {
        this.tree = node;
        this.domains = map;
    }

    Element transform(ADTreeNode node, Document doc) {
        Element result = doc.createElement("node");
        Element label = doc.createElement("label");
        label.insertBefore(doc.createTextNode(node.getLabel()), label.getLastChild());
        result.appendChild(label);
        if (node.getRefinmentType() == ADTreeNode.RefinementType.DISJUNCTIVE) {
            result.setAttribute("refinement", "disjunctive");
        } else {
            result.setAttribute("refinement", "conjunctive");
        }
        if (node.getLevel() == 0 && Options.canv_Defender == ADTreeNode.Type.OPPONENT) {
            result.setAttribute("switchRole", "yes");
        }
        if (this.tree.getParent(node) != null && node.getType() != this.tree.getParent(node).getType()) {
            result.setAttribute("switchRole", "yes");
        }
        List<ADTreeNode> children = this.tree.getChildrenList(node, true);
        ADTNode term = node.getTerm();
        if (Options.main_saveDomains) {
            for (Integer i : this.domains.keySet()) {
                ValuationDomain<Ring> vd = this.domains.get(i);
                String domainId = vd.getDomain().getClass().getSimpleName() + new Integer(i + 1).toString();
                if (term.isEditable(vd.getDomain())) {
                    if (vd.getValue(node) != null) {
                        result.appendChild(this.createParameter(doc, domainId, "basic", vd.getValue(node).toString()));
                    }
                } else if (Options.main_saveDerivedValues) {
                    if ((term.getType() == ADTNode.Type.CP || term.getType() == ADTNode.Type.CO) && ((ADTNode)term.getChildren().elementAt(0)).getChildren().size() == 0) {
                        String value = vd.getTermValue((ADTNode)term.getChildren().elementAt(0)).toString();
                        result.appendChild(this.createParameter(doc, domainId, "default", value));
                    } else {
                        result.appendChild(this.createParameter(doc, domainId, "derived", vd.getTermValue(node.getTerm()).toString()));
                    }
                }
                if (term.getType() != ADTNode.Type.CP && term.getType() != ADTNode.Type.CO || ((ADTNode)term.getChildren().elementAt(0)).getChildren().size() != 0 || !Options.main_saveDerivedValues || !vd.isShowAllLabels()) continue;
                result.appendChild(this.createParameter(doc, domainId, "derived", vd.getTermValue(node.getTerm()).toString()));
            }
        }
        Iterator<ADTreeNode> iterator = children.iterator();
        while (iterator.hasNext()) {
            result.appendChild(this.transform(iterator.next(), doc));
        }
        return result;
    }

    private Element createParameter(Document doc, String domainId, String category, String content) {
        Element parameter = doc.createElement("parameter");
        parameter.setAttribute("domainId", domainId);
        if (!category.equals("basic")) {
            parameter.setAttribute("category", category);
        }
        parameter.setTextContent(content);
        return parameter;
    }

    private void exportDomains(Document doc, Element rootElement) {
        for (Integer i : this.domains.keySet()) {
            ValuationDomain<Ring> vd = this.domains.get(i);
            Element domainNode = doc.createElement("domain");
            Element classNode = doc.createElement("class");
            Element toolNode = doc.createElement("tool");
            classNode.setTextContent(vd.getDomain().getClass().getName());
            toolNode.setTextContent("ADTool");
            domainNode.appendChild(classNode);
            String domainId = vd.getDomain().getClass().getSimpleName() + new Integer(i + 1).toString();
            domainNode.setAttribute("id", domainId);
            if (vd.getDomain() instanceof Parametrized) {
                Element paramNode = doc.createElement("range");
                paramNode.setTextContent(((Parametrized)((Object)vd.getDomain())).getParameter().toString());
                domainNode.appendChild(paramNode);
            }
            domainNode.appendChild(toolNode);
            rootElement.appendChild(domainNode);
        }
    }

    public void exportTo(FileOutputStream fileStream) {
        if (this.tree == null) {
            return;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource stream = new StreamSource(this.getClass().getClassLoader().getResourceAsStream("adtree.xsd"));
            Schema schema = schemaFactory.newSchema(stream);
            factory.setSchema(schema);
            Validator validator = schema.newValidator();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            doc.setXmlStandalone(true);
            Element rootElement = doc.createElement("adtree");
            doc.appendChild(rootElement);
            Element node = this.transform(this.tree.getRoot(true), doc);
            rootElement.appendChild(node);
            if (Options.main_saveDomains) {
                this.exportDomains(doc, rootElement);
            }
            validator.validate(new DOMSource(doc));
            ADTXmlExport.prettyPrint(doc, fileStream);
            fileStream.close();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final void prettyPrint(Document xml, FileOutputStream out) {
        try {
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            tf.transform(new DOMSource(xml), new StreamResult(out));
        }
        catch (TransformerException tfe) {
            tfe.printStackTrace();
        }
    }
}

