/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.adtree;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import lu.uni.adtool.Options;
import lu.uni.adtool.adtree.ADTNode;
import lu.uni.adtool.adtree.ADTreeNode;
import lu.uni.adtool.domains.Domain;
import lu.uni.adtool.domains.DomainFactory;
import lu.uni.adtool.domains.ValueAssignement;
import lu.uni.adtool.domains.predefined.Parametrized;
import lu.uni.adtool.domains.rings.Ring;
import lu.uni.adtool.ui.ADTermView;
import lu.uni.adtool.ui.ADTreeCanvas;
import lu.uni.adtool.ui.ADTreeView;
import lu.uni.adtool.ui.DomainCanvas;
import lu.uni.adtool.ui.DomainView;
import lu.uni.adtool.ui.MainWindow;
import net.infonode.docking.View;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADTXmlImport {
    private MainWindow mainWindow;

    public ADTXmlImport(MainWindow window) {
        this.mainWindow = window;
    }

    public void importFrom(FileInputStream fileStream) {
        try {
            StreamSource stream = new StreamSource(this.getClass().getClassLoader().getResourceAsStream("adtree.xsd"));
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(stream);
            Validator validator = schema.newValidator();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setSchema(schema);
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new DefaultHandler());
            Document doc = builder.parse(fileStream);
            doc.getDocumentElement().normalize();
            validator.validate(new DOMSource(doc));
            Node treeNode = doc.getElementsByTagName("adtree").item(0);
            NodeList list = treeNode.getChildNodes();
            this.mainWindow.removeDomains();
            Vector<HashMap<String, HashMap<String, String>>> values = null;
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (n.getNodeType() != 1) continue;
                Element e = (Element)n;
                if (e.getNodeName().equals("node")) {
                    values = this.importTree(e, list.getLength() - 1);
                } else if (e.getNodeName().equals("domain")) {
                    this.addDomain(e, values);
                }
                this.mainWindow.createAttrDomainMenu();
            }
            fileStream.close();
        }
        catch (ParserConfigurationException pce) {
            this.mainWindow.getStatusBar().reportError(pce.getMessage());
        }
        catch (SAXException e) {
            this.mainWindow.getStatusBar().reportError(e.getMessage());
        }
        catch (IOException e) {
            this.mainWindow.getStatusBar().reportError(e.getMessage());
        }
    }

    private void addValuations(HashMap<String, String> map, ValueAssignement<Ring> va) {
        if (map == null || va == null) {
            return;
        }
        Set<String> keys = map.keySet();
        for (String label : keys) {
            String value = map.get(label);
            Ring ring = va.get(label);
            Ring defaultValue = (Ring)ring.clone();
            if (ring != null) {
                if (ring.updateFromString(value)) {
                    va.put(label, ring);
                    continue;
                }
                this.mainWindow.getStatusBar().reportWarning("Invalid value:\"" + value + "\" for node with label:\"" + label + "\". Using default value.");
                va.put(label, defaultValue);
                continue;
            }
            this.mainWindow.getStatusBar().reportWarning("Cannot specify value for non refined node with label:" + label);
        }
    }

    private void addDomain(Element e, Vector<HashMap<String, HashMap<String, String>>> values) {
        NodeList tools = e.getElementsByTagName("tool");
        boolean isADTool = false;
        for (int i = 0; i < tools.getLength(); ++i) {
            Element tool = (Element)tools.item(i);
            if (!"ADTOOL".equals(tool.getTextContent().trim().toUpperCase())) continue;
            isADTool = true;
        }
        if (!isADTool) {
            return;
        }
        Domain<Ring> d = DomainFactory.createFromString(this.getChildTag(e, "class").getTextContent());
        if (d instanceof Parametrized) {
            Element child = this.getChildTag(e, "range");
            String parameter = null;
            if (child != null) {
                parameter = this.getChildTag(e, "range").getTextContent();
            }
            if (parameter == null) {
                this.mainWindow.getStatusBar().reportError("Domain " + this.getChildTag(e, "class").getTextContent() + " does not have required <range> tag.");
                return;
            }
            if (((Parametrized)((Object)d)).getParameter() instanceof Integer) {
                if (parameter.equals("Infinity")) {
                    ((Parametrized)((Object)d)).setParameter(Integer.MAX_VALUE);
                } else {
                    ((Parametrized)((Object)d)).setParameter(Integer.parseInt(parameter));
                }
            } else {
                this.mainWindow.getStatusBar().reportError("Unknown type of parameter for the domain " + this.getChildTag(e, "class").getTextContent());
            }
        }
        if (d != null) {
            ADTNode root = ((ADTermView)this.mainWindow.getViews()[1].getComponent()).getTerms();
            View view = this.mainWindow.addAttributeDomain(d);
            DomainCanvas canvas = ((DomainView)view.getComponent()).getCanvas();
            canvas.getValueAssPro().setDefault(true, root, d);
            if (d.isValueModifiable(true)) {
                this.addValuations(values.elementAt(0).get(e.getAttribute("id")), canvas.getValueAssPro());
            }
            canvas.getValueAssOpp().setDefault(false, root, d);
            if (d.isValueModifiable(false)) {
                this.addValuations(values.elementAt(1).get(e.getAttribute("id")), canvas.getValueAssOpp());
            }
            canvas.getTree().updateAllSizes();
            canvas.valuesUpdated();
        } else {
            this.mainWindow.getStatusBar().reportError("Failed to import domain " + this.getChildTag(e, "class").getTextContent() + ".");
        }
    }

    private ADTreeNode.Type getType(Element e, ADTreeNode parent) {
        if (e.getAttribute("switchRole").equals("yes")) {
            if (parent.getType() == ADTreeNode.Type.OPPONENT) {
                return ADTreeNode.Type.PROPONENT;
            }
            return ADTreeNode.Type.OPPONENT;
        }
        return parent.getType();
    }

    private ADTreeNode.RefinementType getRefinement(Element e) {
        if (e.getAttribute("refinement").equals("conjunctive")) {
            return ADTreeNode.RefinementType.CONJUNCTIVE;
        }
        return ADTreeNode.RefinementType.DISJUNCTIVE;
    }

    private Collection<Element> getChildrenTag(Node n, String tag) {
        Vector<Element> result = new Vector<Element>();
        NodeList list = n.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element eChild;
            if (list.item(i).getNodeType() != 1 || (eChild = (Element)list.item(i)).getNodeName() != tag) continue;
            result.add(eChild);
        }
        return result;
    }

    private Element getChildTag(Node n, String tag) {
        NodeList list = n.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element eChild;
            if (list.item(i).getNodeType() != 1 || (eChild = (Element)list.item(i)).getNodeName() != tag) continue;
            return eChild;
        }
        return null;
    }

    private Vector<HashMap<String, HashMap<String, String>>> importTree(Element e, int noDomains) {
        Vector<HashMap<String, HashMap<String, String>>> result = new Vector<HashMap<String, HashMap<String, String>>>(2);
        for (int i = 0; i < 2; ++i) {
            result.add(i, new HashMap(2));
        }
        ADTreeCanvas canvas = ((ADTreeView)this.mainWindow.getViews()[0].getComponent()).getCanvas();
        canvas.newTree();
        ADTreeNode root = canvas.getRoot(true);
        root.setRefinementType(this.getRefinement(e));
        Options.canv_Defender = e.getAttribute("switchRole").equals("yes") ? ADTreeNode.Type.OPPONENT : ADTreeNode.Type.PROPONENT;
        this.addChildren(e, root, result);
        String label = this.getChildTag(e, "label").getTextContent();
        canvas.setLabel(root, label);
        this.storeParameters(e, root, result);
        canvas.getTree().updateAllSizes();
        return result;
    }

    private void addChildren(Element e, ADTreeNode node, Vector<HashMap<String, HashMap<String, String>>> result) {
        ADTreeCanvas canvas = ((ADTreeView)this.mainWindow.getViews()[0].getComponent()).getCanvas();
        Collection<Element> list = this.getChildrenTag(e, "node");
        for (Element eChild : list) {
            ADTreeNode child = new ADTreeNode(this.getType(eChild, node), this.getRefinement(eChild));
            if (eChild.getAttribute("switchRole").equals("yes")) {
                canvas.getTree().addCounter(node, child);
            } else {
                canvas.getTree().addChild(node, child);
            }
            child.setLabel(this.getChildTag(eChild, "label").getTextContent());
            this.storeParameters(eChild, child, result);
            this.addChildren(eChild, child, result);
        }
    }

    private void storeParameters(Element e, ADTreeNode node, Vector<HashMap<String, HashMap<String, String>>> result) {
        Collection<Element> listParam = this.getChildrenTag(e, "parameter");
        int j = 1;
        if (node.getType() == ADTreeNode.Type.PROPONENT) {
            j = 0;
        }
        for (Element eParam : listParam) {
            if (!eParam.getAttribute("category").equals("basic")) continue;
            String idDomain = eParam.getAttribute("domainId");
            if (!result.elementAt(j).containsKey(idDomain)) {
                result.elementAt(j).put(idDomain, new HashMap());
            }
            result.elementAt(j).get(idDomain).put(node.getLabel(), eParam.getTextContent());
        }
    }
}

