/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.adtree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import lu.uni.adtool.adtree.ADTNode;
import lu.uni.adtool.adtree.ADTreeNode;
import lu.uni.adtool.adtree.ADTreeNodeExtentProvider;
import lu.uni.adtool.adtree.Node;
import lu.uni.adtool.ui.ADTermView;
import lu.uni.adtool.ui.ADTreeCanvas;
import lu.uni.adtool.ui.DomainCanvas;
import lu.uni.adtool.ui.TreeChangeListener;
import org.abego.treelayout.util.AbstractTreeForTreeLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADTreeForGui
extends AbstractTreeForTreeLayout<ADTreeNode>
implements Serializable {
    static final long serialVersionUID = 98453455646646164L;
    private ADTreeNode viewRoot = null;
    protected transient ADTreeNodeExtentProvider extendProvider;
    private transient HashMap<Integer, TreeChangeListener> listeners;
    private transient TreeChangeListener firstListener;
    private Map<ADTreeNode, List<ADTreeNode>> childrenMap = new HashMap<ADTreeNode, List<ADTreeNode>>();
    private Map<ADTreeNode, ADTreeNode> parents = new HashMap<ADTreeNode, ADTreeNode>();
    private Vector<LinkedList<ADTreeNode>> levels = new Vector();
    private String description;
    private HashMap<ADTreeNode, String> commentsMap = new HashMap();
    private transient boolean localExtendProvider;

    public ADTreeForGui(ADTreeNode root, Map<ADTreeNode, List<ADTreeNode>> newChildren, Map<ADTreeNode, ADTreeNode> newParents) {
        this(root);
        this.childrenMap = newChildren;
        for (List<ADTreeNode> list : this.childrenMap.values()) {
            for (ADTreeNode node : list) {
                node.setFolded(false);
                node.setAboveFolded(false);
            }
        }
        this.parents = newParents;
        this.viewRoot = null;
        this.description = "";
        this.resetLevels(root, 0);
    }

    public ADTreeForGui(ADTreeNode root) {
        super((Object)root);
        root.setFolded(false);
        root.setAboveFolded(false);
        this.extendProvider = new ADTreeNodeExtentProvider();
        this.localExtendProvider = false;
        this.listeners = new HashMap();
        this.firstListener = null;
        this.resetLevels(root, 0);
    }

    public void addTreeChangeListener(TreeChangeListener listener) {
        if (listener instanceof ADTermView) {
            this.firstListener = listener;
        } else {
            this.listeners.put(this.getKey(listener), listener);
        }
    }

    private LinkedList<ADTreeNode> getLevelList(int i) {
        while (i >= this.levels.size()) {
            this.levels.add(new LinkedList());
        }
        return this.levels.elementAt(i);
    }

    public void removeTreeChangeListener(TreeChangeListener listener) {
        this.listeners.remove(this.getKey(listener));
    }

    private Integer getKey(TreeChangeListener listener) {
        return ((ADTreeCanvas)listener).getId();
    }

    public ADTreeNode getParent(ADTreeNode node) {
        return this.getParent(node, false);
    }

    public ADTreeNode getParent(ADTreeNode node, boolean ignoreFold) {
        if (node == null) {
            return null;
        }
        if (!ignoreFold && node.isAboveFolded()) {
            return null;
        }
        return this.parents.get(node);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public HashMap<ADTreeNode, String> getComments() {
        return this.commentsMap;
    }

    public void setComments(HashMap<ADTreeNode, String> comments) {
        this.commentsMap = comments;
    }

    public List<ADTreeNode> getChildrenList(ADTreeNode node) {
        return this.getChildrenList(node, false);
    }

    public List<ADTreeNode> getChildrenList(ADTreeNode node, boolean ignoreFold) {
        if (!ignoreFold && node.isFolded()) {
            return new ArrayList<ADTreeNode>();
        }
        List<ADTreeNode> result = this.childrenMap.get(node);
        if (result == null) {
            result = new ArrayList<ADTreeNode>();
            this.childrenMap.put(node, result);
        }
        return result;
    }

    public Integer getNumberOfNodes() {
        Set<ADTreeNode> keys = this.childrenMap.keySet();
        int result = 0;
        for (ADTreeNode n : keys) {
            List<ADTreeNode> list = this.getChildrenList(n, true);
            result += list.size();
        }
        return new Integer(result + 1);
    }

    public ADTNode getTerms() {
        return this.getTerms(this.getRoot(true), 0);
    }

    public ADTreeNode getLeftSibling(ADTreeNode node) {
        if (node != null) {
            LinkedList<ADTreeNode> level = this.getLevelList(node.getLevel());
            int index = level.indexOf(node);
            index = (index - 1 + level.size()) % level.size();
            return level.get(index);
        }
        return null;
    }

    public ADTreeNode getRightSibling(ADTreeNode node) {
        if (node != null) {
            LinkedList<ADTreeNode> level = this.getLevelList(node.getLevel());
            int index = level.indexOf(node);
            index = (index + 1) % level.size();
            return level.get(index);
        }
        return null;
    }

    public ADTreeNode getMiddleChild(ADTreeNode node) {
        if (node != null) {
            List<ADTreeNode> list = this.getChildrenList(node, false);
            if (list == null) {
                return null;
            }
            if (list.size() == 0) {
                return null;
            }
            return list.get(list.size() / 2);
        }
        return null;
    }

    public final void changeOp(ADTreeNode node) {
        node.changeOp();
        this.notifyTreeChanged();
    }

    private void addToLevelList(int index, ADTreeNode parent, ADTreeNode node) {
        if (parent.isFolded()) {
            return;
        }
        node.setLevel(parent.getLevel() + 1);
        LinkedList<ADTreeNode> nodeLevelList = this.getLevelList(node.getLevel());
        List<ADTreeNode> childList = this.getChildrenList(parent, false);
        if (childList == null || childList.size() <= index) {
            ADTreeNode oldNode = childList.get(childList.size() - 1);
            nodeLevelList.add(nodeLevelList.indexOf(oldNode) + 1, node);
        } else {
            ADTreeNode oldNode = childList.get(index);
            nodeLevelList.add(nodeLevelList.indexOf(oldNode), node);
        }
    }

    private void addToLevelList(ADTreeNode parent, ADTreeNode node, boolean counter) {
        if (parent.isFolded()) {
            return;
        }
        List<ADTreeNode> childList = this.getChildrenList(parent, false);
        LinkedList<ADTreeNode> nodeLevelList = this.getLevelList(node.getLevel());
        if (childList.size() == 0) {
            LinkedList<ADTreeNode> parentLevelList = this.getLevelList(parent.getLevel());
            if (parentLevelList.size() > 1) {
                ListIterator iter = parentLevelList.listIterator(parentLevelList.indexOf(parent));
                List<ADTreeNode> list = this.getChildrenList((ADTreeNode)iter.next(), false);
                while ((list == null || list.size() == 0) && iter.hasPrevious()) {
                    list = this.getChildrenList((ADTreeNode)iter.previous(), false);
                }
                if (list == null || list.size() == 0) {
                    nodeLevelList.addFirst(node);
                } else {
                    childList = this.getChildrenList((ADTreeNode)iter.next(), false);
                    ADTreeNode prevNode = childList.get(childList.size() - 1);
                    nodeLevelList.add(nodeLevelList.indexOf(prevNode) + 1, node);
                }
            } else {
                nodeLevelList.add(node);
            }
        } else {
            ADTreeNode prevNode = childList.get(childList.size() - 1);
            if (parent.isCountered() && !counter) {
                nodeLevelList.add(nodeLevelList.indexOf(prevNode), node);
            } else {
                nodeLevelList.add(nodeLevelList.indexOf(prevNode) + 1, node);
            }
        }
    }

    public void addCounter(ADTreeNode parentNode, ADTreeNode node) {
        List<ADTreeNode> list = this.getChildrenList(parentNode, true);
        parentNode.setCountered(true);
        node.setLevel(parentNode.getLevel() + 1);
        if (!parentNode.isFolded()) {
            this.addToLevelList(parentNode, node, true);
        }
        list.add(node);
        this.parents.put(node, parentNode);
        if (!this.localExtendProvider) {
            this.extendProvider.updateSize(node);
        }
        this.notifyTreeChanged();
    }

    public void addChild(ADTreeNode parentNode, ADTreeNode node) {
        this.addChild(parentNode, node, true);
    }

    private void addChild(ADTreeNode parentNode, ADTreeNode node, boolean notify) {
        List<ADTreeNode> list = this.getChildrenList(parentNode, true);
        node.setLevel(parentNode.getLevel() + 1);
        if (!parentNode.isFolded()) {
            this.addToLevelList(parentNode, node, false);
        }
        if (parentNode.isCountered()) {
            list.add(list.size() - 1, node);
        } else {
            list.add(node);
        }
        this.parents.put(node, parentNode);
        if (!this.localExtendProvider) {
            this.extendProvider.updateSize(node);
        }
        if (notify) {
            this.notifyTreeChanged();
        }
    }

    public void addSibling(ADTreeNode oldNode, ADTreeNode sibling, boolean onLeft) {
        ADTreeNode parentNode = this.getParent(oldNode, true);
        List<ADTreeNode> list = this.getChildrenList(parentNode, true);
        int index = list.indexOf(oldNode);
        if (!onLeft) {
            ++index;
        }
        this.addToLevelList(index, parentNode, sibling);
        list.add(index, sibling);
        this.parents.put(sibling, parentNode);
        if (!this.localExtendProvider) {
            this.extendProvider.updateSize(sibling);
        }
        this.notifyTreeChanged();
    }

    public void addChildren(ADTreeNode parentNode, ADTreeNode ... nodes) {
        for (ADTreeNode node : nodes) {
            this.addToLevelList(parentNode, node, false);
            this.addChild(parentNode, node, false);
        }
    }

    public void removeNode(ADTreeNode node) {
        ADTreeNode parent = this.getParent(node, true);
        if (parent != null) {
            if (node.isAboveFolded()) {
                this.toggleAboveFold(node);
            }
            if (node.isFolded()) {
                this.toggleFold(node);
            }
            List<ADTreeNode> list1 = this.getChildrenList(parent, true);
            List<ADTreeNode> listChildren = this.getChildrenList(node, true);
            this.parents.remove(node);
            this.childrenMap.remove(node);
            for (ADTreeNode child : listChildren) {
                this.parents.put(child, parent);
            }
            list1.addAll(list1.indexOf(node), listChildren);
            list1.remove(node);
        }
        this.updateAllSizes();
    }

    public void removeTree(ADTreeNode node) {
        if (this.getParent(node, true) != null) {
            this.removeChild(this.getParent(node, true), node);
        }
    }

    public void setLabel(ADTreeNode node, String label) {
        node.setLabel(label);
        this.updateSize(node);
    }

    public void updateAllSizes() {
        if (!this.localExtendProvider) {
            this.extendProvider.clearSizes();
            this.updateAllSizes(this.getRoot(true));
        }
        this.notifySizeChanged();
    }

    private void updateAllSizes(ADTreeNode node) {
        this.extendProvider.updateSize(node);
        for (ADTreeNode child : this.getChildrenList(node, true)) {
            this.updateAllSizes(child);
        }
    }

    public void updateSize(ADTreeNode node) {
        if (!this.localExtendProvider) {
            this.extendProvider.updateSize(node);
        }
    }

    public void setOwner(ADTreeCanvas canvas) {
        this.extendProvider.setOwner(canvas);
        this.updateAllSizes();
    }

    public void defocusAll() {
        if (this.firstListener != null) {
            this.firstListener.setFocus(null);
        }
        List<Integer> keys = ADTreeForGui.asSortedList(this.listeners.keySet());
        for (Integer integer : keys) {
            this.listeners.get(integer).setFocus(null);
        }
    }

    public void registerSizeCanvas(DomainCanvas<?> canvas) {
        this.extendProvider.registerCanvas(canvas);
        this.updateAllSizes();
    }

    public void deregisterSizeCanvas(DomainCanvas<?> canvas) {
        this.extendProvider.deregisterCanvas(canvas);
        this.updateAllSizes();
    }

    public void newTree() {
        this.defocusAll();
        ADTreeNode treeRoot = this.getRoot(true);
        ADTreeNode viewRoot = this.getRoot(false);
        while (treeRoot != viewRoot) {
            this.toggleAboveFold(viewRoot);
            viewRoot = this.getRoot(false);
        }
        this.removeAllChildren(treeRoot);
        ADTreeNode.resetCounter(2);
        treeRoot.setCountered(false);
        if (treeRoot.isFolded()) {
            this.toggleFold(treeRoot);
        }
        treeRoot.setType(ADTreeNode.Type.PROPONENT);
        treeRoot.setLabel("Root");
        this.resetLevels(treeRoot, 0);
        viewRoot = null;
        this.notifyTreeChanged();
        this.updateAllSizes();
        this.notifySizeChanged();
    }

    public void createFromTerms(ADTNode termRoot) {
        ADTreeNode treeRoot = this.getRoot(true);
        ADTreeNode viewRoot = this.getRoot(false);
        while (treeRoot != viewRoot) {
            this.toggleAboveFold(viewRoot);
            viewRoot = this.getRoot(false);
        }
        this.removeAllChildren(this.getRoot(true));
        this.resetLevels(treeRoot, 0);
        ADTreeNode.resetCounter(2);
        treeRoot.setCountered(false);
        treeRoot.setType(ADTreeNode.Type.PROPONENT);
        switch (termRoot.getType()) {
            case LEAFP: {
                treeRoot.setLabel(termRoot.getName());
                break;
            }
            case OP: {
                treeRoot.setLabel(termRoot.getName());
                treeRoot.setRefinementType(ADTreeNode.RefinementType.DISJUNCTIVE);
                for (Node termChild : termRoot.getChildren()) {
                    this.addFromTerm((ADTNode)termChild, treeRoot, 1);
                }
                break;
            }
            case AP: {
                treeRoot.setLabel(termRoot.getName());
                treeRoot.setRefinementType(ADTreeNode.RefinementType.CONJUNCTIVE);
                for (Node termChild : termRoot.getChildren()) {
                    this.addFromTerm((ADTNode)termChild, treeRoot, 1);
                }
                break;
            }
            case CP: {
                ADTNode subTerm = (ADTNode)termRoot.getChildren().elementAt(0);
                switch (subTerm.getType()) {
                    case LEAFP: {
                        treeRoot.setLabel(subTerm.getName());
                        break;
                    }
                    case OP: {
                        treeRoot.setLabel(subTerm.getName());
                        treeRoot.setRefinementType(ADTreeNode.RefinementType.DISJUNCTIVE);
                        for (Node termChild : subTerm.getChildren()) {
                            this.addFromTerm((ADTNode)termChild, treeRoot, 1);
                        }
                        break;
                    }
                    case AP: {
                        treeRoot.setLabel(subTerm.getName());
                        treeRoot.setRefinementType(ADTreeNode.RefinementType.CONJUNCTIVE);
                        for (Node termChild : subTerm.getChildren()) {
                            this.addFromTerm((ADTNode)termChild, treeRoot, 1);
                        }
                        break;
                    }
                    case CP: {
                        treeRoot.setLabel(subTerm.getName());
                        treeRoot.setRefinementType(ADTreeNode.RefinementType.DISJUNCTIVE);
                        this.addFromTerm(subTerm, treeRoot, 1);
                        break;
                    }
                    default: {
                        System.err.println("Cannot create from terms. Invalid term expression provided in counter node.");
                    }
                }
                this.addFromTerm((ADTNode)termRoot.getChildren().elementAt(1), treeRoot, 1);
                treeRoot.setCountered(true);
                break;
            }
            default: {
                System.err.println("Cannot create from terms. Invalid term expression provided.");
            }
        }
        this.notifyTreeChanged();
        this.updateAllSizes();
        this.notifySizeChanged();
    }

    public ADTNode getTerms(ADTreeNode node, int id) {
        boolean o;
        ADTNode term = new ADTNode(id);
        List<ADTreeNode> list = this.getChildrenList(node, true);
        boolean p = node.getType() == ADTreeNode.Type.PROPONENT;
        boolean bl = o = node.getRefinmentType() == ADTreeNode.RefinementType.DISJUNCTIVE;
        if (list.size() == 0) {
            if (id == 0) {
                term.setType(ADTNode.Type.LEAFP);
            } else {
                term.setType(p ? ADTNode.Type.LEAFP : ADTNode.Type.LEAFO);
            }
            node.setTerm(term);
            term.setName(node.getLabel());
            return term;
        }
        if (node.isCountered()) {
            if (p) {
                term.setType(ADTNode.Type.CP);
                term.setName("cp");
            } else {
                term.setType(ADTNode.Type.CO);
                term.setName("co");
            }
            ADTNode subTerm = new ADTNode(id + 1);
            subTerm.setName(node.getLabel());
            if (list.size() == 1) {
                if (id == 0) {
                    subTerm.setType(ADTNode.Type.LEAFP);
                } else {
                    subTerm.setType(p ? ADTNode.Type.LEAFP : ADTNode.Type.LEAFO);
                }
            } else {
                if (p) {
                    subTerm.setType(o ? ADTNode.Type.OP : ADTNode.Type.AP);
                } else {
                    subTerm.setType(o ? ADTNode.Type.OO : ADTNode.Type.AO);
                }
                for (int i = 0; i < list.size() - 1; ++i) {
                    subTerm.jjtAddChild(this.getTerms(list.get(i), id + i + 2), i);
                }
            }
            term.jjtAddChild(subTerm, 0);
            term.jjtAddChild(this.getTerms(list.get(list.size() - 1), id + list.size() + 1), 1);
        } else {
            if (p) {
                term.setType(o ? ADTNode.Type.OP : ADTNode.Type.AP);
            } else {
                term.setType(o ? ADTNode.Type.OO : ADTNode.Type.AO);
            }
            int noChild = 0;
            for (ADTreeNode child : list) {
                term.jjtAddChild(this.getTerms(child, id + noChild + 1), noChild);
                ++noChild;
            }
        }
        term.setName(node.getLabel());
        node.setTerm(term);
        return term;
    }

    private void addFromTerm(ADTNode term, ADTreeNode parent, int level) {
        if (term == null) {
            return;
        }
        switch (term.getType()) {
            case LEAFP: {
                ADTreeNode node = new ADTreeNode(ADTreeNode.Type.PROPONENT, ADTreeNode.RefinementType.DISJUNCTIVE);
                node.setLabel(term.getName());
                node.setLevel(level);
                this.addChild(parent, node, false);
                break;
            }
            case OP: {
                ADTreeNode node = new ADTreeNode(ADTreeNode.Type.PROPONENT, ADTreeNode.RefinementType.DISJUNCTIVE);
                node.setLabel(term.getName());
                this.addChild(parent, node, false);
                for (Node termChild : term.getChildren()) {
                    this.addFromTerm((ADTNode)termChild, node, level + 1);
                }
                break;
            }
            case AP: {
                ADTreeNode node = new ADTreeNode(ADTreeNode.Type.PROPONENT, ADTreeNode.RefinementType.CONJUNCTIVE);
                node.setLabel(term.getName());
                this.addChild(parent, node, false);
                for (Node termChild : term.getChildren()) {
                    this.addFromTerm((ADTNode)termChild, node, level + 1);
                }
                break;
            }
            case CP: {
                ADTreeNode node;
                ADTNode subTerm = (ADTNode)term.getChildren().elementAt(0);
                switch (subTerm.getType()) {
                    case LEAFP: {
                        node = new ADTreeNode(ADTreeNode.Type.PROPONENT, ADTreeNode.RefinementType.DISJUNCTIVE);
                        node.setLabel(subTerm.getName());
                        node.setLevel(level);
                        this.addChild(parent, node, false);
                        break;
                    }
                    case OP: {
                        node = new ADTreeNode(ADTreeNode.Type.PROPONENT, ADTreeNode.RefinementType.DISJUNCTIVE);
                        node.setLabel(subTerm.getName());
                        node.setLevel(level);
                        this.addChild(parent, node, false);
                        for (Node termChild : subTerm.getChildren()) {
                            this.addFromTerm((ADTNode)termChild, node, level + 1);
                        }
                        break;
                    }
                    case AP: {
                        node = new ADTreeNode(ADTreeNode.Type.PROPONENT, ADTreeNode.RefinementType.CONJUNCTIVE);
                        node.setLabel(subTerm.getName());
                        node.setLevel(level);
                        this.addChild(parent, node, false);
                        for (Node termChild : subTerm.getChildren()) {
                            this.addFromTerm((ADTNode)termChild, node, level + 1);
                        }
                        break;
                    }
                    case CP: {
                        node = new ADTreeNode(ADTreeNode.Type.PROPONENT, ADTreeNode.RefinementType.DISJUNCTIVE);
                        node.setLabel(subTerm.getName());
                        node.setLevel(level);
                        this.addChild(parent, node, false);
                        this.addFromTerm(subTerm, node, level + 1);
                        break;
                    }
                    default: {
                        System.err.println("1 Invalid term expression provided.");
                        return;
                    }
                }
                this.addFromTerm((ADTNode)term.getChildren().elementAt(1), node, level + 1);
                node.setCountered(true);
                break;
            }
            case LEAFO: {
                ADTreeNode node = new ADTreeNode(ADTreeNode.Type.OPPONENT, ADTreeNode.RefinementType.DISJUNCTIVE);
                node.setLabel(term.getName());
                node.setLevel(level);
                this.addChild(parent, node, false);
                break;
            }
            case OO: {
                ADTreeNode node = new ADTreeNode(ADTreeNode.Type.OPPONENT, ADTreeNode.RefinementType.DISJUNCTIVE);
                node.setLabel(term.getName());
                this.addChild(parent, node, false);
                for (Node termChild : term.getChildren()) {
                    this.addFromTerm((ADTNode)termChild, node, level + 1);
                }
                break;
            }
            case AO: {
                ADTreeNode node = new ADTreeNode(ADTreeNode.Type.OPPONENT, ADTreeNode.RefinementType.CONJUNCTIVE);
                node.setLabel(term.getName());
                this.addChild(parent, node, false);
                for (Node termChild : term.getChildren()) {
                    this.addFromTerm((ADTNode)termChild, node, level + 1);
                }
                break;
            }
            case CO: {
                ADTreeNode node;
                ADTNode subTerm = (ADTNode)term.getChildren().elementAt(0);
                switch (subTerm.getType()) {
                    case LEAFO: {
                        node = new ADTreeNode(ADTreeNode.Type.OPPONENT, ADTreeNode.RefinementType.DISJUNCTIVE);
                        node.setLabel(subTerm.getName());
                        node.setLevel(level);
                        this.addChild(parent, node, false);
                        break;
                    }
                    case OO: {
                        node = new ADTreeNode(ADTreeNode.Type.OPPONENT, ADTreeNode.RefinementType.DISJUNCTIVE);
                        node.setLabel(subTerm.getName());
                        node.setLevel(level);
                        this.addChild(parent, node, false);
                        for (Node termChild : subTerm.getChildren()) {
                            this.addFromTerm((ADTNode)termChild, node, level + 1);
                        }
                        break;
                    }
                    case AO: {
                        node = new ADTreeNode(ADTreeNode.Type.OPPONENT, ADTreeNode.RefinementType.CONJUNCTIVE);
                        node.setLabel(subTerm.getName());
                        node.setLevel(level);
                        this.addChild(parent, node, false);
                        for (Node termChild : subTerm.getChildren()) {
                            this.addFromTerm((ADTNode)termChild, node, level + 1);
                        }
                        break;
                    }
                    case CO: {
                        node = new ADTreeNode(ADTreeNode.Type.OPPONENT, ADTreeNode.RefinementType.DISJUNCTIVE);
                        node.setLabel(subTerm.getName());
                        node.setLevel(level);
                        this.addChild(parent, node, false);
                        this.addFromTerm(subTerm, node, level + 1);
                        break;
                    }
                    default: {
                        System.err.println("2 Invalid term expression provided.");
                        return;
                    }
                }
                this.addFromTerm((ADTNode)term.getChildren().elementAt(1), node, level + 1);
                node.setCountered(true);
                break;
            }
            default: {
                System.err.println("3 Invalid term expression provided.");
                return;
            }
        }
    }

    private void removeChild(ADTreeNode node, ADTreeNode child) {
        if (child.getType() != node.getType()) {
            node.setCountered(false);
        }
        this.removeAllChildren(child);
        List<ADTreeNode> list = this.getChildrenList(node, true);
        list.remove(child);
        this.parents.remove(child);
        this.childrenMap.remove(child);
        LinkedList<ADTreeNode> nodeLevelList = this.getLevelList(child.getLevel());
        nodeLevelList.remove(child);
    }

    public void removeAllChildren(ADTreeNode node) {
        LinkedList<ADTreeNode> nodeLevelList = this.getLevelList(node.getLevel() + 1);
        node.setCountered(false);
        List<ADTreeNode> list = this.getChildrenList(node, true);
        for (ADTreeNode child : list) {
            this.removeAllChildren(child);
            nodeLevelList.remove(child);
            this.parents.remove(child);
            this.childrenMap.remove(child);
        }
        list.clear();
    }

    public void notifyTreeChanged() {
        if (this.firstListener != null) {
            this.firstListener.treeChanged();
        }
        List<Integer> keys = ADTreeForGui.asSortedList(this.listeners.keySet());
        for (Integer integer : keys) {
            this.listeners.get(integer).treeChanged();
        }
    }

    public void setExtendProvider(ADTreeNodeExtentProvider extendProvider) {
        this.extendProvider = extendProvider;
    }

    public ADTreeNode getRoot() {
        return this.getRoot(false);
    }

    public ADTreeNode getRoot(boolean ignoreFold) {
        if (!ignoreFold && this.viewRoot != null) {
            return this.viewRoot;
        }
        return (ADTreeNode)super.getRoot();
    }

    public void toggleAboveFold(ADTreeNode node) {
        node.setAboveFolded(!node.isAboveFolded());
        this.viewRoot = this.getNewViewNode(node);
        this.resetLevels(this.getRoot(false), 0);
        this.notifyTreeChanged();
    }

    private ADTreeNode getNewViewNode(ADTreeNode node) {
        if (node.isAboveFolded()) {
            return node;
        }
        ADTreeNode parent = this.getParent(node, true);
        if (parent == null) {
            return null;
        }
        return this.getNewViewNode(parent);
    }

    public ADTreeNode getViewRoot() {
        return this.viewRoot;
    }

    public ADTreeNodeExtentProvider getExtendProvider() {
        return this.extendProvider;
    }

    public Map<ADTreeNode, List<ADTreeNode>> getChildrenMap() {
        return this.childrenMap;
    }

    public Map<ADTreeNode, ADTreeNode> getParents() {
        return this.parents;
    }

    public Vector<LinkedList<ADTreeNode>> getLevels() {
        return this.levels;
    }

    public void setLocalExtendProvider(boolean localExtendProvider) {
        this.localExtendProvider = localExtendProvider;
    }

    public void expandAllFold() {
        this.expandAllFold(this.getRoot(true));
        this.resetLevels(this.getRoot(false), 0);
        this.notifyTreeChanged();
    }

    public void expandAllFold(ADTreeNode node) {
        if (node.isFolded()) {
            node.setFolded(!node.isFolded());
        }
        for (ADTreeNode child : this.getChildrenList(node, true)) {
            this.expandAllFold(child);
        }
    }

    public void toggleFold(ADTreeNode node) {
        node.setFolded(!node.isFolded());
        this.resetLevels(this.getRoot(false), 0);
        this.notifyTreeChanged();
    }

    public void resetLevels() {
        this.levels.clear();
        this.resetLevels(this.getRoot(false), 0);
    }

    private void resetLevels(ADTreeNode node, int level) {
        this.getLevelList(level).add(node);
        List<ADTreeNode> children = this.getChildrenList(node, false);
        if (children != null && children.size() > 0) {
            for (ADTreeNode child : children) {
                this.resetLevels(child, level + 1);
            }
        }
    }

    private void notifySizeChanged() {
        List<Integer> keys = ADTreeForGui.asSortedList(this.listeners.keySet());
        for (Integer integer : keys) {
            this.listeners.get(integer).sizeChanged();
        }
    }

    public static <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return list;
    }
}

