/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.domains;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Set;
import java.util.Vector;
import lu.uni.adtool.domains.Domain;
import lu.uni.adtool.domains.predefined.DiffLMH;
import lu.uni.adtool.domains.predefined.DiffLMHE;
import lu.uni.adtool.domains.predefined.MinCost;
import lu.uni.adtool.domains.predefined.MinSkill;
import lu.uni.adtool.domains.predefined.MinTimePar;
import lu.uni.adtool.domains.predefined.MinTimeSeq;
import lu.uni.adtool.domains.predefined.PowerCons;
import lu.uni.adtool.domains.predefined.ProbSucc;
import lu.uni.adtool.domains.predefined.ReachPar;
import lu.uni.adtool.domains.predefined.ReachSeq;
import lu.uni.adtool.domains.predefined.SatOpp;
import lu.uni.adtool.domains.predefined.SatProp;
import lu.uni.adtool.domains.predefined.SatScenario;
import lu.uni.adtool.domains.rings.Ring;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DomainFactory {
    private static final String[] oldNames = new String[]{"BoolOrAndStar", "BoolAndOr", "BoolOrAnd", "IntMinMinMax", "IntMinMax", "IntMinSum", "ProbPlusTimes", "RealG0MinSumCost", "RealG0MinSumParallel", "RealG0MinSum", "RealG0MaxSum", "SkillDomainLMHE", "SkillDomain"};
    private static final String[] newNames = new String[]{"SatScenario", "SattOpp", "SatProp", "ReachPar", "MinSkill", "ReachSeq", "ProbSucc", "MinCost", "MinTimePar", "MinTimeSeq", "PowerCons", "DiffLMHE", "DiffLMH"};
    private static final String domainsPrefix = "lu.uni.adtool.domains.predefined";

    public static Boolean isObsolete(Domain<Ring> domain) {
        return DomainFactory.isObsolete(domain.getClass().getSimpleName());
    }

    public static Boolean isObsolete(String domainName) {
        if (Arrays.asList(oldNames).contains(domainName)) {
            return true;
        }
        return false;
    }

    public static Domain<Ring> updateDomain(Domain<Ring> d) {
        if (DomainFactory.isObsolete(d).booleanValue()) {
            String newName = DomainFactory.updateDomainName(d.getClass().getSimpleName());
            return DomainFactory.createFromString(DomainFactory.updateDomainName(newName));
        }
        return d;
    }

    public static String updateDomainName(String name) {
        String result = name;
        for (int i = 0; i < oldNames.length; ++i) {
            result = result.replace(oldNames[i], newNames[i]);
        }
        return result;
    }

    public static Domain<Ring> createFromString(String domainName) {
        String name = domainName;
        if (!domainName.startsWith(domainsPrefix)) {
            name = "lu.uni.adtool.domains.predefined." + domainName;
        }
        Constructor<?>[] ct = null;
        try {
            Class<?> c = Class.forName(name);
            ct = c.getDeclaredConstructors();
        }
        catch (ClassNotFoundException e) {
            System.err.println("Class with name " + name + " not found");
            return null;
        }
        Domain d = null;
        if (ct.length == 1) {
            try {
                d = (Domain)ct[0].newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                System.err.println(e);
                return null;
            }
            catch (IllegalAccessException e) {
                System.err.println(e);
                return null;
            }
            catch (InvocationTargetException e) {
                System.err.println(e);
                return null;
            }
        }
        return d;
    }

    public static String getClassName(Domain<Ring> d) {
        return d.getClass().getSimpleName();
    }

    public static Vector<Domain<?>> getPredefinedDomains() {
        Vector result = new Vector();
        Reflections reflections = new Reflections(domainsPrefix, new Scanner[0]);
        Set m = reflections.getSubTypesOf(Domain.class);
        for (Class c : m) {
            Domain d = null;
            Constructor<?>[] ct = c.getDeclaredConstructors();
            try {
                if (ct.length != 1 || DomainFactory.isObsolete(d = (Domain)ct[0].newInstance(new Object[0])).booleanValue()) continue;
                result.add(d);
            }
            catch (InstantiationException e) {
                System.err.println(e);
                return null;
            }
            catch (IllegalAccessException e) {
                System.err.println(e);
                return null;
            }
            catch (InvocationTargetException e) {
                System.err.println(e);
                return null;
            }
        }
        if (result.size() == 0) {
            result.add(new SatProp());
            result.add(new ReachPar());
            result.add(new MinTimeSeq());
            result.add(new SatOpp());
            result.add(new MinTimePar());
            result.add(new SatScenario());
            result.add(new DiffLMH());
            result.add(new PowerCons());
            result.add(new MinSkill());
            result.add(new DiffLMHE());
            result.add(new ProbSucc());
            result.add(new ReachSeq());
            result.add(new MinCost());
        }
        return result;
    }
}

