/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.domains;

import java.util.HashMap;
import java.util.Vector;
import lu.uni.adtool.adtree.ADTNode;
import lu.uni.adtool.adtree.Node;
import lu.uni.adtool.domains.Domain;
import lu.uni.adtool.domains.ValueAssignement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Evaluator<Type> {
    private Domain<Type> domain;
    private HashMap<ADTNode, Type> resultMap = null;

    public Evaluator(Domain<Type> newDomain) {
        this.domain = newDomain;
    }

    public final Type getValue(ADTNode node) {
        if (this.resultMap == null || node == null) {
            return null;
        }
        return this.resultMap.get(node);
    }

    public final boolean reevaluate(ADTNode root, ValueAssignement<Type> newProMap, ValueAssignement<Type> newOppMap) {
        if (newProMap == null || root == null || newOppMap == null) {
            System.out.println("null result");
            return false;
        }
        this.resultMap = new HashMap();
        this.evaluate(root, newProMap, newOppMap);
        return true;
    }

    private Type evaluate(ADTNode root, ValueAssignement<Type> proMap, ValueAssignement<Type> oppMap) {
        Object result = null;
        if (root.getType() == ADTNode.Type.LEAFO) {
            if (oppMap.get(root.getName()) == null) {
                return this.domain.getDefaultValue(false);
            }
            this.resultMap.put(root, oppMap.get(root.getName()));
            return oppMap.get(root.getName());
        }
        if (root.getType() == ADTNode.Type.LEAFP) {
            if (proMap.get(root.getName()) == null) {
                return this.domain.getDefaultValue(true);
            }
            this.resultMap.put(root, proMap.get(root.getName()));
            return proMap.get(root.getName());
        }
        Vector<Node> children = root.getChildren();
        if (children == null) {
            System.err.println("Error in bottom up evaluation - non leaf node without children");
            return null;
        }
        if (children.size() == 0) {
            System.err.println("Error in bottom up evaluation - non leaf node without children");
            return null;
        }
        result = null;
        switch (root.getType()) {
            case OO: {
                for (Node c : children) {
                    if (result == null) {
                        result = this.evaluate((ADTNode)children.elementAt(0), proMap, oppMap);
                        continue;
                    }
                    result = this.domain.oo(result, this.evaluate((ADTNode)c, proMap, oppMap));
                }
                break;
            }
            case AO: {
                for (Node c : children) {
                    if (result == null) {
                        result = this.evaluate((ADTNode)children.elementAt(0), proMap, oppMap);
                        continue;
                    }
                    result = this.domain.ao(result, this.evaluate((ADTNode)c, proMap, oppMap));
                }
                break;
            }
            case OP: {
                for (Node c : children) {
                    if (result == null) {
                        result = this.evaluate((ADTNode)children.elementAt(0), proMap, oppMap);
                        continue;
                    }
                    result = this.domain.op(result, this.evaluate((ADTNode)c, proMap, oppMap));
                }
                break;
            }
            case AP: {
                for (Node c : children) {
                    if (result == null) {
                        result = this.evaluate((ADTNode)children.elementAt(0), proMap, oppMap);
                        continue;
                    }
                    result = this.domain.ap(result, this.evaluate((ADTNode)c, proMap, oppMap));
                }
                break;
            }
            case CO: {
                if (children.size() != 2) {
                    System.err.println("Error in bottom up evaluation -  counter node with more than 2 children.");
                    return null;
                }
                result = this.domain.co(this.evaluate((ADTNode)children.elementAt(0), proMap, oppMap), this.evaluate((ADTNode)children.elementAt(1), proMap, oppMap));
                break;
            }
            case CP: {
                if (children.size() != 2) {
                    System.err.println("Error in bottom up evaluation - counter node with more than 2 children.");
                    return null;
                }
                result = this.domain.cp(this.evaluate((ADTNode)children.elementAt(0), proMap, oppMap), this.evaluate((ADTNode)children.elementAt(1), proMap, oppMap));
                break;
            }
            default: {
                System.err.println("Error in bottom up evaluation - Unknown node type.");
                return null;
            }
        }
        this.resultMap.put(root, result);
        return result;
    }
}

