/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.domains.rings;

import java.io.Serializable;
import lu.uni.adtool.domains.rings.Ring;

public class BoundedInteger
implements Serializable,
Ring {
    static final long serialVersionUID = 94244625469424462L;
    public static int INF = -1;
    private int value;
    private int bound;

    public BoundedInteger(int k, int b) {
        this.value = k;
        this.bound = b;
        this.checkValue();
    }

    public Object clone() {
        return new BoundedInteger(this.value, this.bound);
    }

    public final int getValue() {
        return this.value;
    }

    public final int getBound() {
        return this.bound;
    }

    public static BoundedInteger sum(BoundedInteger a, BoundedInteger b) {
        if (a.getValue() == INF || b.getValue() == INF) {
            return new BoundedInteger(INF, Math.min(a.getBound(), b.getBound()));
        }
        return new BoundedInteger(a.getValue() + b.getValue(), Math.min(a.getBound(), b.getBound()));
    }

    public static BoundedInteger max(BoundedInteger a, BoundedInteger b) {
        if (a.getValue() == INF || b.getValue() == INF) {
            return new BoundedInteger(INF, Math.min(a.getBound(), b.getBound()));
        }
        return new BoundedInteger(Math.max(a.getValue(), b.getValue()), Math.min(a.getBound(), b.getBound()));
    }

    public static BoundedInteger min(BoundedInteger a, BoundedInteger b) {
        if (a.getValue() == INF) {
            return new BoundedInteger(b.getValue(), Math.min(a.getBound(), b.getBound()));
        }
        if (b.getValue() == INF) {
            return new BoundedInteger(a.getValue(), Math.min(a.getBound(), b.getBound()));
        }
        return new BoundedInteger(Math.min(a.getValue(), b.getValue()), Math.min(a.getBound(), b.getBound()));
    }

    public final String toString() {
        if (this.getValue() == -1) {
            return "Infinity";
        }
        return new Integer(this.getValue()).toString();
    }

    public final String toUnicode() {
        if (this.getValue() == -1) {
            return "\u221e";
        }
        return new Integer(this.getValue()).toString();
    }

    public final boolean updateFromString(String s) {
        this.value = Integer.parseInt(s);
        return this.checkValue();
    }

    private boolean checkValue() {
        if (this.value < -1) {
            this.value = 0;
            return false;
        }
        if (this.value > this.bound) {
            this.value = this.bound;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        if (o instanceof BoundedInteger) {
            int val2 = ((BoundedInteger)o).getValue();
            if (this.value == val2) {
                return 0;
            }
            if (this.value < val2) {
                return -1;
            }
            if (this.value > val2) {
                return 1;
            }
        }
        throw new ClassCastException("Unable to compare BoundedInteger class with " + o);
    }
}

