/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.domains.rings;

import java.io.Serializable;
import lu.uni.adtool.domains.rings.RealG0;
import lu.uni.adtool.domains.rings.Ring;

public class RealZeroOne
implements Serializable,
Ring {
    static final long serialVersionUID = 145654787766564466L;
    private double value;

    public RealZeroOne() {
        this(0.0);
    }

    public RealZeroOne(double d) {
        this.value = d;
        this.checkValue();
    }

    public Object clone() {
        return new RealZeroOne(this.value);
    }

    public final boolean updateFromString(String s) {
        this.value = Double.parseDouble(s);
        return this.checkValue();
    }

    public final String toString() {
        return new Double(this.value).toString();
    }

    public final String toUnicode() {
        return this.toString();
    }

    public static final RealZeroOne plusProb(RealZeroOne a, RealZeroOne b) {
        double x = a.getValue();
        double y = b.getValue();
        return new RealZeroOne(x + y - x * y);
    }

    public static final RealZeroOne minusProb(RealZeroOne a, RealZeroOne b) {
        double x = a.getValue();
        double y = b.getValue();
        return new RealZeroOne(x * (1.0 - y));
    }

    public static final RealZeroOne times(RealZeroOne a, RealZeroOne b) {
        double x = a.getValue();
        double y = b.getValue();
        return new RealZeroOne(x * y);
    }

    public double getValue() {
        return this.value;
    }

    private boolean checkValue() {
        if (this.value < 0.0) {
            this.value = 0.0;
            return false;
        }
        if (this.value > 1.0) {
            this.value = 1.0;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        double val2;
        if (o instanceof RealZeroOne) {
            val2 = ((RealZeroOne)o).getValue();
            if (this.value == val2) {
                return 0;
            }
            if (this.value < val2) {
                return -1;
            }
            if (this.value > val2) {
                return 1;
            }
        }
        if (o instanceof RealG0) {
            val2 = ((RealG0)o).getValue();
            if (this.value == val2) {
                return 0;
            }
            if (this.value < val2) {
                return -1;
            }
            if (this.value > val2) {
                return 1;
            }
        }
        throw new ClassCastException("Unable to compare RealZeroOne class with " + o);
    }
}

