/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import lu.uni.adtool.adtree.ADTreeNode;
import lu.uni.adtool.ui.ADTreeCanvas;
import lu.uni.adtool.ui.CanvasHandler;

public abstract class AbstractCanvasHandler
implements CanvasHandler {
    protected ADTreeCanvas canvas;
    private Point2D dragStart;
    private boolean dragScroll;

    public AbstractCanvasHandler(ADTreeCanvas canvas) {
        this.canvas = canvas;
        this.dragStart = null;
        this.dragScroll = false;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        JScrollPane scrollPane = this.canvas.getScrollPane();
        int notches = e.getWheelRotation();
        Rectangle pos = scrollPane.getViewport().getViewRect();
        double scale = this.canvas.getScale();
        JScrollBar bar = scrollPane.getHorizontalScrollBar();
        if (bar.isVisible() && (double)e.getY() > pos.getHeight() && (double)e.getY() < pos.getHeight() + (double)bar.getPreferredSize().height) {
            bar.setValue(bar.getValue() + (int)(scale * (double)((float)notches + 4.0f * Math.signum(notches)) + (double)Math.signum(notches)));
            return;
        }
        bar = scrollPane.getVerticalScrollBar();
        if (bar.isVisible() && (double)e.getX() > pos.getWidth() && (double)e.getX() < pos.getWidth() + (double)bar.getPreferredSize().width) {
            bar.setValue(bar.getValue() + (int)(scale * (double)((float)notches + 4.0f * Math.signum(notches)) + (double)Math.signum(notches)));
            return;
        }
        if (notches < 0) {
            this.canvas.zoomIn();
        } else {
            this.canvas.zoomOut();
        }
        scale = this.canvas.getScale() / scale;
        int xPos = (int)(pos.getX() + (pos.getX() + (double)e.getX()) * (scale - 1.0));
        int yPos = (int)(pos.getY() + (pos.getY() + (double)e.getY()) * (scale - 1.0));
        int moveX = 0;
        int moveY = 0;
        BoundedRangeModel mX = scrollPane.getHorizontalScrollBar().getModel();
        BoundedRangeModel mY = scrollPane.getVerticalScrollBar().getModel();
        double maxScrollX = mX.getMaximum() - mX.getExtent();
        double maxScrollY = mY.getMaximum() - mY.getExtent();
        if ((double)xPos > maxScrollX) {
            moveX = xPos - (int)maxScrollX;
            xPos = (int)maxScrollX;
        } else if (xPos < 0) {
            moveX = xPos;
            xPos = 0;
        }
        if ((double)yPos > maxScrollY) {
            moveY = yPos - (int)maxScrollY;
            yPos = (int)maxScrollY;
        } else if (yPos < 0) {
            moveY = yPos;
            yPos = 0;
        }
        scrollPane.getViewport().setViewPosition(new Point(xPos, yPos));
        this.canvas.moveTree((double)(-moveX) / this.canvas.getScale(), (double)(-moveY) / this.canvas.getScale());
    }

    public void keyPressed(KeyEvent e) {
        ADTreeNode node = this.canvas.getFocused();
        if (e.isControlDown() && node != null) {
            switch (e.getKeyCode()) {
                case 84: {
                    break;
                }
                case 61: 
                case 107: 
                case 521: {
                    this.canvas.zoomIn();
                    break;
                }
                case 45: 
                case 109: {
                    this.canvas.zoomOut();
                    break;
                }
                case 79: {
                    this.canvas.resetZoom();
                    break;
                }
            }
        } else {
            ADTreeNode tempNode = null;
            switch (e.getKeyCode()) {
                case 38: {
                    tempNode = this.canvas.getParentNode(node);
                    break;
                }
                case 37: {
                    tempNode = this.canvas.getLeftSibling(node);
                    break;
                }
                case 39: {
                    tempNode = this.canvas.getRightSibling(node);
                    break;
                }
                case 40: {
                    tempNode = this.canvas.getMiddleChild(node);
                    break;
                }
            }
            if (tempNode != null) {
                this.setFocus(tempNode);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.dragStart = new Point(e.getX(), e.getY());
        if (this.canvas.getNode(e.getX(), e.getY()) != null) {
            this.canvas.setCursor(Cursor.getPredefinedCursor(12));
            this.dragScroll = false;
        } else {
            this.canvas.setCursor(Cursor.getPredefinedCursor(13));
            this.dragScroll = true;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.dragStart != null) {
            if (this.dragScroll) {
                Point p = this.canvas.scrollTo((double)e.getX() - this.dragStart.getX(), (double)e.getY() - this.dragStart.getY());
                this.dragStart = new Point(e.getX(), e.getY());
                ((Point)this.dragStart).translate((int)(-p.getX()), (int)(-p.getY()));
            } else {
                Point2D p = new Point(e.getX(), e.getY());
                p = this.canvas.transform(p);
                Point2D p2 = this.canvas.transform(this.dragStart);
                this.canvas.moveTree(p.getX() - p2.getX(), p.getY() - p2.getY());
                this.dragStart = new Point(e.getX(), e.getY());
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.dragStart = null;
        this.dragScroll = true;
        this.canvas.setCursor(Cursor.getPredefinedCursor(0));
        this.canvas.repaint();
    }

    public void setFocus(ADTreeNode node) {
        this.canvas.setFocus(node);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.canvas.setViewPortSize(((JScrollPane)e.getComponent()).getViewport().getExtentSize());
    }

    public void componentShown(ComponentEvent e) {
    }
}

