/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lu.uni.adtool.domains.Domain;
import lu.uni.adtool.ui.MainWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddDomainDialog
extends JDialog
implements ActionListener,
ListSelectionListener,
Comparator<Domain> {
    private static final long serialVersionUID = 1848945612200055156L;
    private MainWindow frame;
    private JList list;
    private JButton setButton;
    private JLabel description;
    private Domain<?> chosenDomain = null;
    private boolean selectPressed = false;
    private Vector<Domain<?>> ds;

    public AddDomainDialog(MainWindow newParent) {
        super(newParent, "Add Attribute Domain", true);
        this.frame = newParent;
        this.setAlwaysOnTop(true);
        this.setLocationRelativeTo(this.frame);
        this.setLocation(60, 60);
    }

    public Domain showDomainDialog(Vector<Domain<?>> domains) {
        this.ds = domains;
        Collections.sort(this.ds, this);
        this.createLayout();
        this.setVisible(true);
        if (!this.selectPressed) {
            this.setValue(-1);
        }
        return this.chosenDomain;
    }

    @Override
    public int compare(Domain d1, Domain d2) {
        return d1.getName().compareTo(d2.getName());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.setButton.setEnabled(false);
            } else {
                this.setValue(this.list.getSelectedIndex());
                this.setButton.setEnabled(true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("Add".equals(e.getActionCommand())) {
            this.selectPressed = true;
        }
        this.dispose();
    }

    private void createLayout() {
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        this.setButton = new JButton("Add");
        this.setButton.setActionCommand("Add");
        this.setButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.setButton);
        this.list = new JList(this.getDomainsAsArray(this.ds)){
            private static final long serialVersionUID = 3976580603641311787L;

            public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                int row;
                if (orientation == 1 && direction < 0 && (row = this.getFirstVisibleIndex()) != -1) {
                    Rectangle r = this.getCellBounds(row, row);
                    if (r.y == visibleRect.y && row != 0) {
                        Point loc = r.getLocation();
                        --loc.y;
                        int prevIndex = this.locationToIndex(loc);
                        Rectangle prevR = this.getCellBounds(prevIndex, prevIndex);
                        if (prevR == null || prevR.y >= r.y) {
                            return 0;
                        }
                        return prevR.height;
                    }
                }
                return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
            }
        };
        this.list.setSelectionMode(0);
        this.list.setVisibleRowCount(15);
        this.list.setSelectedIndex(0);
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AddDomainDialog.this.setButton.doClick();
                }
            }
        });
        this.list.addListSelectionListener(this);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(500, 80));
        listScroller.setAlignmentX(0.0f);
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 3));
        JLabel label = new JLabel("Domain Name:");
        label.setLabelFor(this.list);
        listPane.add(label);
        listPane.add(Box.createRigidArea(new Dimension(0, 5)));
        listPane.add(listScroller);
        listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.description = new JLabel("Not initialised!"){
            private static final long serialVersionUID = -1965044192759316872L;

            public Dimension getPreferredSize() {
                return new Dimension(450, 350);
            }

            public Dimension getMinimumSize() {
                return new Dimension(450, 350);
            }

            public Dimension getMaximumSize() {
                return new Dimension(450, 350);
            }
        };
        this.description.setVerticalAlignment(1);
        this.description.setFont(new Font("Sans", 0, 13));
        this.description.setHorizontalAlignment(2);
        JScrollPane descPane = new JScrollPane(this.description);
        descPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createTitledBorder("Details:")));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(cancelButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(this.setButton);
        Container contentPane = this.getContentPane();
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 2));
        content.add(listPane);
        content.add(descPane);
        contentPane.add((Component)content, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.setValue(0);
        this.pack();
    }

    private void setValue(int i) {
        if (0 <= i && i < this.ds.size()) {
            this.chosenDomain = this.ds.elementAt(i);
            this.list.setSelectedValue(this.chosenDomain, true);
            this.description.setText(this.chosenDomain.getDescription().replaceAll("2147483647", "k"));
        } else {
            this.chosenDomain = null;
            this.description.setText("Nothing is chosen.");
        }
    }

    private String[] getDomainsAsArray(Vector<Domain<?>> ds2) {
        String[] result = new String[ds2.size()];
        for (int i = 0; i < ds2.size(); ++i) {
            result[i] = ds2.elementAt(i).getName();
        }
        return result;
    }

    @Override
    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddDomainDialog.this.setValue(-1);
                AddDomainDialog.this.dispose();
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }
}

