/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import lu.uni.adtool.domains.rings.BoundedInteger;
import lu.uni.adtool.ui.InputDialog;

public class BoundedIntegerDialog
extends InputDialog {
    static final long serialVersionUID = 35393957497521213L;
    protected JButton infButton;

    public BoundedIntegerDialog(Frame frame) {
        super(frame, "Enter a non-negative integer number");
        this.infButton = null;
    }

    public BoundedIntegerDialog(Frame frame, String title) {
        super(frame, title);
    }

    public void actionPerformed(ActionEvent e) {
        if ("-100".equals(e.getActionCommand())) {
            this.add(-100);
        } else if ("-10".equals(e.getActionCommand())) {
            this.add(-10);
        } else if ("-1".equals(e.getActionCommand())) {
            this.add(-1);
        } else if ("+1".equals(e.getActionCommand())) {
            this.add(1);
        } else if ("+10".equals(e.getActionCommand())) {
            this.add(10);
        } else if ("+100".equals(e.getActionCommand())) {
            this.add(100);
        } else if ("/1000".equals(e.getActionCommand())) {
            this.divide(1000);
        } else if ("/100".equals(e.getActionCommand())) {
            this.divide(100);
        } else if ("/10".equals(e.getActionCommand())) {
            this.divide(10);
        } else if ("x10".equals(e.getActionCommand())) {
            this.times(10);
        } else if ("x100".equals(e.getActionCommand())) {
            this.times(100);
        } else if ("x1000".equals(e.getActionCommand())) {
            this.times(1000);
        } else if ("Infinity".equals(e.getActionCommand())) {
            this.valueField.setValue(new Double(Double.POSITIVE_INFINITY));
            this.sync();
        } else if ("Zero".equals(e.getActionCommand())) {
            this.valueField.setValue(new Double(0.0));
            this.sync();
        } else {
            super.actionPerformed(e);
        }
    }

    protected boolean isValid(double d) {
        boolean isValid = false;
        int bound = ((BoundedInteger)this.value).getBound();
        if (new Double(d).isInfinite()) {
            isValid = false;
        } else if (d >= 0.0 && d <= (double)bound) {
            isValid = true;
        }
        return isValid;
    }

    protected final void setValue(double d) {
        int bound = ((BoundedInteger)this.value).getBound();
        this.value = new Double(d).isInfinite() ? new BoundedInteger(BoundedInteger.INF, bound) : new BoundedInteger((int)d, bound);
        this.valueField.setValue(d);
    }

    protected void createLayout(boolean showDefault) {
        int bound = ((BoundedInteger)this.value).getBound();
        this.errorMsg.setText("Please enter an integer between 0 and " + bound + ".");
        NumberFormat f = NumberFormat.getInstance();
        f.setParseIntegerOnly(true);
        this.valueField = new JFormattedTextField(f);
        this.valueField.addKeyListener(this);
        double d = new Double(((BoundedInteger)this.value).getValue());
        if (d == (double)BoundedInteger.INF) {
            d = Double.POSITIVE_INFINITY;
        }
        if (showDefault) {
            this.valueField.setValue(d);
        }
        this.valueField.setColumns(15);
        this.valueField.addPropertyChangeListener("value", this);
        JPanel inputPane = new JPanel();
        inputPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 8, 0, 0);
        c.gridy = 0;
        c.gridx = 0;
        JButton button = new JButton("-100");
        button.setActionCommand("-100");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 1;
        button = new JButton("-10");
        button.setActionCommand("-10");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 2;
        button = new JButton("-1");
        button.setActionCommand("-1");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 3;
        c.gridwidth = 2;
        inputPane.add((Component)this.valueField, c);
        c.gridwidth = 1;
        c.gridx = 5;
        button = new JButton("+1");
        button.setActionCommand("+1");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 6;
        button = new JButton("+10");
        button.setActionCommand("+10");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 7;
        button = new JButton("+100");
        button.setActionCommand("+100");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridy = 1;
        c.gridx = 0;
        button = new JButton("/1000");
        button.setActionCommand("/1000");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 1;
        button = new JButton("/100");
        button.setActionCommand("/100");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 2;
        button = new JButton("/10");
        button.setActionCommand("/10");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 3;
        button = new JButton("Zero");
        button.setActionCommand("Zero");
        button.addActionListener(this);
        if (this.infButton != null) {
            inputPane.add((Component)button, c);
            c.gridx = 4;
            this.infButton.setActionCommand("Infinity");
            this.infButton.addActionListener(this);
            inputPane.add((Component)this.infButton, c);
        } else {
            c.gridwidth = 2;
            inputPane.add((Component)button, c);
            c.gridwidth = 1;
        }
        c.gridx = 5;
        button = new JButton("x10");
        button.setActionCommand("x10");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 6;
        button = new JButton("x100");
        button.setActionCommand("x100");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 7;
        button = new JButton("x1000");
        button.setActionCommand("x1000");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        this.contentPane.add((Component)inputPane, "Center");
        this.pack();
    }

    private void add(int i) {
        Number num = (Number)this.valueField.getValue();
        if (num == null) {
            return;
        }
        double d = num.doubleValue();
        if (!this.isValid(d + (double)i) || d == Double.POSITIVE_INFINITY) {
            return;
        }
        this.setValue(d += (double)i);
    }

    private void times(int i) {
        Number num = (Number)this.valueField.getValue();
        if (num == null) {
            return;
        }
        double d = num.doubleValue();
        if (!this.isValid(d * (double)i) || d == Double.POSITIVE_INFINITY) {
            return;
        }
        this.setValue(d *= (double)i);
    }

    private void divide(int i) {
        Number num = (Number)this.valueField.getValue();
        if (num == null) {
            return;
        }
        double d = num.doubleValue();
        if (!this.isValid((int)d / i) || d == Double.POSITIVE_INFINITY) {
            return;
        }
        d = (int)d / i;
        this.setValue(d);
    }
}

