/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.Color;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import lu.uni.adtool.Options;
import lu.uni.adtool.adtree.ADTNode;
import lu.uni.adtool.adtree.ADTreeForGui;
import lu.uni.adtool.adtree.ADTreeNode;
import lu.uni.adtool.domains.Domain;
import lu.uni.adtool.domains.ValuationDomain;
import lu.uni.adtool.domains.ValueAssignement;
import lu.uni.adtool.domains.rings.Bool;
import lu.uni.adtool.domains.rings.BoundedInteger;
import lu.uni.adtool.domains.rings.LMHEValue;
import lu.uni.adtool.domains.rings.LMHValue;
import lu.uni.adtool.domains.rings.RealG0;
import lu.uni.adtool.domains.rings.RealZeroOne;
import lu.uni.adtool.domains.rings.Ring;
import lu.uni.adtool.ui.ADTreeCanvas;
import lu.uni.adtool.ui.BoundedIntegerDialog;
import lu.uni.adtool.ui.DomainCanvasHandler;
import lu.uni.adtool.ui.InputDialog;
import lu.uni.adtool.ui.LMHDialog;
import lu.uni.adtool.ui.LMHEDialog;
import lu.uni.adtool.ui.MainWindow;
import lu.uni.adtool.ui.RealG0Dialog;
import lu.uni.adtool.ui.RealZeroOneDialog;
import lu.uni.adtool.ui.ValuationView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainCanvas<Type>
extends ADTreeCanvas {
    static final long serialVersionUID = 745558011570251703L;
    private boolean showLabels;
    private InputDialog dialog;
    private boolean markEditable;
    private HashSet<String> markedPro = new HashSet();
    private HashSet<String> markedOpp = new HashSet();

    public DomainCanvas(ADTreeForGui newTree, MainWindow mw, int newId) {
        super(newTree, mw, newId);
        this.treeChanged();
        this.dialog = null;
        this.markEditable = true;
    }

    public void editValue(ADTreeNode node) {
        ValuationDomain<Ring> valuationDomain = this.mainWindow.getValuation(this.getId());
        if (node.getTerm().isEditable(valuationDomain.getDomain())) {
            Ring value = valuationDomain.getValue(node);
            if (value instanceof Bool) {
                value = Bool.not((Bool)value);
            } else if (value instanceof RealG0) {
                this.dialog = new RealG0Dialog(this.getMainWindow());
                value = this.dialog.showInputDialog(value);
            } else if (value instanceof RealZeroOne) {
                this.dialog = new RealZeroOneDialog(this.getMainWindow());
                value = this.dialog.showInputDialog(value);
            } else if (value instanceof LMHValue) {
                this.dialog = new LMHDialog(this.getMainWindow());
                value = this.dialog.showInputDialog(value);
            } else if (value instanceof LMHEValue) {
                this.dialog = new LMHEDialog(this.getMainWindow());
                value = this.dialog.showInputDialog(value);
            } else if (value instanceof BoundedInteger) {
                this.dialog = new BoundedIntegerDialog(this.getMainWindow());
                value = this.dialog.showInputDialog(value);
            }
            if (value != null) {
                String key = node.getTerm().getName();
                this.putNewValue(node.getType() == ADTreeNode.Type.PROPONENT, key, value);
                this.valuesUpdated();
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DomainCanvas.this.requestFocus();
            }
        });
    }

    public void putNewValue(boolean proponent, String key, Ring value) {
        this.mainWindow.getValuation(this.getId()).setValue(proponent, key, value);
    }

    public void refreshAllValues() {
        this.mainWindow.getValuation(this.getId()).refreshAllValues(this.tree.getRoot(true));
    }

    public void valuesUpdated() {
        ValuationDomain<Ring> valuationDomain = this.mainWindow.getValuation(this.getId());
        valuationDomain.valuesUpdated(this.tree.getRoot(true));
        ValuationView valuationView = (ValuationView)this.getMainWindow().getViews()[2].getComponent();
        if (valuationView.getCanvas() == this) {
            valuationView.assignCanvas(this);
        }
        this.tree.updateAllSizes();
        this.repaint();
    }

    @Override
    protected void addListener() {
        this.listener = new DomainCanvasHandler(this);
        this.addMouseListener(this.listener);
        this.addMouseMotionListener(this.listener);
        this.addKeyListener(this.listener);
    }

    @Override
    public void sizeChanged() {
        this.recalculateLayout();
    }

    @Override
    public void treeChanged() {
        this.mainWindow.getValuation(this.getId()).treeChanged(this.tree.getRoot(true));
        ValuationView valuationView = (ValuationView)this.getMainWindow().getViews()[2].getComponent();
        if (valuationView.getCanvas() != null && valuationView.getCanvas().getId() == this.getId()) {
            valuationView.assignCanvas(this);
        }
        this.tree.updateAllSizes();
    }

    public Domain<Type> getDomain() {
        return this.mainWindow.getValuation(this.getId()).getDomain();
    }

    public void setValueAssPro(ValueAssignement<Type> newValueAss) {
        this.mainWindow.getValuation(this.getId()).setValueAssPro(newValueAss, this.tree.getRoot(true));
    }

    public void setValueAssOpp(ValueAssignement<Type> newValueAss) {
        this.mainWindow.getValuation(this.getId()).setValueAssOpp(newValueAss, this.tree.getRoot(true));
    }

    public ValueAssignement<Type> getValueAssPro() {
        return this.mainWindow.getValuation(this.getId()).getValueAssPro();
    }

    public ValueAssignement<Type> getValueAssOpp() {
        return this.mainWindow.getValuation(this.getId()).getValueAssOpp();
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
        this.tree.updateAllSizes();
        this.repaint();
    }

    public boolean isShowAllLabels() {
        return this.mainWindow.getValuation(this.getId()).isShowAllLabels();
    }

    public void setShowAllLabels(boolean showAllLabels) {
        this.mainWindow.getValuation(this.getId()).setShowAllLabels(showAllLabels);
        this.tree.updateAllSizes();
        this.repaint();
    }

    public InputDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(InputDialog dialog) {
        this.dialog = dialog;
    }

    public boolean isMarkEditable() {
        return this.markEditable;
    }

    public void setMarkEditable(boolean markEditable) {
        this.markEditable = markEditable;
        this.repaint();
    }

    public boolean isMarked(ADTreeNode node) {
        if (node.getType() == ADTreeNode.Type.PROPONENT) {
            return this.markedPro.contains(node.getLabel());
        }
        return this.markedOpp.contains(node.getLabel());
    }

    @Override
    protected String getFillColorS(ADTreeNode node) {
        if (this.isMarked(node)) {
            return "markedFill";
        }
        if (this.markEditable && node.getTerm().isEditable(this.getDomain())) {
            return "editableFill";
        }
        return super.getFillColorS(node);
    }

    @Override
    protected Color getFillColor(ADTreeNode node) {
        if (this.isMarked(node)) {
            return Options.canv_MarkedColor;
        }
        if (this.markEditable && node.getTerm().isEditable(this.getDomain())) {
            return Options.canv_EditableColor;
        }
        return super.getFillColor(node);
    }

    @Override
    public String getLabel(ADTreeNode node) {
        ADTNode term;
        ValuationDomain<Ring> valuationDomain = this.mainWindow.getValuation(this.getId());
        if (node == null) {
            return "Null node";
        }
        String result = this.showLabels ? node.getLabel() + "\n" : "";
        Ring value = null;
        if (valuationDomain.hasEvaluator() && (term = node.getTerm()) != null) {
            if ((term.getType() == ADTNode.Type.CP || term.getType() == ADTNode.Type.CO) && ((ADTNode)term.getChildren().elementAt(0)).getChildren().size() == 0) {
                if (this.isShowAllLabels()) {
                    value = valuationDomain.getTermValue(node.getTerm());
                    result = result + this.toUnicode(value) + "\n";
                }
                value = valuationDomain.getTermValue((ADTNode)term.getChildren().elementAt(0));
            } else {
                value = valuationDomain.getTermValue(node.getTerm());
            }
            result = result + this.toUnicode(value);
        }
        return result;
    }

    public void markPro(String label) {
        this.markedPro.add(label);
    }

    public void unmarkPro(String label) {
        this.markedPro.remove(label);
    }

    public void markOpp(String label) {
        this.markedOpp.add(label);
    }

    public void unmarkOpp(String label) {
        this.markedOpp.remove(label);
    }

    public void unmarkAll() {
        this.markedPro.clear();
        this.markedOpp.clear();
    }

    private String toUnicode(Ring value) {
        if (value == null) {
            return "null";
        }
        return value.toUnicode();
    }

    @Override
    public String toString() {
        String result = super.toString();
        result = result + " id=" + this.getId();
        return result;
    }
}

