/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import lu.uni.adtool.adtree.ADTreeNode;
import lu.uni.adtool.domains.Domain;
import lu.uni.adtool.ui.AbstractCanvasHandler;
import lu.uni.adtool.ui.DomainCanvas;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainCanvasHandler<Type>
extends AbstractCanvasHandler {
    private JPopupMenu pmenu;
    private ADTreeNode menuNode;
    private JMenuItem editValueItem;
    private JMenuItem toggleAboveFold;
    private JSeparator separator;
    private JMenuItem toggleFold;

    public DomainCanvasHandler(DomainCanvas<Type> canvas) {
        super(canvas);
        this.initPopupMenu();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        boolean consume;
        block14: {
            ADTreeNode node;
            block15: {
                block13: {
                    consume = true;
                    node = this.canvas.getFocused();
                    if (node == null) {
                        return;
                    }
                    this.menuNode = node;
                    if (!e.isControlDown()) break block13;
                    consume = false;
                    break block14;
                }
                if (!e.isShiftDown()) break block15;
                switch (e.getKeyCode()) {
                    case 32: {
                        if (node != null) {
                            this.menuNode = node;
                            this.canvas.toggleAboveFold(this.menuNode);
                            break;
                        }
                        break block14;
                    }
                    default: {
                        consume = false;
                        break;
                    }
                }
                break block14;
            }
            switch (e.getKeyCode()) {
                case 10: {
                    if (node == null) break;
                    this.menuNode = node;
                    this.changeValueActionPerformed();
                    break;
                }
                case 61: 
                case 107: 
                case 521: {
                    this.canvas.zoomIn();
                    break;
                }
                case 45: 
                case 109: {
                    this.canvas.zoomOut();
                    break;
                }
                case 79: {
                    this.canvas.resetZoom();
                    break;
                }
                case 32: {
                    if (node == null) break;
                    this.menuNode = node;
                    this.canvas.toggleFold(this.menuNode);
                    break;
                }
                default: {
                    consume = false;
                }
            }
        }
        if (!consume) {
            super.keyPressed(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.canvas.requestFocusInWindow();
        ADTreeNode node = this.canvas.getNode(e.getX(), e.getY());
        if (node != null) {
            if (e.getModifiers() == 4 || e.getModifiers() == 2) {
                this.menuNode = node;
                this.pmenu.show(e.getComponent(), e.getX(), e.getY());
                this.setFocus(node);
            } else if (node.equals(this.canvas.getFocused())) {
                this.menuNode = node;
                ((DomainCanvas)this.canvas).editValue(this.menuNode);
            } else {
                this.setFocus(node);
            }
        }
    }

    @Override
    public void setFocus(ADTreeNode node) {
        if (node != null) {
            boolean canFoldAbove;
            boolean canFold;
            Domain d = ((DomainCanvas)this.canvas).getDomain();
            this.editValueItem.setEnabled(node.getTerm().isEditable(d));
            if (node.isFolded()) {
                this.toggleFold.setText("Expand Below");
                canFold = true;
            } else {
                this.toggleFold.setText("Fold Below");
                boolean bl = canFold = this.canvas.getTree().getChildrenList(node, false).size() > 0;
            }
            if (node.isAboveFolded()) {
                this.toggleAboveFold.setText("Expand Above");
                canFoldAbove = true;
            } else {
                this.toggleAboveFold.setText("Fold Above");
                canFoldAbove = this.canvas.getTree().getParent(node, false) != null;
            }
            this.toggleAboveFold.setVisible(canFoldAbove);
            this.toggleFold.setVisible(canFold);
            this.separator.setVisible(canFold && canFoldAbove);
            this.pmenu.pack();
        }
        super.setFocus(node);
    }

    private void initPopupMenu() {
        this.menuNode = null;
        this.pmenu = new JPopupMenu();
        this.editValueItem = new JMenuItem("Edit Assigned Value");
        this.editValueItem.setAccelerator(KeyStroke.getKeyStroke('\n'));
        this.editValueItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DomainCanvasHandler.this.changeValueActionPerformed();
            }
        });
        this.pmenu.add(this.editValueItem);
        this.separator = new JSeparator();
        this.pmenu.add(this.separator);
        this.toggleAboveFold = new JMenuItem("Fold Above");
        this.toggleAboveFold.setAccelerator(KeyStroke.getKeyStroke(32, 1));
        this.toggleAboveFold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (DomainCanvasHandler.this.menuNode != null) {
                    DomainCanvasHandler.this.canvas.toggleAboveFold(DomainCanvasHandler.this.menuNode);
                }
            }
        });
        this.pmenu.add(this.toggleAboveFold);
        this.toggleFold = new JMenuItem("Fold Below");
        this.toggleFold.setAccelerator(KeyStroke.getKeyStroke(32, 0, true));
        this.toggleFold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (DomainCanvasHandler.this.menuNode != null) {
                    DomainCanvasHandler.this.canvas.toggleFold(DomainCanvasHandler.this.menuNode);
                }
            }
        });
        this.pmenu.add(this.toggleFold);
    }

    private void changeValueActionPerformed() {
        if (this.menuNode != null) {
            ((DomainCanvas)this.canvas).editValue(this.menuNode);
        }
    }
}

