/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import lu.uni.adtool.Options;
import lu.uni.adtool.ui.ADTreeView;
import lu.uni.adtool.ui.MainWindow;
import lu.uni.adtool.ui.StatusLine;

public class FileHandler {
    protected StatusLine statusLine;
    protected String treeFileName = null;
    protected Frame mainWindow;
    protected JFileChooser fc;
    protected JCheckBox saveLayout;
    protected JCheckBox exportDomains;
    protected JCheckBox exportCalculatedValues;
    private String tempFileName = "";

    public FileHandler(Frame window) {
        this(null, window);
    }

    public FileHandler(StatusLine status, Frame window) {
        this.statusLine = status;
        this.mainWindow = window;
        this.initFileChooser();
    }

    public ObjectOutputStream getSaveTreeStream() {
        this.fc.setAcceptAllFileFilterUsed(true);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("ADTree file", "adt", "ADT", "Adt");
        this.saveLayout.setVisible(true);
        this.exportDomains.setVisible(false);
        this.exportCalculatedValues.setVisible(false);
        this.fc.setSelectedFile(new File(this.getTreeFileNameWithExt("adt")));
        this.fc.setDialogTitle("Save Attack Defence Tree...");
        ObjectOutputStream result = this.getSaveStream(filter);
        if (result != null) {
            this.setTreeFileName(this.tempFileName);
        }
        return result;
    }

    public FileOutputStream getExportTreeStream(String extension) {
        FileNameExtensionFilter filter = null;
        this.exportDomains.setVisible(false);
        this.exportCalculatedValues.setVisible(false);
        this.saveLayout.setVisible(false);
        if (extension.equals("pdf")) {
            filter = new FileNameExtensionFilter("Pdf file", "pdf", "PDF", "Pdf");
        } else if (extension.equals("xml")) {
            filter = new FileNameExtensionFilter("XML file", "xml", "XML", "Xml");
            if (((MainWindow)this.mainWindow).getValuations().size() > 0) {
                this.exportDomains.setVisible(true);
                this.exportCalculatedValues.setVisible(true);
            }
        } else if (extension.equals("png")) {
            filter = new FileNameExtensionFilter("PNG image", "png", "PNG", "Png");
        } else if (extension.equals("jpg")) {
            filter = new FileNameExtensionFilter("JPEG image", "jpg", "JPG", "Jpg", "jpeg", "JPEG", "Jpeg");
        } else if (extension.equals("tex")) {
            filter = new FileNameExtensionFilter("LaTeX file", "tex", "TEX", "Tex", "latex", "LATEX", "LaTeX", "Latex");
        }
        this.fc.setDialogTitle("Export tree...");
        FileOutputStream out = null;
        this.fc.setSelectedFile(new File(this.getTreeFileNameWithExt(extension)));
        this.fc.resetChoosableFileFilters();
        this.fc.setAcceptAllFileFilterUsed(false);
        this.fc.setFileFilter(filter);
        int returnVal = this.fc.showSaveDialog(this.mainWindow);
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            try {
                out = new FileOutputStream(file);
                this.tempFileName = file.getName();
                this.setTreeFileName(this.tempFileName);
                this.statusLine.report("Exported tree to: " + file.getName() + ".");
            }
            catch (FileNotFoundException e) {
                this.statusLine.reportError("File not found:\"" + file.getName() + "\".");
            }
        } else {
            this.statusLine.reportWarning("Export command cancelled by the user.");
        }
        return out;
    }

    public FileInputStream getImportTreeStream(String extension) {
        FileInputStream in = null;
        FileNameExtensionFilter filter = null;
        if (extension.equals("xml")) {
            filter = new FileNameExtensionFilter("Xml file", "xml", "XML", "Xml");
        }
        this.exportDomains.setVisible(false);
        this.exportCalculatedValues.setVisible(false);
        this.saveLayout.setVisible(false);
        this.fc.setDialogTitle("Import tree...");
        this.fc.setSelectedFile(new File(this.getTreeFileNameWithExt(extension)));
        this.fc.resetChoosableFileFilters();
        this.fc.setFileFilter(filter);
        int returnVal = this.fc.showOpenDialog(this.mainWindow);
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            this.tempFileName = file.getName();
            this.setTreeFileName(this.tempFileName);
            try {
                in = new FileInputStream(file);
                this.statusLine.report("Imported tree from: " + file.getName() + ".");
            }
            catch (FileNotFoundException e) {
                this.statusLine.reportError(e.getLocalizedMessage());
            }
        } else {
            this.statusLine.reportWarning("Open command cancelled by the user.");
        }
        return in;
    }

    public ObjectOutputStream getSaveLayoutStream() {
        this.fc.setAcceptAllFileFilterUsed(true);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Layout file", "adl", "ADL", "Adl");
        this.exportDomains.setVisible(false);
        this.exportCalculatedValues.setVisible(false);
        this.saveLayout.setVisible(false);
        this.fc.setSelectedFile(new File(this.getTreeFileNameWithExt("adl")));
        this.fc.setDialogTitle("Save Layout...");
        return this.getSaveStream(filter);
    }

    public ObjectOutputStream getSaveStream(FileFilter filter) {
        ObjectOutputStream out = null;
        this.fc.resetChoosableFileFilters();
        this.fc.setFileFilter(filter);
        int returnVal = this.fc.showSaveDialog(this.mainWindow);
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            try {
                out = new ObjectOutputStream(new FileOutputStream(file));
                this.tempFileName = file.getName();
                this.statusLine.report("Saved to: " + file.getName() + ".");
            }
            catch (FileNotFoundException e) {
                this.statusLine.reportError("File not found:\"" + file.getName() + "\".");
            }
            catch (IOException e) {
                this.statusLine.reportError("There was IO problem opening a file:\"" + file.getName() + "\".");
            }
        } else {
            this.statusLine.reportWarning("Save command cancelled by the user.");
        }
        return out;
    }

    public ObjectInputStream getLoadTreeStream() {
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Tree file", "adt", "ADT", "Adt");
        this.exportDomains.setVisible(false);
        this.exportCalculatedValues.setVisible(false);
        this.saveLayout.setVisible(false);
        this.fc.setSelectedFile(new File(this.getTreeFileNameWithExt("adt")));
        this.fc.setDialogTitle("Load Atack Defence Tree...");
        ObjectInputStream result = this.getLoadStream(filter);
        if (result != null) {
            this.setTreeFileName(this.tempFileName);
        }
        return result;
    }

    public ObjectInputStream getLoadLayoutStream() {
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Layout file", "adl", "ADL", "Adl");
        this.fc.setDialogTitle("Load Layout...");
        this.fc.setSelectedFile(new File(this.getTreeFileNameWithExt("adl")));
        this.exportDomains.setVisible(false);
        this.exportCalculatedValues.setVisible(false);
        this.saveLayout.setVisible(false);
        return this.getLoadStream(filter);
    }

    private ObjectInputStream getLoadStream(FileFilter filter) {
        ObjectInputStream in = null;
        this.fc.resetChoosableFileFilters();
        this.fc.setFileFilter(filter);
        int returnVal = this.fc.showOpenDialog(this.mainWindow);
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            this.tempFileName = file.getName();
            try {
                in = new ObjectInputStream(new FileInputStream(file));
                this.statusLine.report("Loaded tree from file: " + file.getName() + ".");
            }
            catch (FileNotFoundException e) {
                this.statusLine.reportError("File not found.");
            }
            catch (IOException e) {
                this.statusLine.reportError("There was IO problem opening a file:\"" + file.getName() + "\"");
            }
        } else {
            this.statusLine.reportWarning("Open command cancelled by the user.");
        }
        return in;
    }

    private void initFileChooser() {
        JPanel jp = new JPanel();
        this.fc = new JFileChooser(){
            private static final long serialVersionUID = 7266914590804770955L;

            public void approveSelection() {
                File f = this.getSelectedFile();
                if (f.exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(this, "The file exists, overwrite?", "Existing file", 1);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case 1: {
                            return;
                        }
                        case -1: {
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        this.fc.setFileSelectionMode(0);
        JCheckBox showHiddenCheckBox = new JCheckBox();
        this.exportDomains = new JCheckBox();
        this.exportDomains.setText("Include Domains");
        this.exportDomains.setSelected(Options.main_saveDomains);
        this.exportDomains.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                Options.main_saveDomains = source.isSelected();
                if (!Options.main_saveDomains) {
                    Options.main_saveDerivedValues = false;
                    FileHandler.this.exportCalculatedValues.setSelected(Options.main_saveDerivedValues);
                }
                FileHandler.this.exportCalculatedValues.setEnabled(Options.main_saveDomains);
            }
        });
        this.exportCalculatedValues = new JCheckBox();
        this.exportCalculatedValues.setText("Add derived values");
        this.exportCalculatedValues.setSelected(Options.main_saveDerivedValues);
        this.exportCalculatedValues.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                Options.main_saveDerivedValues = source.isSelected();
            }
        });
        this.saveLayout = new JCheckBox();
        this.saveLayout.setText("Include Layout");
        this.saveLayout.setSelected(Options.main_saveLayout);
        this.saveLayout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                Options.main_saveLayout = source.isSelected();
            }
        });
        showHiddenCheckBox.setText("Show hidden files");
        showHiddenCheckBox.setMnemonic(72);
        showHiddenCheckBox.setSelected(!this.fc.isFileHidingEnabled());
        showHiddenCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                boolean showHidden = source.isSelected();
                FileHandler.this.fc.setFileHidingEnabled(!showHidden);
            }
        });
        jp.setLayout(new BoxLayout(jp, 3));
        this.saveLayout.setVisible(true);
        jp.add(this.saveLayout);
        jp.add(showHiddenCheckBox);
        jp.add(this.exportDomains);
        jp.add(this.exportCalculatedValues);
        this.fc.setAccessory(jp);
    }

    public String getTreeFileName() {
        return this.treeFileName;
    }

    public void setTreeFileName(String s) {
        this.treeFileName = s;
    }

    private String getTreeFileNameWithExt(String ext) {
        String s = this.getTreeFileNameForStream();
        if (s.contains(".")) {
            return s.substring(0, s.lastIndexOf(46)) + '.' + ext;
        }
        return s + '.' + ext;
    }

    private String getTreeFileNameForStream() {
        if (this.treeFileName != null) {
            return this.treeFileName;
        }
        String s = ((ADTreeView)((MainWindow)this.mainWindow).getViews(0).getComponent()).getTree().getRoot(true).getLabel();
        s = s.replace(' ', '_');
        return s.replace('\n', '_');
    }
}

