/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import lu.uni.adtool.domains.rings.Ring;

public abstract class InputDialog
extends JDialog
implements ActionListener,
PropertyChangeListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    protected JLabel errorMsg;
    protected Ring value;
    protected JButton setButton;
    protected Container contentPane;
    protected JFormattedTextField valueField;
    protected boolean setPressed = false;

    public InputDialog(Frame frame, String title) {
        super(frame, title, true);
        this.setLocationRelativeTo(frame);
        this.setAlwaysOnTop(true);
        this.setLocation(160, 160);
        this.setSize(800, 600);
        this.createCommonLayout();
    }

    public void actionPerformed(ActionEvent e) {
        if ("Cancel".equals(e.getActionCommand())) {
            this.escPressed();
        } else if ("Set".equals(e.getActionCommand())) {
            this.enterPressed();
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (!this.sync()) {
            // empty if block
        }
    }

    public final Ring showInputDialog(Ring defaultValue) {
        return this.showInputDialog(defaultValue, true);
    }

    public final Ring showInputDialog(Ring defaultValue, boolean showDefault) {
        this.value = defaultValue;
        this.createLayout(showDefault);
        this.valueField.requestFocusInWindow();
        this.setVisible(true);
        if (this.setPressed) {
            return this.value;
        }
        return null;
    }

    protected abstract void createLayout(boolean var1);

    protected abstract boolean isValid(double var1);

    protected abstract void setValue(double var1);

    protected boolean sync() {
        Number num = (Number)this.valueField.getValue();
        if (num == null) {
            return false;
        }
        double d = num.doubleValue();
        if (!this.isValid(d)) {
            return false;
        }
        this.setValue(d);
        return true;
    }

    private void createCommonLayout() {
        this.errorMsg = new JLabel("");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        this.setButton = new JButton("Set");
        this.setButton.setActionCommand("Set");
        this.setButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.setButton);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(cancelButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(this.setButton);
        this.contentPane = this.getContentPane();
        this.contentPane.add((Component)buttonPane, "Last");
    }

    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InputDialog.this.escPressed();
            }
        };
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.enterPressed();
        }
        if (e.getKeyCode() == 27) {
            this.escPressed();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void popup() {
        JOptionPane.showMessageDialog(this, this.errorMsg.getText(), "Wrong number format", 0);
    }

    public void escPressed() {
        this.value = null;
        this.setVisible(false);
    }

    public void enterPressed() {
        try {
            this.valueField.commitEdit();
            if (this.sync()) {
                this.setPressed = true;
                this.setVisible(false);
            } else {
                this.setPressed = false;
                this.popup();
            }
        }
        catch (ParseException e) {
            this.popup();
        }
    }
}

