/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lu.uni.adtool.ui.MainWindow;

public class LoadExampleDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 1223325877545646416L;
    private MainWindow frame;
    private JButton setButton;
    private JList list;
    private JLabel description;
    private final String[] examplesList = new String[]{"Auction Fraud", "RFID Dos Attack", "RFID Communication Block", "Breaking into a Warehouse", "RFID Dos Attack in Warehouse", "Data Confidentiality", "Bank Account"};
    private final String[] examplesFileName = new String[]{"/examples/AuctionFraud.adt", "/examples/RFIDDos.adt", "/examples/RFIDBlock.adt", "/examples/BreakingWarehouse.adt", "/examples/RFIDWarehouse.adt", "/examples/DataConfidentiality.adt", "/examples/BankAccount.adt"};
    private final String[] examplesDesc = new String[]{"An online auction fraud scenario.", "Dos attack on an RFID system.", "How to block communication between RFID reader and tag?", "Breaking and entering into a warehouse.", "Dos attack on an RFID system in a warehouse (large example).", "How to protect data confidentiality?", "How to steal the money from a bank account?"};
    private String result;

    public LoadExampleDialog(MainWindow parentFrame) {
        super(parentFrame, "Choose example to load", true);
        this.frame = parentFrame;
        this.setAlwaysOnTop(true);
        this.setLocationRelativeTo(this.frame);
        this.setLocation(60, 60);
    }

    public String showDialog() {
        this.createLayout();
        this.setVisible(true);
        return this.result;
    }

    public void actionPerformed(ActionEvent e) {
        if ("Cancel".equals(e.getActionCommand())) {
            this.setValue(-1);
        }
        this.dispose();
    }

    private void createLayout() {
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        this.setButton = new JButton("Load");
        this.setButton.setActionCommand("Load");
        this.setButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.setButton);
        this.list = new JList(this.examplesList){
            private static final long serialVersionUID = -5216109258424750213L;

            public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                int row;
                if (orientation == 1 && direction < 0 && (row = this.getFirstVisibleIndex()) != -1) {
                    Rectangle r = this.getCellBounds(row, row);
                    if (r.y == visibleRect.y && row != 0) {
                        Point loc = r.getLocation();
                        --loc.y;
                        int prevIndex = this.locationToIndex(loc);
                        Rectangle prevR = this.getCellBounds(prevIndex, prevIndex);
                        if (prevR == null || prevR.y >= r.y) {
                            return 0;
                        }
                        return prevR.height;
                    }
                }
                return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
            }
        };
        this.list.setSelectionMode(0);
        this.list.setVisibleRowCount(15);
        this.list.setSelectedIndex(0);
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    LoadExampleDialog.this.setButton.doClick();
                }
            }
        });
        this.list.addListSelectionListener(this);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(350, 80));
        listScroller.setAlignmentX(0.0f);
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 3));
        JLabel label = new JLabel("Attack Defense Trees Examples:");
        label.setLabelFor(this.list);
        listPane.add(label);
        listPane.add(Box.createRigidArea(new Dimension(0, 5)));
        listPane.add(listScroller);
        listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.description = new JLabel("Not initialised!"){
            private static final long serialVersionUID = -6683205667737229246L;

            public Dimension getPreferredSize() {
                return new Dimension(400, 300);
            }

            public Dimension getMinimumSize() {
                return new Dimension(400, 300);
            }

            public Dimension getMaximumSize() {
                return new Dimension(400, 300);
            }
        };
        this.description.setVerticalAlignment(1);
        this.description.setFont(new Font("Sans", 0, 13));
        this.description.setHorizontalAlignment(2);
        JScrollPane descPane = new JScrollPane(this.description);
        descPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createTitledBorder("Description:")));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(new JLabel("<html><b>Warning! Current tree will be discarded!</b></html>"));
        buttonPane.add(cancelButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(this.setButton);
        Container contentPane = this.getContentPane();
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 2));
        content.add(listPane);
        content.add(descPane);
        contentPane.add((Component)content, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.setValue(0);
        this.pack();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.setButton.setEnabled(false);
            } else {
                this.setValue(this.list.getSelectedIndex());
                this.setButton.setEnabled(true);
            }
        }
    }

    private void setValue(int i) {
        if (0 <= i && i < this.examplesFileName.length) {
            this.result = this.examplesFileName[i];
            this.list.setSelectedValue(this.examplesList[i], true);
            this.description.setText("<html>" + this.examplesDesc[i] + "<br></html>");
        } else {
            this.result = null;
            this.description.setText("No example is chosen.");
        }
    }
}

