/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultEditorKit;
import lu.uni.adtool.Options;
import lu.uni.adtool.adtree.ADTSerializer;
import lu.uni.adtool.adtree.ADTXmlImport;
import lu.uni.adtool.adtree.ADTreeForGui;
import lu.uni.adtool.adtree.ADTreeNode;
import lu.uni.adtool.domains.Domain;
import lu.uni.adtool.domains.DomainFactory;
import lu.uni.adtool.domains.ValuationDomain;
import lu.uni.adtool.domains.predefined.MinSkill;
import lu.uni.adtool.domains.predefined.Parametrized;
import lu.uni.adtool.domains.rings.BoundedInteger;
import lu.uni.adtool.domains.rings.Ring;
import lu.uni.adtool.ui.ADTermView;
import lu.uni.adtool.ui.ADToolBar;
import lu.uni.adtool.ui.ADTreeCanvas;
import lu.uni.adtool.ui.ADTreeView;
import lu.uni.adtool.ui.AboutDialog;
import lu.uni.adtool.ui.AddDomainDialog;
import lu.uni.adtool.ui.BoundedIntegerDialog;
import lu.uni.adtool.ui.DetailsView;
import lu.uni.adtool.ui.DomainCanvas;
import lu.uni.adtool.ui.DomainView;
import lu.uni.adtool.ui.FileHandler;
import lu.uni.adtool.ui.JWSFileHandler;
import lu.uni.adtool.ui.LoadExampleDialog;
import lu.uni.adtool.ui.LogView;
import lu.uni.adtool.ui.StatusLine;
import lu.uni.adtool.ui.ToolBarButton;
import lu.uni.adtool.ui.ValuationView;
import lu.uni.adtool.ui.printview.JPrintPreviewDialog;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.DockingWindowAdapter;
import net.infonode.docking.DockingWindowListener;
import net.infonode.docking.FloatingWindow;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.ViewSerializer;
import net.infonode.docking.mouse.DockingWindowActionMouseButtonListener;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.theme.BlueHighlightDockingTheme;
import net.infonode.docking.theme.ClassicDockingTheme;
import net.infonode.docking.theme.DefaultDockingTheme;
import net.infonode.docking.theme.DockingWindowsTheme;
import net.infonode.docking.theme.GradientDockingTheme;
import net.infonode.docking.theme.LookAndFeelDockingTheme;
import net.infonode.docking.theme.ShapedGradientDockingTheme;
import net.infonode.docking.theme.SlimFlatDockingTheme;
import net.infonode.docking.theme.SoftBlueIceDockingTheme;
import net.infonode.docking.util.AbstractViewMap;
import net.infonode.docking.util.DockingUtil;
import net.infonode.docking.util.MixedViewHandler;
import net.infonode.docking.util.PropertiesUtil;
import net.infonode.docking.util.ViewMap;
import net.infonode.util.Direction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainWindow
extends Frame {
    private static final long serialVersionUID = -5414047637435066736L;
    private MouseHandler mouseHandler;
    private static ADAction fileNew;
    private static ADAction fileOpen;
    private static ADAction fileSave;
    private static ADAction fileExample;
    private static ADAction fileExportToPdf;
    private static ADAction fileExportToLatex;
    private static ADAction fileExportToPng;
    private static ADAction fileExportToJpg;
    private static ADAction fileExportToXml;
    private static ADAction fileImportFromXml;
    private static ADAction filePrint;
    private static ADAction filePrintPreview;
    private static ADAction fileExit;
    private StatusLine status;
    private byte[] layout;
    private HashMap<Integer, ValuationDomain<Ring>> valuations = new HashMap();
    private FileHandler fh;
    private RootWindow rootWindow;
    private JFrame frame = new JFrame("Attack Defense Tree Tool");
    private View[] views = new View[5];
    private HashMap<Integer, DynamicView> dynamicViews = new HashMap();
    private ViewMap viewMap = new ViewMap();
    private JMenuItem[] windowsItems = new JMenuItem[this.views.length];
    private JMenu attrDomainsMenu;
    private DockingWindowsTheme currentTheme = new ShapedGradientDockingTheme();
    private ADTreeCanvas lastFocused;
    private SplitWindow splitWindow;
    private RootWindowProperties properties = new RootWindowProperties();

    public ValuationDomain<Ring> getValuation(int id) {
        return this.valuations.get(new Integer(id));
    }

    public HashMap<Integer, ValuationDomain<Ring>> getValuations() {
        return this.valuations;
    }

    public void setLastFocused(ADTreeCanvas lastFocused) {
        this.lastFocused = lastFocused;
        if (lastFocused == null || lastFocused instanceof DomainCanvas) {
            ((ValuationView)this.views[2].getComponent()).assignCanvas(lastFocused);
            ((DetailsView)this.views[3].getComponent()).assignCanvas(lastFocused);
        }
    }

    public void removeDomain(int i) {
        DynamicView view = this.dynamicViews.get(new Integer(i));
        Component c = view.getComponent();
        if (c instanceof DomainView) {
            if (this.lastFocused instanceof DomainCanvas && ((DomainCanvas)this.lastFocused).getId() == i) {
                this.setLastFocused(null);
            }
            ((DomainView)c).onClose();
            view.close();
            this.getRootWindow().removeView((View)view);
        }
        this.valuations.remove(new Integer(i));
        this.dynamicViews.remove(new Integer(i));
        this.createAttrDomainMenu();
    }

    public void removeDomains() {
        if (this.lastFocused instanceof DomainCanvas) {
            this.setLastFocused(null);
        }
        Collection<DynamicView> dynViews = this.dynamicViews.values();
        Vector<DynamicView> set = new Vector<DynamicView>(dynViews);
        for (DynamicView view : set) {
            Component c = view.getComponent();
            if (!(c instanceof DomainView)) continue;
            ((DomainView)c).onClose();
            view.close();
            this.getRootWindow().removeView((View)view);
        }
        this.valuations.clear();
        this.dynamicViews.clear();
        this.createAttrDomainMenu();
    }

    public View[] getViews() {
        return this.views;
    }

    public RootWindow getRootWindow() {
        return this.rootWindow;
    }

    public StatusLine getStatusBar() {
        return this.status;
    }

    public View getViews(int index) {
        return this.views[index];
    }

    public ADTreeCanvas getLastFocused() {
        return this.lastFocused;
    }

    public void updateDynamicViewTitles() {
        Collection<DynamicView> dynViews = this.dynamicViews.values();
        Vector<DynamicView> set = new Vector<DynamicView>(dynViews);
        int i = 0;
        for (DynamicView view : set) {
            DomainView dv = (DomainView)view.getComponent();
            view.getViewProperties().setTitle(++i + ". " + dv.getCanvas().getDomain().getName());
        }
    }

    public MainWindow(String[] args) {
        this.createActions();
        this.createRootWindow();
        this.restoreDefaultLayout();
        this.showFrame();
        if (args.length > 0) {
            String ext = args[0].substring(args[0].lastIndexOf(46) + 1);
            try {
                if (ext.equalsIgnoreCase("xml")) {
                    File file = new File(args[0]);
                    FileInputStream in = new FileInputStream(file);
                    if (in != null) {
                        ADTXmlImport importer = new ADTXmlImport(this);
                        importer.importFrom(in);
                    }
                } else if (ext.equalsIgnoreCase("adt")) {
                    File file = new File(args[0]);
                    FileInputStream fin = new FileInputStream(file);
                    if (fin != null) {
                        ObjectInputStream in = new ObjectInputStream(fin);
                        ADTSerializer as = new ADTSerializer(this);
                        as.loadFromStreamTree(in);
                        this.createAttrDomainMenu();
                    }
                } else {
                    System.out.println("Unknown file type:" + args[0]);
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found:" + args[0]);
            }
            catch (Exception e) {
                System.out.println("Error opening file:" + args[0]);
            }
        }
    }

    private StatusLine createStatusBar() {
        StatusLine newStatus = new StatusLine();
        newStatus.setLog((LogView)this.views[4].getComponent());
        newStatus.setBorder(BorderFactory.createEtchedBorder());
        return newStatus;
    }

    private void updateFloatingWindow(FloatingWindow fw) {
    }

    private int getDynamicViewId() {
        int id = 0;
        while (this.dynamicViews.containsKey(new Integer(id))) {
            ++id;
        }
        return id;
    }

    private void createRootWindow() {
        ADTreeForGui tree = new ADTreeForGui(new ADTreeNode());
        this.views[0] = new View("ADTree Edit", (Icon)new ImageIcon(this.getClass().getResource("/icons/tree_16x16.png")), (Component)new ADTreeView(tree, this));
        ADTreeCanvas canvas = ((ADTreeView)this.views[0].getComponent()).getCanvas();
        this.views[1] = new View("ADTerm Edit", (Icon)new ImageIcon(this.getClass().getResource("/icons/viewTree_16x16.png")), (Component)new ADTermView(canvas));
        this.views[2] = new View("Valuations View", (Icon)new ImageIcon(this.getClass().getResource("/icons/table_16x16.png")), (Component)new ValuationView());
        this.views[3] = new View("Domain Details View", (Icon)new ImageIcon(this.getClass().getResource("/icons/eyes_16x16.png")), (Component)new DetailsView());
        this.views[4] = new View("Message Log", (Icon)new ImageIcon(this.getClass().getResource("/icons/messageLog.png")), (Component)new LogView());
        for (int i = 0; i < this.views.length; ++i) {
            this.viewMap.addView(i, this.views[i]);
        }
        MixedViewHandler handler = new MixedViewHandler((AbstractViewMap)this.viewMap, new ViewSerializer(){

            public void writeView(View view, ObjectOutputStream out) throws IOException {
                int id = ((DynamicView)view).getId();
                out.writeInt(id);
                if (view.getComponent() instanceof DomainView) {
                    Domain<Ring> d = ((DomainView)view.getComponent()).getCanvas().getDomain();
                    out.writeObject(DomainFactory.updateDomainName(DomainFactory.getClassName(d)));
                }
            }

            public View readView(ObjectInputStream in) throws IOException {
                int id = in.readInt();
                try {
                    if (Options.currentSaveVer == 1) {
                        String domainName = DomainFactory.updateDomainName((String)in.readObject());
                        ValuationDomain<Ring> vd = new ValuationDomain<Ring>(DomainFactory.createFromString(domainName));
                        MainWindow.this.valuations.put(new Integer(id), vd);
                        View view = MainWindow.this.getDynamicView(id);
                        return view;
                    }
                    if (Options.currentSaveVer == -1) {
                        String domainName = DomainFactory.updateDomainName((String)in.readObject());
                        if (MainWindow.this.valuations.get(new Integer(id)) != null) {
                            View view = MainWindow.this.getDynamicView(id);
                            return view;
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
                return null;
            }
        });
        this.rootWindow = DockingUtil.createRootWindow((AbstractViewMap)this.viewMap, (ViewSerializer)handler, (boolean)true);
        this.properties.addSuperObject(this.currentTheme.getRootWindowProperties());
        this.rootWindow.getRootWindowProperties().addSuperObject(this.properties);
        this.rootWindow.getWindowBar(Direction.DOWN).setEnabled(true);
        this.rootWindow.addListener((DockingWindowListener)new DockingWindowAdapter(){

            public void windowAdded(DockingWindow addedToWindow, DockingWindow addedWindow) {
                if (addedWindow instanceof FloatingWindow) {
                    MainWindow.this.updateFloatingWindow((FloatingWindow)addedWindow);
                } else {
                    MainWindow.this.updateWindowsMenu();
                }
            }

            public void windowRemoved(DockingWindow removedFromWindow, DockingWindow removedWindow) {
                MainWindow.this.updateWindowsMenu();
            }

            public void windowClosing(DockingWindow window) throws OperationAbortedException {
            }

            public void windowUndocking(DockingWindow window) throws OperationAbortedException {
            }

            public void viewFocusChanged(View previouslyFocusedView, View focusedView) {
                if (focusedView != null && focusedView.getComponent() != null) {
                    Component c = focusedView.getComponent();
                    if (c instanceof ADTreeView) {
                        MainWindow.this.setLastFocused(((ADTreeView)c).getCanvas());
                    } else if (c instanceof DomainView) {
                        MainWindow.this.setLastFocused(((DomainView)c).getCanvas());
                    } else if (!(c instanceof ValuationView) && !(c instanceof DetailsView)) {
                        MainWindow.this.setLastFocused(null);
                    }
                } else if (focusedView != null) {
                    MainWindow.this.setLastFocused(null);
                }
            }
        });
        this.rootWindow.addTabMouseButtonListener(DockingWindowActionMouseButtonListener.MIDDLE_BUTTON_CLOSE_LISTENER);
    }

    private void createActions() {
        fileNew = new ADAction("New"){
            private static final long serialVersionUID = -1139040302346025737L;

            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(MainWindow.this.frame, "Are you sure you want replace current tree with new one?", "New Tree", 0);
                if (result == 0) {
                    MainWindow.this.restoreDefaultLayout();
                    ADTreeCanvas can = ((ADTreeView)MainWindow.this.views[0].getComponent()).getCanvas();
                    MainWindow.this.removeDomains();
                    can.newTree();
                    MainWindow.this.fh.setTreeFileName(null);
                    MainWindow.this.status.report("New empty tree created.");
                }
            }
        };
        fileNew.setMnemonic(78);
        fileNew.setAccelerator(KeyStroke.getKeyStroke(78, 8));
        fileNew.setSmallIcon(new ImageIcon(this.getClass().getResource("/icons/new.png")));
        fileNew.setToolTip("Start with the new empty ADTree");
        fileOpen = new ADAction("Open"){
            private static final long serialVersionUID = -1735715946035939568L;

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.loadTree();
            }
        };
        fileOpen.setMnemonic(79);
        fileOpen.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        fileOpen.setSmallIcon(new ImageIcon(this.getClass().getResource("/icons/open.png")));
        fileSave = new ADAction("Save"){
            private static final long serialVersionUID = -8810941869644307469L;

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveTree();
            }
        };
        fileSave.setMnemonic(83);
        fileSave.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        fileSave.setSmallIcon(new ImageIcon(this.getClass().getResource("/icons/save.png")));
        fileExample = new ADAction("Load Example Tree"){
            private static final long serialVersionUID = -4300803966363076614L;

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.loadExample();
            }
        };
        fileExample.setMnemonic(76);
        fileExample.setAccelerator(KeyStroke.getKeyStroke(76, 8));
        fileExample.setSmallIcon(new ImageIcon(this.getClass().getResource("/icons/treeEx_16x16.png")));
        fileExportToPdf = new ADAction("Pdf"){
            private static final long serialVersionUID = 4325025687838671271L;

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.exportTo("pdf");
            }
        };
        fileExportToPdf.setMnemonic(80);
        fileExportToPdf.setSmallIcon(new ImageIcon(this.getClass().getResource("/icons/pdf_16x16.png")));
        fileExportToLatex = new ADAction("LaTeX"){
            private static final long serialVersionUID = -6909764599614352161L;

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.exportTo("tex");
            }
        };
        fileExportToLatex.setMnemonic(76);
        fileExportToLatex.setSmallIcon(new ImageIcon(this.getClass().getResource("/icons/tex_16x16.png")));
        fileExportToPng = new ADAction("PNG image"){
            private static final long serialVersionUID = 2398600083840742200L;

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.exportTo("png");
            }
        };
        fileExportToPng.setSmallIcon(new ImageIcon(this.getClass().getResource("/icons/png_16x16.png")));
        fileExportToPng.setMnemonic(78);
        fileExportToJpg = new ADAction("JPEG image"){
            private static final long serialVersionUID = 8409590777160375107L;

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.exportTo("jpg");
            }
        };
        fileExportToJpg.setMnemonic(74);
        fileExportToJpg.setSmallIcon(new ImageIcon(this.getClass().getResource("/icons/jpg_16x16.png")));
        fileExportToXml = new ADAction("Xml"){
            private static final long serialVersionUID = 2724287904022882599L;

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.exportTo("xml");
            }
        };
        fileExportToXml.setSmallIcon(new ImageIcon(this.getClass().getResource("/icons/xml_16x16.png")));
        fileExportToXml.setMnemonic(88);
        fileImportFromXml = new ADAction("Xml"){
            private static final long serialVersionUID = -3605440604743377670L;

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.importFrom("xml");
            }
        };
        fileImportFromXml.setSmallIcon(new ImageIcon(this.getClass().getResource("/icons/xml_16x16.png")));
        fileImportFromXml.setMnemonic(88);
        filePrintPreview = new ADAction("Print Preview"){
            private static final long serialVersionUID = -8710097506678812443L;

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.printPreview();
            }
        };
        filePrintPreview.setSmallIcon(new ImageIcon(this.getClass().getResource("/icons/preview.png")));
        filePrintPreview.setMnemonic(86);
        filePrintPreview.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        filePrint = new ADAction("Print"){
            private static final long serialVersionUID = 7365498990462507356L;

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.printCanvas();
            }
        };
        filePrint.setMnemonic(80);
        filePrint.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        filePrint.setSmallIcon(new ImageIcon(this.getClass().getResource("/icons/print.png")));
        fileExit = new ADAction("Exit"){
            private static final long serialVersionUID = -6586817922511469697L;

            public void actionPerformed(ActionEvent e) {
                WindowEvent windowClosing = new WindowEvent(MainWindow.this.frame, 201);
                MainWindow.this.frame.dispatchEvent(windowClosing);
            }
        };
        fileExit.setMnemonic(88);
        fileExit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        fileExit.setSmallIcon(new ImageIcon(this.getClass().getResource("/icons/exit.png")));
    }

    private void importFrom(String type) {
        FileInputStream in = this.fh.getImportTreeStream(type);
        if (in != null) {
            ADTXmlImport importer = new ADTXmlImport(this);
            importer.importFrom(in);
        }
    }

    private void exportTo(String type) {
        ADTreeCanvas canvas = ((ADTreeView)this.views[0].getComponent()).getCanvas();
        if (this.lastFocused != null) {
            canvas = this.lastFocused;
        }
        ADTreeNode tempFocus = canvas.getFocused();
        canvas.setFocus(null);
        FileOutputStream out = this.fh.getExportTreeStream(type);
        if (out != null) {
            if (type.equals("pdf")) {
                canvas.createPdf(out);
            } else if (type.equals("tex")) {
                canvas.createLatex(out);
            } else if (type.equals("png") || type.equals("jpg")) {
                canvas.createImage(out, type);
            } else if (type.equals("xml")) {
                canvas.createXml(out);
            }
        }
        canvas.setFocus(tempFocus);
    }

    private void restoreDefaultLayout() {
        this.splitWindow = new SplitWindow(false, 0.37103593f, (DockingWindow)this.views[1], (DockingWindow)this.views[0]);
        this.rootWindow.setWindow((DockingWindow)this.splitWindow);
        for (View view : this.dynamicViews.values()) {
            this.addDomainWindow((DockingWindow)view);
        }
    }

    private void printPreview() {
        ADTreeCanvas canvas = ((ADTreeView)this.views[0].getComponent()).getCanvas();
        if (this.lastFocused != null) {
            canvas = this.lastFocused;
        }
        JPrintPreviewDialog pp = new JPrintPreviewDialog((Frame)this, canvas);
        pp.setVisible(true);
    }

    private void printCanvas() {
        ADTreeCanvas canvas = ((ADTreeView)this.views[0].getComponent()).getCanvas();
        if (this.lastFocused != null) {
            canvas = this.lastFocused;
        }
        canvas.showPrintDialog(true);
    }

    private void showFrame() {
        this.status = this.createStatusBar();
        this.fh = this.isRunningJavaWebStart() ? new JWSFileHandler(this.status, this) : new FileHandler(this.status, this);
        this.mouseHandler = new MouseHandler();
        this.frame.getContentPane().add((Component)this.createToolBar(), "North");
        this.frame.getContentPane().add((Component)this.getRootWindow(), "Center");
        this.frame.getContentPane().add((Component)this.status, "South");
        this.frame.setJMenuBar(this.createMenuBar());
        Dimension dim = this.getScreenSize(0.8, 0.4);
        this.frame.setSize(dim.width, dim.height);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                JFrame localFrame = (JFrame)e.getSource();
                int result = JOptionPane.showConfirmDialog(localFrame, "Are you sure you want to exit the application?", "Exit Application", 0);
                if (result == 0) {
                    MainWindow.this.frame.setDefaultCloseOperation(3);
                }
            }
        });
        this.frame.setVisible(true);
    }

    private JToolBar createToolBar() {
        ADToolBar toolbar = new ADToolBar();
        ToolBarButton button = toolbar.add(fileNew);
        button.addMouseListener(this.mouseHandler);
        button = toolbar.add(fileOpen);
        button.addMouseListener(this.mouseHandler);
        button = toolbar.add(fileSave);
        button.addMouseListener(this.mouseHandler);
        toolbar.addSeparator();
        button = toolbar.add(filePrintPreview);
        button.addMouseListener(this.mouseHandler);
        toolbar.setTextLabels(true);
        return toolbar;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menu = new JMenuBar();
        menu.add(this.createFileMenu());
        menu.add(this.createEditMenu());
        menu.add(this.createViewMenu());
        menu.add(this.createWindowsMenu());
        this.attrDomainsMenu = new JMenu("Domains");
        this.attrDomainsMenu.setMnemonic(68);
        menu.add(this.attrDomainsMenu);
        this.createAttrDomainMenu();
        menu.add(this.createHelpMenu());
        return menu;
    }

    public void createAttrDomainMenu() {
        JMenu menu = this.attrDomainsMenu;
        menu.removeAll();
        JMenuItem menuItem = new JMenuItem("Add Attribute Domain");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.chooseAttributeDomain();
            }
        });
        menuItem.setMnemonic(65);
        menu.add(menuItem);
        if (this.valuations.size() > 0) {
            menu.addSeparator();
            for (Integer i : this.valuations.keySet()) {
                int j = i;
                final View view = this.getDynamicView(j);
                menuItem = new JMenuItem(view.getTitle(), view.getIcon());
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (view.getRootWindow() != null) {
                            view.restoreFocus();
                        } else {
                            MainWindow.this.addDomainWindow((DockingWindow)view);
                        }
                    }
                });
                menu.add(menuItem);
            }
        }
    }

    public void addDomainWindow(DockingWindow window) {
        DockingWindow wr = this.splitWindow.getRightWindow();
        DockingWindow wl = this.splitWindow.getLeftWindow();
        if (wr == null || wr == null) {
            DockingUtil.addWindow((DockingWindow)window, (RootWindow)this.getRootWindow());
        } else if (wr instanceof TabWindow) {
            ((TabWindow)wr).addTab(window);
        } else {
            this.splitWindow.setWindows(wl, (DockingWindow)new TabWindow(new DockingWindow[]{wr, window}));
        }
    }

    private void chooseAttributeDomain() {
        AddDomainDialog addDialog = new AddDomainDialog(this);
        Vector<Domain<?>> domains = DomainFactory.getPredefinedDomains();
        Domain d = addDialog.showDomainDialog(domains);
        if (d instanceof Parametrized && ((Parametrized)((Object)d)).getParameter() instanceof Integer) {
            Integer value;
            BoundedIntegerDialog dialog = d instanceof MinSkill ? new BoundedIntegerDialog((Frame)this, "Choose maximal skill level k for the proponent") : new BoundedIntegerDialog((Frame)this, "Choose value for k");
            BoundedInteger result = (BoundedInteger)dialog.showInputDialog(new BoundedInteger(value = (Integer)((Parametrized)((Object)d)).getParameter(), Integer.MAX_VALUE), false);
            if (result != null) {
                value = new Integer(result.getValue());
                if (value == BoundedInteger.INF) {
                    value = Integer.MAX_VALUE;
                }
                ((Parametrized)((Object)d)).setParameter(value);
            } else {
                d = null;
            }
        }
        if (d == null) {
            return;
        }
        this.addAttributeDomain(d);
        this.createAttrDomainMenu();
    }

    public HashMap<Integer, DynamicView> getDynamicViews() {
        return this.dynamicViews;
    }

    public Dimension getScreenSize(double scaleY, double scaleX) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        DisplayMode dm = gs[0].getDisplayMode();
        return new Dimension((int)((double)dm.getWidth() * scaleX), (int)((double)dm.getHeight() * scaleY));
    }

    public View addAttributeDomain(Domain<?> d) {
        ValuationDomain vd = new ValuationDomain(d);
        int id = this.getDynamicViewId();
        this.valuations.put(new Integer(id), vd);
        View view = this.getDynamicView(id);
        this.addDomainWindow((DockingWindow)view);
        this.setLastFocused(((DomainView)view.getComponent()).getCanvas());
        this.status.report("Added a new domain: " + d.getName());
        return view;
    }

    public void closeDynamicViews() {
        for (View view : this.dynamicViews.values()) {
            view.close();
        }
    }

    public View getDynamicView(int id) {
        View view = this.dynamicViews.get(new Integer(id));
        if (view == null) {
            if (this.getValuation(id) != null) {
                ADTreeForGui tree = ((ADTreeView)this.views[0].getComponent()).getTree();
                DomainCanvas canvas = new DomainCanvas(tree, this, id);
                DomainView dv = new DomainView(this, canvas, id);
                view = new DynamicView(1 + id + ". " + canvas.getDomain().getName(), dv.getIcon(), dv, id);
                this.dynamicViews.put(new Integer(id), (DynamicView)view);
            } else {
                this.status.reportError("Dynamic View with id " + id + " has no associated valuations");
                return null;
            }
        }
        return view;
    }

    private void updateWindowsMenu() {
        for (int i = 0; i < this.windowsItems.length; ++i) {
            if (this.windowsItems[i] == null) continue;
            this.windowsItems[i].setEnabled(this.views[i].getRootWindow() == null);
        }
    }

    private JMenu createWindowsMenu() {
        JMenu menu = new JMenu("Windows");
        menu.setMnemonic(87);
        for (int i = 0; i < this.views.length; ++i) {
            final View view = this.views[i];
            this.windowsItems[i] = new JMenuItem(view.getTitle(), view.getIcon());
            this.windowsItems[i].setEnabled(this.views[i].getRootWindow() == null);
            menu.add(this.windowsItems[i]).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (view.getRootWindow() != null) {
                        view.restoreFocus();
                    } else {
                        DockingUtil.addWindow((DockingWindow)view, (RootWindow)MainWindow.this.getRootWindow());
                    }
                }
            });
        }
        this.windowsItems[0].setMnemonic('r');
        this.windowsItems[1].setMnemonic('e');
        this.windowsItems[2].setMnemonic('V');
        this.windowsItems[3].setMnemonic('D');
        this.windowsItems[4].setMnemonic('M');
        return menu;
    }

    private JMenu createHelpMenu() {
        JMenu menu = new JMenu("Help");
        menu.setMnemonic(72);
        JMenuItem menuItem = new JMenuItem("About");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog ad = new AboutDialog();
                ad.setVisible(true);
            }
        });
        menuItem.setMnemonic(65);
        menu.add(menuItem);
        return menu;
    }

    private JMenu createEditMenu() {
        JMenu editMenu = new JMenu();
        editMenu.setText("Edit");
        editMenu.setMnemonic('E');
        JMenuItem menuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        menuItem.setText("Cut");
        menuItem.setMnemonic(84);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        editMenu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText("Copy");
        menuItem.setMnemonic(67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        editMenu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        menuItem.setText("Paste");
        menuItem.setMnemonic(80);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        editMenu.add(menuItem);
        editMenu.addSeparator();
        menuItem = new JMenuItem("Switch Attacker/Defender Roles");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Options.canv_Defender = Options.canv_Defender == ADTreeNode.Type.PROPONENT ? ADTreeNode.Type.OPPONENT : ADTreeNode.Type.PROPONENT;
                ((ADTreeView)MainWindow.this.views[0].getComponent()).getCanvas().getTree().updateAllSizes();
                ((ADTreeView)MainWindow.this.views[0].getComponent()).getCanvas().repaint();
                for (View v : MainWindow.this.dynamicViews.values()) {
                    ((DomainView)v.getComponent()).getCanvas().getTree().updateAllSizes();
                    ((DomainView)v.getComponent()).getCanvas().repaint();
                }
                MainWindow.this.status.report("Assigned a role of a defender to the " + (Options.canv_Defender == ADTreeNode.Type.PROPONENT ? "opponent." : "proponent."));
            }
        });
        menuItem.setMnemonic(83);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        editMenu.add(menuItem);
        menuItem = new JMenuItem("Validate Terms");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((ADTermView)MainWindow.this.views[1].getComponent()).parse();
            }
        });
        menuItem.setMnemonic(76);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(10, 2));
        editMenu.add(menuItem);
        return editMenu;
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = new JMenu();
        fileMenu.setText("File");
        fileMenu.setMnemonic('F');
        JMenuItem menuItem = fileMenu.add(fileNew);
        menuItem.addMouseListener(this.mouseHandler);
        fileMenu.add(menuItem);
        fileMenu.addSeparator();
        menuItem = fileMenu.add(fileExample);
        menuItem.addMouseListener(this.mouseHandler);
        fileMenu.add(menuItem);
        menuItem = fileMenu.add(fileOpen);
        menuItem.addMouseListener(this.mouseHandler);
        fileMenu.add(menuItem);
        menuItem = fileMenu.add(fileSave);
        menuItem.addMouseListener(this.mouseHandler);
        fileMenu.add(menuItem);
        JMenu exportTo = new JMenu("Export to");
        exportTo.setMnemonic(69);
        menuItem = exportTo.add(fileExportToPdf);
        menuItem.addMouseListener(this.mouseHandler);
        exportTo.add(menuItem);
        menuItem = exportTo.add(fileExportToLatex);
        menuItem.addMouseListener(this.mouseHandler);
        exportTo.add(menuItem);
        menuItem = exportTo.add(fileExportToPng);
        menuItem.addMouseListener(this.mouseHandler);
        exportTo.add(menuItem);
        menuItem = exportTo.add(fileExportToJpg);
        menuItem.addMouseListener(this.mouseHandler);
        exportTo.add(menuItem);
        menuItem = exportTo.add(fileExportToXml);
        menuItem.addMouseListener(this.mouseHandler);
        exportTo.add(menuItem);
        fileMenu.add(exportTo);
        JMenu importFrom = new JMenu("Import from");
        importFrom.setMnemonic(73);
        menuItem = importFrom.add(fileImportFromXml);
        menuItem.addMouseListener(this.mouseHandler);
        importFrom.add(menuItem);
        fileMenu.add(importFrom);
        menuItem = fileMenu.add(filePrint);
        menuItem.addMouseListener(this.mouseHandler);
        fileMenu.add(menuItem);
        menuItem = fileMenu.add(filePrintPreview);
        menuItem.addMouseListener(this.mouseHandler);
        fileMenu.add(menuItem);
        menuItem = fileMenu.add(fileExit);
        menuItem.addMouseListener(this.mouseHandler);
        fileMenu.add(menuItem);
        return fileMenu;
    }

    private JMenu createViewMenu() {
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic(86);
        JMenu themesMenu = new JMenu("Themes");
        themesMenu.setMnemonic(84);
        JMenu layoutMenu = new JMenu("Layouts");
        layoutMenu.setMnemonic(76);
        final RootWindowProperties titleBarStyleProperties = PropertiesUtil.createTitleBarStyleRootWindowProperties();
        final JCheckBoxMenuItem titleBarStyleItem = new JCheckBoxMenuItem("Title Bar Style Theme");
        titleBarStyleItem.setSelected(false);
        titleBarStyleItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (titleBarStyleItem.isSelected()) {
                    MainWindow.this.properties.addSuperObject(titleBarStyleProperties);
                } else {
                    MainWindow.this.properties.removeSuperObject(titleBarStyleProperties);
                }
            }
        });
        themesMenu.add(titleBarStyleItem);
        themesMenu.addSeparator();
        DockingWindowsTheme[] themes = new DockingWindowsTheme[]{new DefaultDockingTheme(), new LookAndFeelDockingTheme(), new BlueHighlightDockingTheme(), new SlimFlatDockingTheme(), new GradientDockingTheme(), new ShapedGradientDockingTheme(), new SoftBlueIceDockingTheme(), new ClassicDockingTheme()};
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < themes.length; ++i) {
            final DockingWindowsTheme theme = themes[i];
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(theme.getName());
            item.setSelected(i == 4);
            group.add(item);
            themesMenu.add(item).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.properties.getMap().clear(true);
                    MainWindow.this.setTheme(theme);
                }
            });
        }
        viewMenu.add(themesMenu);
        JMenuItem menuItem = new JMenuItem("Restore Default");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.restoreDefaultLayout();
                MainWindow.this.status.report("Restored default layout");
            }
        });
        menuItem.setMnemonic(68);
        layoutMenu.add(menuItem);
        layoutMenu.addSeparator();
        menuItem = new JMenuItem("Store in Memory");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    ObjectOutputStream out = new ObjectOutputStream(bos);
                    MainWindow.this.getRootWindow().write(out, true);
                    out.close();
                    MainWindow.this.status.report("Stored window layout in memory.");
                }
                catch (IOException err) {
                    MainWindow.this.status.reportError(err.getMessage());
                }
                MainWindow.access$1902(MainWindow.this, bos.toByteArray());
            }
        });
        menuItem.setMnemonic(77);
        layoutMenu.add(menuItem);
        menuItem = new JMenuItem("Restore Layout");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (MainWindow.this.layout != null) {
                            try {
                                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(MainWindow.this.layout));
                                MainWindow.this.getRootWindow().read(in, true);
                                in.close();
                                MainWindow.this.status.report("Restored window layout from memory.");
                            }
                            catch (IOException e1) {
                                throw new RuntimeException(e1);
                            }
                        }
                    }
                });
            }
        });
        menuItem.setMnemonic(82);
        layoutMenu.add(menuItem);
        layoutMenu.addSeparator();
        menuItem = new JMenuItem("Save to File");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ObjectOutputStream out = MainWindow.this.fh.getSaveLayoutStream();
                        if (out != null) {
                            try {
                                MainWindow.this.rootWindow.write(out, true);
                                out.close();
                                MainWindow.this.status.report("Stored window layout in file.");
                            }
                            catch (IOException e2) {
                                MainWindow.this.status.reportError(e2.getLocalizedMessage());
                            }
                        }
                    }
                });
            }
        });
        menuItem.setMnemonic(83);
        layoutMenu.add(menuItem);
        menuItem = new JMenuItem("Load from File");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ObjectInputStream in = MainWindow.this.fh.getLoadLayoutStream();
                        if (in != null) {
                            try {
                                MainWindow.this.rootWindow.read(in, true);
                                in.close();
                                MainWindow.this.status.report("Restored window layout from file.");
                            }
                            catch (IOException e2) {
                                MainWindow.this.status.reportError(e2.getLocalizedMessage());
                            }
                        }
                    }
                });
            }
        });
        menuItem.setMnemonic(76);
        layoutMenu.add(menuItem);
        viewMenu.add(layoutMenu);
        menuItem = new JMenuItem("Expand All Nodes");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ADTreeCanvas canvas = ((ADTreeView)MainWindow.this.views[0].getComponent()).getCanvas();
                canvas.expandAllNodes();
            }
        });
        menuItem.setMnemonic(69);
        viewMenu.add(menuItem);
        menuItem = new JMenuItem("Fit to Window");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ADTreeCanvas canvas = ((ADTreeView)MainWindow.this.views[0].getComponent()).getCanvas();
                if (MainWindow.this.lastFocused != null) {
                    canvas = MainWindow.this.lastFocused;
                }
                canvas.fitToWindow();
            }
        });
        menuItem.setMnemonic(70);
        viewMenu.add(menuItem);
        return viewMenu;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    private void setTheme(DockingWindowsTheme theme) {
        this.properties.replaceSuperObject(this.currentTheme.getRootWindowProperties(), theme.getRootWindowProperties());
        this.currentTheme = theme;
    }

    private void loadExample() {
        LoadExampleDialog dialog = new LoadExampleDialog(this);
        String fileName = dialog.showDialog();
        if (fileName != null) {
            try {
                URL url = this.getClass().getResource(fileName);
                InputStream in = url.openStream();
                ADTSerializer as = new ADTSerializer(this);
                as.loadFromStreamTree(new ObjectInputStream(in));
                this.status.report("Loaded example tree");
            }
            catch (IOException e) {
                this.status.reportError(e.getMessage());
            }
        }
    }

    private void loadTree() {
        ObjectInputStream in = this.fh.getLoadTreeStream();
        ADTSerializer as = new ADTSerializer(this);
        as.loadFromStreamTree(in);
        this.createAttrDomainMenu();
    }

    private void saveTree() {
        ObjectOutputStream out = this.fh.getSaveTreeStream();
        ADTSerializer as = new ADTSerializer(this);
        as.saveToStreamTree(out);
    }

    private boolean isRunningJavaWebStart() {
        return System.getProperty("javawebstart.version", null) != null;
    }

    static /* synthetic */ byte[] access$1902(MainWindow x0, byte[] x1) {
        x0.layout = x1;
        return x1;
    }

    private class MouseHandler
    extends MouseAdapter {
        public void mouseEntered(MouseEvent evt) {
        }
    }

    public abstract class ADAction
    extends AbstractAction {
        private static final long serialVersionUID = 8109471079193338016L;

        public ADAction(String text) {
            super(text);
        }

        public final void setAccelerator(KeyStroke accelerator) {
            this.putValue("AcceleratorKey", accelerator);
        }

        public final void setSmallIcon(Icon icon) {
            this.putValue("SmallIcon", icon);
        }

        public final void setToolTip(String text) {
            this.putValue("ShortDescription", text);
        }

        public final void setDescription(String text) {
            this.putValue("LongDescription", text);
        }

        public final void setMnemonic(Integer mnemonic) {
            this.putValue("MnemonicKey", mnemonic);
        }

        public abstract void actionPerformed(ActionEvent var1);
    }

    public static class DynamicView
    extends View {
        static final long serialVersionUID = 4127190623311867764L;
        private int id;

        DynamicView(String title, Icon icon, Component component, int id) {
            super(title, icon, component);
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

