/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lu.uni.adtool.domains.rings.RealZeroOne;
import lu.uni.adtool.ui.InputDialog;

public class RealZeroOneDialog
extends InputDialog
implements ChangeListener {
    static final long serialVersionUID = 118586363646948463L;
    private JSlider slider = null;

    public RealZeroOneDialog(Frame frame) {
        super(frame, "Enter real number form 0 to 1");
    }

    public final void actionPerformed(ActionEvent e) {
        if ("0".equals(e.getActionCommand())) {
            this.setValue(0.0);
        } else if ("0.25".equals(e.getActionCommand())) {
            this.setValue(0.25);
        } else if ("0.5".equals(e.getActionCommand())) {
            this.setValue(0.5);
        } else if ("0.75".equals(e.getActionCommand())) {
            this.setValue(0.75);
        } else if ("1".equals(e.getActionCommand())) {
            this.setValue(1.0);
        } else if ("-0.1".equals(e.getActionCommand())) {
            this.add(-0.1);
        } else if ("+0.1".equals(e.getActionCommand())) {
            this.add(0.1);
        } else {
            super.actionPerformed(e);
        }
    }

    public final void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (source.getValueIsAdjusting()) {
            int i = source.getValue();
            this.valueField.setValue(new Double((double)i / 100.0));
            this.sync();
        }
    }

    protected final boolean isValid(double d) {
        RealZeroOne v;
        return d >= 0.0 && d <= 1.0 && (v = new RealZeroOne(d)).getValue() == d;
    }

    protected final void setValue(double d) {
        this.value = new RealZeroOne(d);
        this.valueField.setValue(d);
        this.slider.setValue((int)(d * 100.0));
    }

    protected final void createLayout(boolean showDefault) {
        this.errorMsg.setText("You must enter number between 0 and 1!");
        this.slider = new JSlider(0, 0, 100, 1);
        this.slider.addChangeListener(this);
        this.slider.setMajorTickSpacing(25);
        this.slider.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("0"));
        labelTable.put(new Integer(50), new JLabel("0.5"));
        labelTable.put(new Integer(100), new JLabel("1"));
        this.slider.setLabelTable(labelTable);
        this.slider.setPaintLabels(true);
        this.slider.setValue((int)(new Double(((RealZeroOne)this.value).getValue()) * 100.0));
        DecimalFormat f = new DecimalFormat();
        f.setMaximumFractionDigits(50);
        this.valueField = new JFormattedTextField(f);
        this.valueField.addKeyListener(this);
        if (showDefault) {
            this.valueField.setValue(new Double(((RealZeroOne)this.value).getValue()));
        }
        this.valueField.setColumns(15);
        this.valueField.addPropertyChangeListener("value", this);
        JPanel inputPane = new JPanel();
        inputPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 8, 0, 0);
        c.gridy = 0;
        c.gridx = 0;
        JButton button = new JButton("-0.1");
        button.setActionCommand("-0.1");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 1;
        c.gridwidth = 3;
        inputPane.add((Component)this.valueField, c);
        c.gridwidth = 1;
        c.gridx = 4;
        button = new JButton("+0.1");
        button.setActionCommand("+0.1");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridy = 1;
        c.gridx = 0;
        button = new JButton("0");
        button.setActionCommand("0");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 1;
        button = new JButton("0.25");
        button.setActionCommand("0.25");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 2;
        button = new JButton("0.5");
        button.setActionCommand("0.5");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 3;
        button = new JButton("0.75");
        button.setActionCommand("0.75");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridx = 4;
        button = new JButton("1");
        button.setActionCommand("1");
        button.addActionListener(this);
        inputPane.add((Component)button, c);
        c.gridy = 2;
        c.gridx = 0;
        c.gridwidth = 5;
        inputPane.add((Component)this.slider, c);
        this.contentPane.add((Component)inputPane, "Center");
        this.pack();
    }

    private void add(double i) {
        Number num = (Number)this.valueField.getValue();
        if (num == null) {
            return;
        }
        double d = num.doubleValue();
        if (!this.isValid(d + i)) {
            return;
        }
        this.valueField.setValue(new Double(d += i));
        this.sync();
    }
}

