/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventObject;
import java.util.Set;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import lu.uni.adtool.domains.rings.Bool;
import lu.uni.adtool.domains.rings.BoundedInteger;
import lu.uni.adtool.domains.rings.LMHEValue;
import lu.uni.adtool.domains.rings.LMHValue;
import lu.uni.adtool.domains.rings.RealG0;
import lu.uni.adtool.domains.rings.RealZeroOne;
import lu.uni.adtool.domains.rings.Ring;
import lu.uni.adtool.ui.ADTreeCanvas;
import lu.uni.adtool.ui.BoundedIntegerDialog;
import lu.uni.adtool.ui.DomainCanvas;
import lu.uni.adtool.ui.LMHDialog;
import lu.uni.adtool.ui.LMHEDialog;
import lu.uni.adtool.ui.RealG0Dialog;
import lu.uni.adtool.ui.RealZeroOneDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValuationView
extends JPanel
implements KeyListener,
ListSelectionListener {
    static final long serialVersionUID = 94565646654411328L;
    private final String proText = "Proponent";
    private JLabel message = this.createMessage();
    private JTable table;
    private JScrollPane scrollPane;
    private ValuationTableModel tableModel;
    private ListSelectionModel listSelectionModel;

    public ValuationView() {
        super(new BorderLayout());
        this.add(this.message);
        this.tableModel = new ValuationTableModel();
        this.tableModel.setCanvas(null);
        this.table = new JTable(this.tableModel);
        this.listSelectionModel = this.table.getSelectionModel();
        this.listSelectionModel.addListSelectionListener(this);
        this.table.setSelectionModel(this.listSelectionModel);
        this.scrollPane = null;
    }

    private JLabel createMessage() {
        JLabel result = new JLabel("No attribute domain chosen.");
        return result;
    }

    private JPanel createTable() {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 1));
        this.table = new JTable(this.tableModel){
            private static final long serialVersionUID = 1L;

            public boolean editCellAt(int row, int column, EventObject e) {
                Ring value;
                if (!this.isCellSelected(row, column)) {
                    return false;
                }
                String type = (String)this.getValueAt(row, 0);
                String key = (String)this.getValueAt(row, 1);
                boolean editable = false;
                int[] selection = ValuationView.this.table.getSelectedRows();
                for (int i = 0; i < selection.length && !editable; ++i) {
                    type = (String)this.getValueAt(selection[i], 0);
                    key = (String)this.getValueAt(selection[i], 1);
                    if (!ValuationView.this.getCanvas().getDomain().isValueModifiable(type.equals("Proponent"))) continue;
                    editable = true;
                }
                if (editable && (value = ValuationView.this.editValue(type, key)) != null) {
                    selection = ValuationView.this.table.getSelectedRows();
                    for (int i = 0; i < selection.length; ++i) {
                        type = (String)this.getValueAt(selection[i], 0);
                        key = (String)this.getValueAt(selection[i], 1);
                        if (!ValuationView.this.getCanvas().getDomain().isValueModifiable(type.equals("Proponent"))) continue;
                        ValuationView.this.getCanvas().putNewValue(type.equals("Proponent"), key, value);
                    }
                    ValuationView.this.getCanvas().valuesUpdated();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ValuationView.this.table.requestFocus();
                    }
                });
                return false;
            }
        };
        this.table.setSelectionModel(this.listSelectionModel);
        this.table.setAutoCreateRowSorter(false);
        this.table.setDefaultRenderer(Ring.class, new ValuationRenderer());
        this.table.setRowSorter(new TableRowSorter<TableModel>(this.table.getModel()));
        this.table.setFillsViewportHeight(true);
        result.add(new JLabel(this.getCanvas().getDomain().getName()));
        result.add(this.table.getTableHeader());
        result.add(this.table);
        return result;
    }

    public Ring editValue(String type, String key) {
        Ring value = type.equals("Proponent") ? this.getCanvas().getValueAssPro().get(key) : this.getCanvas().getValueAssOpp().get(key);
        if (value instanceof Bool) {
            value = Bool.not((Bool)value);
        } else if (value instanceof RealG0) {
            RealG0Dialog dialog = new RealG0Dialog(this.getCanvas().getMainWindow());
            value = (RealG0)dialog.showInputDialog(value);
        } else if (value instanceof RealZeroOne) {
            RealZeroOneDialog dialog = new RealZeroOneDialog(this.getCanvas().getMainWindow());
            value = (RealZeroOne)dialog.showInputDialog(value);
        } else if (value instanceof BoundedInteger) {
            BoundedIntegerDialog dialog = new BoundedIntegerDialog(this.getCanvas().getMainWindow());
            value = (BoundedInteger)dialog.showInputDialog(value);
        } else if (value instanceof LMHValue) {
            LMHDialog dialog = new LMHDialog(this.getCanvas().getMainWindow());
            value = (LMHValue)dialog.showInputDialog(value);
        } else if (value instanceof LMHEValue) {
            LMHEDialog dialog = new LMHEDialog(this.getCanvas().getMainWindow());
            value = (LMHEValue)dialog.showInputDialog(value);
        } else {
            System.out.println("Unknown type of ring for class" + value.getClass() + " and value " + value);
        }
        return value;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void assignCanvas(ADTreeCanvas canvas) {
        this.removeAll();
        if (canvas instanceof DomainCanvas) {
            this.table.setRowSorter(null);
            this.tableModel.setCanvas((DomainCanvas)canvas);
            this.message = null;
            this.scrollPane = new JScrollPane(this.createTable());
            this.add(this.scrollPane);
            ((JComponent)this.scrollPane.getParent()).revalidate();
            this.table.setRowSorter(new TableRowSorter<TableModel>(this.table.getModel()));
        } else {
            this.tableModel.setCanvas(null);
            this.table.setRowSorter(null);
            this.scrollPane = null;
            this.message = this.createMessage();
            this.add(this.message);
        }
    }

    public DomainCanvas<Ring> getCanvas() {
        return this.tableModel.getCanvas();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.getCanvas() == null) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        this.getCanvas().unmarkAll();
        if (!lsm.isSelectionEmpty()) {
            int minIndex = lsm.getMinSelectionIndex();
            int maxIndex = lsm.getMaxSelectionIndex();
            for (int i = minIndex; i <= maxIndex; ++i) {
                if (!lsm.isSelectedIndex(i)) continue;
                int j = this.table.convertRowIndexToModel(i);
                String key = (String)this.table.getModel().getValueAt(j, 1);
                String type = (String)this.table.getModel().getValueAt(j, 0);
                if (type.equals("Proponent")) {
                    this.getCanvas().markPro(key);
                    continue;
                }
                this.getCanvas().markOpp(key);
            }
        }
        this.getCanvas().repaint();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValuationTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;
        private DomainCanvas<Ring> canvas;

        public ValuationTableModel() {
            super.addColumn("Node Type");
            super.addColumn("Node Label");
            super.addColumn("Assigned Value");
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 2) {
                return Ring.class;
            }
            return this.getValueAt(0, columnIndex).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            super.setValueAt(value, row, col);
            this.fireTableCellUpdated(row, col);
        }

        public void setCanvas(DomainCanvas<Ring> canvas) {
            this.canvas = canvas;
            if (canvas != null) {
                this.updateRowData();
                this.fireTableDataChanged();
            }
        }

        private void updateRowData() {
            Vector<Object> v;
            if (this.canvas == null) {
                return;
            }
            Set<String> keys = this.canvas.getValueAssPro().keySet();
            this.setRowCount(0);
            for (String key : keys) {
                v = new Vector<Object>();
                v.add("Proponent");
                v.add(key);
                v.add(this.canvas.getValueAssPro().get(key));
                this.addRow(v);
            }
            keys = this.canvas.getValueAssOpp().keySet();
            for (String key : keys) {
                v = new Vector();
                v.add("Opponent");
                v.add(key);
                v.add(this.canvas.getValueAssOpp().get(key));
                this.addRow(v);
            }
        }

        public DomainCanvas<Ring> getCanvas() {
            return this.canvas;
        }
    }

    class ValuationRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Ring) {
                return super.getTableCellRendererComponent(table, ((Ring)value).toUnicode(), isSelected, hasFocus, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

