/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui.printview;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import lu.uni.adtool.Options;

public class JPrintPreviewBorder
extends AbstractBorder {
    private static final long serialVersionUID = 4666462256643686970L;
    private Insets insets;
    private int distance;
    private int borderWidth;

    public JPrintPreviewBorder() {
        this(5);
    }

    public JPrintPreviewBorder(int newDistance) {
        this(1, newDistance);
    }

    public JPrintPreviewBorder(int width, int newDistance) {
        this.distance = newDistance;
        this.borderWidth = width;
        this.insets = new Insets(width, width, width + this.distance, (int)((double)width + Math.ceil((double)this.distance / 1.5)));
    }

    public final Insets getInsets() {
        return this.insets;
    }

    public final void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        for (int i = 0; i < this.borderWidth; ++i) {
            g.setColor(Options.printview_border);
            g.drawRect(x + i, y + i, width - this.insets.right + this.borderWidth - i - i - 1, height - this.insets.bottom + this.borderWidth - i - i - 1);
        }
        g.setColor(Options.printview_shadow);
        g.fillRect(this.insets.right - this.borderWidth, height - this.insets.bottom + this.borderWidth, width - this.insets.right + this.borderWidth, this.insets.bottom - this.borderWidth);
        g.fillRect(width - this.insets.right + this.borderWidth, this.insets.bottom - this.borderWidth, this.insets.right - this.borderWidth, height - this.insets.bottom + this.borderWidth);
        g.setColor(Options.printview_background);
        g.fillRect(0, height - this.insets.bottom + this.borderWidth, this.insets.right - this.borderWidth, this.insets.bottom - this.borderWidth);
        g.fillRect(width - this.insets.right + this.borderWidth, 0, this.insets.right - this.borderWidth, this.insets.bottom - this.borderWidth);
        int compHeight = c.getHeight() - this.insets.bottom + this.insets.top;
        if (compHeight < this.distance) {
            int h = c.getHeight() - compHeight - compHeight;
            g.fillRect(0, compHeight, width, h);
        }
    }
}

