/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui.printview;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import lu.uni.adtool.Options;
import lu.uni.adtool.ui.printview.DefaultPageNumberRenderer;
import lu.uni.adtool.ui.printview.JPrintPreviewBorder;
import lu.uni.adtool.ui.printview.PageNumberRenderer;

public class JPrintPreviewPage
extends JComponent {
    static final long serialVersionUID = 3420168465142358486L;
    private Pageable pageable;
    private PageFormat pageformat;
    private int pageNumber;
    private int scaledWidth;
    private int scaledHeight;
    private int prefWidth;
    private int prefHeight;
    private double scaleX;
    private double scaleY;
    private Border border;
    private int rHeight;
    private PageNumberRenderer pageNumberRenderer;
    private BufferedImage cachedImage;
    private Rectangle imageableArea;

    public JPrintPreviewPage(Pageable newPageable, int newPageNumber) {
        this.pageable = newPageable;
        this.pageformat = this.pageable.getPageFormat(this.pageNumber);
        this.pageNumber = newPageNumber;
        this.prefWidth = (int)this.pageformat.getWidth();
        this.prefHeight = (int)this.pageformat.getHeight();
        this.scaledWidth = this.prefWidth;
        this.scaledHeight = this.prefHeight;
        this.imageableArea = new Rectangle((int)this.pageformat.getImageableX(), (int)this.pageformat.getImageableY(), (int)(this.pageformat.getImageableWidth() + 0.1), (int)(this.pageformat.getImageableHeight() + 0.1));
        if (Options.printview_showPageNumbers) {
            this.pageNumberRenderer = new DefaultPageNumberRenderer();
            Component numberRenderer = this.pageNumberRenderer.getRenderer(this.pageNumber + 1, false, false);
            this.rHeight = numberRenderer.getPreferredSize().height;
            this.border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, this.rHeight, 0), new JPrintPreviewBorder());
        } else {
            this.border = new JPrintPreviewBorder();
        }
        this.setBorder(this.border);
        this.setScale(1.0, 1.0);
    }

    public final Dimension getPreferredSize() {
        return new Dimension(this.scaledWidth + this.border.getBorderInsets((Component)this).right + this.border.getBorderInsets((Component)this).left, this.scaledHeight + this.border.getBorderInsets((Component)this).top + this.border.getBorderInsets((Component)this).bottom);
    }

    public final Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public final void paintComponent(Graphics g) {
        Graphics2D graphics = (Graphics2D)g.create();
        if (this.cachedImage == null) {
            this.cachedImage = new BufferedImage(this.scaledWidth, this.scaledHeight, 2);
            Graphics2D g2 = this.cachedImage.createGraphics();
            g2.setColor(Options.printview_paper);
            g2.fillRect(0, 0, this.scaledWidth, this.scaledHeight);
            g2.scale(this.scaleX, this.scaleY);
            g2.clip(this.imageableArea);
            try {
                this.pageable.getPrintable(this.pageNumber).print(g2, this.pageformat, this.pageNumber);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
            g2.dispose();
        }
        graphics.drawImage(this.cachedImage, null, 0, 0);
        this.cachedImage.flush();
        int height = (int)this.getPreferredSize().getHeight();
        if (this.pageNumberRenderer != null && Options.printview_showPageNumbers) {
            graphics.translate(0, height - this.rHeight);
            Component numberRenderer = this.pageNumberRenderer.getRenderer(this.pageNumber + 1, false, false);
            graphics.clipRect(0, 0, this.scaledWidth, this.rHeight);
            numberRenderer.setBounds(0, 0, this.scaledWidth, this.rHeight);
            numberRenderer.paint(graphics);
            graphics.translate(0, -(height - this.rHeight));
        }
        graphics.dispose();
    }

    public final void setScale(double scaleX, double scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaledWidth = (int)((double)this.prefWidth * scaleX);
        this.scaledHeight = (int)((double)this.prefHeight * scaleY);
        this.cachedImage = null;
        this.repaint();
    }
}

