/*
 * Decompiled with CFR 0.152.
 */
package entanglements;

import entanglements.PoissonDist;
import main.Entanglement;
import main.HelpFunc;

public class NegativeBinomialVariableP
extends Entanglement {
    private int param;
    private int speed;
    private double p = 0.5;
    private int r;

    public NegativeBinomialVariableP(int i, int speed) {
        this.param = i;
        this.r = i * i;
        this.p = 1.0 / ((double)i + 1.0);
        System.out.println(this.r);
        System.out.println(this.p);
        this.speed = speed;
    }

    @Override
    public int getImpact(int k) {
        return Math.min(k, Math.max(1, this.getImpactUnsafe(k)));
    }

    private int getImpactUnsafe(int k) {
        switch (this.speed) {
            case 0: {
                if (k <= this.param / 4) {
                    return k;
                }
                if (k <= this.param) {
                    return this.param / 4;
                }
                if (k <= 2 * this.param) {
                    return this.param / 8;
                }
                return 1;
            }
            case 1: {
                if (k <= this.param / 2) {
                    return k;
                }
                if (k <= this.param) {
                    return this.param / 2 + k / 2;
                }
                if (k <= 2 * this.param) {
                    return this.param / 2;
                }
                if (k <= 4 * this.param) {
                    return this.param / 4;
                }
                return this.param / 8;
            }
            case 2: {
                if (k <= this.param) {
                    return k;
                }
                if (k <= 2 * this.param) {
                    return this.param;
                }
                if (k <= 4 * this.param) {
                    return this.param / 2;
                }
                return this.param / 4;
            }
            case 3: {
                if (k <= 2 * this.param) {
                    return k;
                }
                if (k <= 4 * this.param) {
                    return this.param;
                }
                return this.param / 2;
            }
            case 4: {
                return k;
            }
            case 5: {
                return k;
            }
            case 6: {
                return k;
            }
        }
        return k;
    }

    @Override
    public int getMaxSize() {
        switch (this.speed) {
            case 0: {
                return 2 * this.param;
            }
            case 1: {
                return 3 * this.param;
            }
            case 2: {
                return 4 * this.param;
            }
            case 3: {
                return 5 * this.param;
            }
            case 4: {
                return 6 * this.param;
            }
            case 5: {
                return 8 * this.param;
            }
            case 6: {
                return 12 * this.param;
            }
        }
        return 3 * this.param;
    }

    @Override
    public double getProb(int k) {
        return HelpFunc.choose(this.r + k - 1, k) * Math.pow(1.0 - this.p, this.r) * Math.pow(this.p, k);
    }

    @Override
    public String systDistFileHeader() {
        return String.valueOf(this.getClass().getName()) + ";" + this.param;
    }

    @Override
    public int getExpectedSize() {
        return this.param;
    }

    @Override
    public Entanglement parseHeader(String string, int speed) {
        String[] answ = string.split(";");
        if (answ[0].equals("ExpDist")) {
            return new PoissonDist(Integer.parseInt(answ[1]), speed);
        }
        throw new RuntimeException("Unimplemented system distribution.");
    }

    public static String getUIName() {
        return "Negative binomial distribution (with p=1/(E+1), r=E^2)";
    }

    public static double getOrderPriority() {
        return 4.0;
    }
}

