/*
 * Decompiled with CFR 0.152.
 */
package lyingStrategies;

import java.util.Iterator;
import main.BetaSF;
import main.Chi;
import main.Entanglement;
import main.HelpFunc;
import main.Obs;
import main.Param;

public class ChiEntanglementSensitive
extends Chi {
    private static int entMode = -1;
    private static double nf = 0.0;
    private static Entanglement ent = null;

    @Override
    public double getProb(Obs t) {
        this.setEntMode();
        if (t.s + t.f < entMode) {
            return 0.0;
        }
        BetaSF p2 = new BetaSF(new Obs(this.myObs.f, this.myObs.s), this.settings);
        double choose = HelpFunc.choose(t.s + t.f, t.s);
        double sum = 0.0;
        double sd = this.sysDist.getProb(t.s + t.f) / (1.0 - nf);
        Iterator<Param> params = Param.iterator(this.chopSize);
        while (params.hasNext()) {
            Param param = params.next();
            double par = param.getValue();
            double val = choose * Math.pow(par, t.s) * Math.pow(1.0 - par, t.f) * sd * p2.getValueAt(param);
            sum += val;
        }
        return sum;
    }

    private void setEntMode() {
        double old;
        if (ent != null && ent.getClass().equals(this.settings.systemSizeDistribution.getClass()) && ent.getExpectedSize() == this.settings.systemSizeDistribution.getExpectedSize()) {
            return;
        }
        double sum = 0.0;
        int max = 0;
        double tsum = old = this.sysDist.getProb(0);
        int i = 1;
        while (i < this.sysDist.getMaxSize()) {
            double told = this.sysDist.getProb(i);
            tsum += told;
            if (told > old) {
                sum += tsum - told;
                tsum = told;
                old = told;
                max = i;
            }
            ++i;
        }
        ent = this.settings.systemSizeDistribution;
        entMode = max;
        nf = sum;
    }

    public static String getUIName() {
        return "Fabricates strongest realistic lie (depending on entanglement)";
    }

    public static String getParamDependency() {
        return "quick";
    }

    public static double getOrderPriority() {
        return 10.0;
    }
}

