/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import main.Beta;
import main.BetaPW;
import main.BetaSF;
import main.CalcSettings;
import main.Chi;
import main.Entanglement;
import main.Obs;
import main.Pair;

public class BetaCT
extends Beta {
    private Collection<Pair<Beta, Double>> graphs = new LinkedList<Pair<Beta, Double>>();
    private Entanglement sysDist;
    private CalcSettings settings;
    private Obs AB;
    private Obs AC;

    public BetaCT(Obs obsAB, Obs obsAC, CalcSettings settings) {
        this.settings = settings;
        this.chopSize = settings.chopSize;
        this.sysDist = settings.systemSizeDistribution;
        this.chopStep = 1.0 / (double)this.chopSize;
        this.AB = obsAB;
        this.AC = obsAC;
        this.sysDist = settings.systemSizeDistribution;
        Iterator<Obs.Selection> ws = Obs.monteCarlo(this.sysDist);
        while (ws.hasNext()) {
            Obs.Selection os = ws.next();
            Obs w = os.observation;
            double weight = os.weight;
            BetaPW b = new BetaPW(obsAB, obsAC, w, settings);
            Double d = new Double(b.getLieProb(w) * weight);
            this.graphs.add(new Pair<BetaPW, Double>(b, d));
        }
    }

    @Override
    public double getValueAt(int loc) {
        double sum = 0.0;
        for (Pair<Beta, Double> pair : this.graphs) {
            sum += ((Beta)pair.first).getValueAt(loc) * (Double)pair.second;
        }
        return sum;
    }

    @Override
    public double getEV() {
        double sum = 0.0;
        for (Pair<Beta, Double> pair : this.graphs) {
            sum += ((Beta)pair.first).getEV() * (Double)pair.second;
        }
        return sum;
    }

    @Override
    protected String betaFileHeader(String sep) {
        throw new RuntimeException("Saving/loading of this type not yet implemented");
    }

    @Override
    public double getVariance() {
        double m = this.getEV();
        double v = 0.0;
        int i = 0;
        while (i < this.chopSize) {
            double div = (double)i * this.chopStep - m;
            v += div * div * this.getValueAt(i);
            ++i;
        }
        return v;
    }

    @Override
    public Obs getClosestBeta() {
        double min = Double.MAX_VALUE;
        Obs result = null;
        Iterator<Obs.Selection> sels = Obs.monteCarlo(this.sysDist);
        while (sels.hasNext()) {
            Obs obs = sels.next().observation;
            double comp = this.getKLDiv(new BetaSF(obs, this.settings));
            if (!(comp < min)) continue;
            min = comp;
            result = obs;
        }
        return result;
    }

    @Override
    public Beta.BetaData getEntryData() {
        try {
            return new Beta.BetaData(this.getClass(), null, this.AB, this.AC, null, Chi.getUIName(this.settings.chiType), this.settings.systemSizeDistribution.getExpectedSize(), Entanglement.getUIName(this.settings.systemSizeDistribution.getClass()), this.getAverageKLDiv(), this.getAverageRelativeEntropy());
        }
        catch (Chi.ChiIncorrectlyImplementedException e) {
            e.printStackTrace();
        }
        catch (Entanglement.EntanglementIncorrectlyImplementedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public double getAverageKLDiv() {
        double sum = 0.0;
        double sum2 = 0.0;
        for (Pair<Beta, Double> pair : this.graphs) {
            Beta b = (Beta)pair.first;
            double d = (Double)pair.second;
            sum += this.getKLDiv(b) * d;
            sum2 += b.getKLDiv(this) * d;
        }
        return sum;
    }

    public double getAverageRelativeEntropy() {
        double sum = 0.0;
        for (Pair<Beta, Double> pair : this.graphs) {
            Beta b = (Beta)pair.first;
            double d = (Double)pair.second;
            sum += d * b.getEntropy();
        }
        return sum;
    }
}

