/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import main.Graph;
import main.Main;
import main.Timer;

public class MultiGraphView
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static MultiGraphView me = null;
    private List<Graph> graphs;
    private final int BOTTOM_SPACE = 32;
    private JPanel graphArea;
    private long time = -1L;
    private Timer t;
    protected boolean showCross;

    public MultiGraphView() {
        me = this;
        this.setSize(900, 500);
        this.setTitle("[TCC] Graph Overview");
        this.setLocation(Main.getNextWindowLocation());
        this.setVisible(true);
        this.getContentPane().setLayout(null);
        this.getContentPane().setBackground(Color.WHITE);
        this.graphs = new LinkedList<Graph>();
        this.graphArea = new JPanel(null){
            private static final long serialVersionUID = 603400452179412196L;

            @Override
            public void paint(Graphics g) {
                Point p = this.getMousePosition();
                g.setColor(Color.BLUE);
                if (MultiGraphView.this.showCross && p != null && 30 < p.x && p.x < this.getWidth() - 30 && 30 < p.y && p.y < this.getHeight() - 30) {
                    g.drawLine(p.x, 0, p.x, this.getHeight() - 0);
                    g.drawLine(0, p.y, this.getWidth() - 0, p.y);
                }
                ((Graphics2D)g).setStroke(new BasicStroke(1.5f));
                double mv = MultiGraphView.this.getMaxValue();
                String smv = Double.toString(Math.ceil(mv * 10.0) / 10.0);
                for (Graph gr : MultiGraphView.this.graphs) {
                    Point[] ps = gr.getPointIterator(new Rectangle(30, 30, this.getWidth() - 60, (int)((double)(this.getHeight() - 60) * gr.getMaxValue() / mv)));
                    g.setColor(gr.getColor());
                    int i = 1;
                    while (i < ps.length) {
                        g.drawLine(ps[i - 1].x, this.getHeight() - ps[i - 1].y, ps[i].x, this.getHeight() - ps[i].y);
                        ++i;
                    }
                }
                g.setColor(Color.BLACK);
                ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
                g.drawLine(30, 30, 30, this.getHeight() - 30);
                g.setFont(g.getFont().deriveFont(14.0f));
                g.drawString("0", 15, this.getHeight() - 25);
                int i = 5;
                while ((double)i < mv * 10.0) {
                    g.drawLine(28, this.getHeight() - (int)(30.0 + (double)((this.getHeight() - 60) * i) / (10.0 * mv)), 32, this.getHeight() - (int)(30.0 + (double)((this.getHeight() - 60) * i) / (10.0 * mv)));
                    g.drawString(Double.toString((double)i / 10.0), 5, this.getHeight() - (int)(25.0 + (double)((this.getHeight() - 60) * i) / (10.0 * mv)));
                    i += 5;
                }
                g.drawLine(28, 30, 32, 30);
                g.drawLine(30, this.getHeight() - 30, this.getWidth() - 30, this.getHeight() - 30);
                g.drawString("0", 27, this.getHeight() - 12);
                g.drawString("0.1", 22 + (this.getWidth() - 59) / 10, this.getHeight() - 12);
                g.drawLine(30 + (this.getWidth() - 60) / 10, this.getHeight() - 32, 30 + (this.getWidth() - 60) / 10, this.getHeight() - 28);
                g.drawString("0.2", 22 + (this.getWidth() - 59) / 5, this.getHeight() - 12);
                g.drawLine(30 + 2 * (this.getWidth() - 60) / 10, this.getHeight() - 32, 30 + 2 * (this.getWidth() - 60) / 10, this.getHeight() - 28);
                g.drawString("0.3", 22 + 3 * (this.getWidth() - 59) / 10, this.getHeight() - 12);
                g.drawLine(30 + 3 * (this.getWidth() - 60) / 10, this.getHeight() - 32, 30 + 3 * (this.getWidth() - 60) / 10, this.getHeight() - 28);
                g.drawString("0.4", 22 + 2 * (this.getWidth() - 59) / 5, this.getHeight() - 12);
                g.drawLine(30 + 4 * (this.getWidth() - 60) / 10, this.getHeight() - 32, 30 + 4 * (this.getWidth() - 60) / 10, this.getHeight() - 28);
                g.drawString("0.5", this.getWidth() / 2 - 8, this.getHeight() - 12);
                g.drawLine(this.getWidth() / 2, this.getHeight() - 32, this.getWidth() / 2, this.getHeight() - 28);
                g.drawString("0.6", 22 + 3 * (this.getWidth() - 59) / 5, this.getHeight() - 12);
                g.drawLine(30 + 6 * (this.getWidth() - 60) / 10, this.getHeight() - 32, 30 + 6 * (this.getWidth() - 60) / 10, this.getHeight() - 28);
                g.drawString("0.7", 22 + 7 * (this.getWidth() - 59) / 10, this.getHeight() - 12);
                g.drawLine(30 + 7 * (this.getWidth() - 60) / 10, this.getHeight() - 32, 30 + 7 * (this.getWidth() - 60) / 10, this.getHeight() - 28);
                g.drawString("0.8", 22 + 4 * (this.getWidth() - 59) / 5, this.getHeight() - 12);
                g.drawLine(30 + 8 * (this.getWidth() - 60) / 10, this.getHeight() - 32, 30 + 8 * (this.getWidth() - 60) / 10, this.getHeight() - 28);
                g.drawString("0.9", 22 + 9 * (this.getWidth() - 59) / 10, this.getHeight() - 12);
                g.drawLine(30 + 9 * (this.getWidth() - 60) / 10, this.getHeight() - 32, 30 + 9 * (this.getWidth() - 60) / 10, this.getHeight() - 28);
                g.drawString("1", this.getWidth() - 32, this.getHeight() - 12);
                g.drawLine(this.getWidth() - 30, this.getHeight() - 32, this.getWidth() - 30, this.getHeight() - 28);
            }
        };
        this.graphArea.setLocation(0, 0);
        this.graphArea.setSize(this.getWidth(), this.getHeight() - 32);
        JToolTip jtt = new JToolTip();
        jtt.setComponent(this.graphArea);
        jtt.setSize(jtt.getPreferredSize());
        jtt.setVisible(false);
        this.add(jtt);
        this.getContentPane().add(this.graphArea);
        this.getContentPane().addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorResized(HierarchyEvent arg0) {
                MultiGraphView.this.graphArea.setSize(MultiGraphView.this.getWidth(), MultiGraphView.this.getHeight() - 32);
                MultiGraphView.this.repaint();
            }

            @Override
            public void ancestorMoved(HierarchyEvent arg0) {
            }
        });
        this.setDefaultCloseOperation(2);
    }

    public void addGraph(Graph gr) {
        this.graphs.add(gr);
        Graph.CalcData d = gr.getGraphData();
        this.repaint();
    }

    public static void removeGraph(Graph g) {
        MultiGraphView.me.graphs.remove(g);
        me.repaint();
    }

    private double getMaxValue() {
        double result = 1.1;
        for (Graph gr : this.graphs) {
            result = Math.max(result, gr.getMaxValue());
        }
        return result;
    }

    protected double getRelativeY(int y) {
        double t = (double)(this.graphArea.getHeight() - 7 - y) / (double)(this.graphArea.getHeight() - 60);
        return this.getMaxValue() * t;
    }

    protected double getRelativeX(int x) {
        return (double)(x - 30) / (double)(this.graphArea.getWidth() - 60);
    }

    private void setXY(JToolTip jtt, Graph.Info i) {
        jtt.setTipText("<html><table><tr><td>x position:</td><td>" + this.shortPrint(i.x) + "</td></tr><tr><td>y position:</td><td>" + this.shortPrint(i.y) + "</td></tr><tr><td>f(x):</td><td>" + this.shortPrint(i.fx) + "</td></tr><tr><td>Expected entropy for x:</td><td>" + this.shortPrint(i.ex) + "</td></tr></table></html>");
        jtt.setSize(jtt.getPreferredSize());
        Point mp = this.getMousePosition();
        if (mp == null) {
            return;
        }
        jtt.setLocation(mp.x, mp.y - 15);
        if (jtt.getX() + jtt.getWidth() > this.getWidth()) {
            jtt.setLocation(jtt.getX() - jtt.getWidth() - 6, jtt.getY());
        }
    }

    private String shortPrint(double x) {
        String s = "" + Math.round(x * 1000.0);
        if (s.length() >= 4) {
            return String.valueOf(s.substring(0, s.length() - 3)) + "." + s.substring(s.length() - 3);
        }
        if (s.length() == 3) {
            return "0." + s;
        }
        if (s.length() == 2) {
            return "0.0" + s;
        }
        if (s.length() == 1) {
            return "0.00" + s;
        }
        return "";
    }
}

