/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import javax.swing.JOptionPane;
import main.Obs;
import main.Pair;
import main.Param;

public abstract class Beta {
    protected int chopSize;
    protected double chopStep;

    public abstract double getValueAt(int var1);

    public abstract double getEV();

    protected abstract String betaFileHeader(String var1);

    public abstract double getVariance();

    public abstract Obs getClosestBeta();

    public double getValueAt(Param b) {
        return this.getValueAt(b.getRawValue());
    }

    public Pair<Double, Integer> maxVal() {
        double mv = 0.0;
        int out = 0;
        int i = 0;
        while (i < this.chopSize) {
            if (mv < this.getValueAt(i)) {
                mv = this.getValueAt(i);
                out = i;
            }
            ++i;
        }
        return new Pair<Double, Integer>(new Double(mv * (double)this.chopSize), new Integer(out));
    }

    public boolean saveBeta(File f) {
        block4: {
            Object[] options;
            int n;
            boolean newFile = f.createNewFile();
            if (newFile || (n = JOptionPane.showOptionDialog(null, "Would you like to overwrite the existing file?", "Existing file", 2, 3, null, options = new Object[]{"Overwrite file", "Cancel"}, options[0])) != 1 && n != -1) break block4;
            return false;
        }
        try {
            FileOutputStream fos = new FileOutputStream(f, false);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            this.writeSaveBeta(osw);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Inconsistency, created file cannot be found. Program will continue without saving.");
        }
        catch (IOException e) {
            throw new RuntimeException("Output error while saving graph. Program will continue without saving.");
        }
        return true;
    }

    protected void writeSaveBeta(OutputStreamWriter osw) throws IOException {
        String smallSep = ",";
        String bigSep = "\r\n";
        osw.write(this.betaFileHeader(smallSep));
        int i = 0;
        while (i < this.chopSize) {
            osw.write(bigSep);
            osw.write(String.valueOf(i) + smallSep + this.getValueAt(i));
            ++i;
        }
        osw.close();
    }

    public double getExpectedEntropy(Param p) {
        double sum = 0.0;
        Iterator<Param> it = Param.iterator(this.chopSize);
        while (it.hasNext()) {
            Param q = it.next();
            sum += this.getValueAt(q) * Beta.getBernoulliEntropy(p, q);
        }
        return sum;
    }

    public double getRelativeEntropy() {
        return this.getRelativeEntropy(this);
    }

    public double getRelativeEntropy(Beta alt) {
        double e = 0.0;
        Iterator<Param> ps = Param.iterator(this.chopSize);
        while (ps.hasNext()) {
            Param p = ps.next();
            e += alt.getValueAt(p) * this.getExpectedEntropy(p);
        }
        return e;
    }

    static double getBernoulliEntropy(Param p, Param q) {
        double px = p.getValue();
        double qx = q.getValue();
        return px * Math.log(px / qx) + (1.0 - px) * Math.log((1.0 - px) / (1.0 - qx));
    }

    public double getKLDiv(Beta alt) {
        double sum = 0.0;
        Iterator<Param> pars = Param.iterator(this.chopSize);
        while (pars.hasNext()) {
            Param p = pars.next();
            double dp = this.getValueAt(p);
            sum += dp * Math.log(dp / alt.getValueAt(p));
        }
        return sum;
    }

    public double getEntropy() {
        double sum = 0.0;
        Iterator<Param> pars = Param.iterator(this.chopSize);
        while (pars.hasNext()) {
            Param p = pars.next();
            double dp = this.getValueAt(p);
            sum -= dp * Math.log(dp * (double)this.chopSize);
        }
        return sum;
    }

    public abstract BetaData getEntryData();

    public static class BetaData {
        public Class<? extends Beta> classStr;
        public Obs self;
        public Obs obsAB;
        public Obs obsAC;
        public Obs statBC;
        public String strategy;
        public int expectedSize;
        public String sizeDistName;
        public double KLDiv;
        public double relEntropy;

        public BetaData(Class<? extends Beta> classStr, Obs self, Obs obsAB, Obs obsAC, Obs statBC, String string, int expectedSize, String sizeDistName, double kLDiv, double relEntropy) {
            this.classStr = classStr;
            this.self = self;
            this.obsAB = obsAB;
            this.obsAC = obsAC;
            this.statBC = statBC;
            this.strategy = string;
            this.expectedSize = expectedSize;
            this.sizeDistName = sizeDistName;
            this.KLDiv = kLDiv;
            this.relEntropy = relEntropy;
        }
    }
}

