/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Iterator;
import main.Beta;
import main.BetaSF;
import main.CalcSettings;
import main.Chi;
import main.Entanglement;
import main.HelpFunc;
import main.Obs;
import main.Pair;
import main.Param;
import main.SingletonChi;

public class BetaPW
extends Beta {
    private double[] values;
    private Entanglement sysDist;
    private CalcSettings settings;
    private Obs AB;
    private Obs AC;
    private Obs BC;

    public BetaPW(Obs obsAB, Obs obsAC, Obs statBC, CalcSettings settings) {
        this.settings = settings;
        this.chopSize = settings.chopSize;
        this.sysDist = settings.systemSizeDistribution;
        this.chopStep = 1.0 / (double)this.chopSize;
        this.AB = obsAB;
        this.AC = obsAC;
        this.BC = statBC;
        BetaSF p1 = new BetaSF(new Obs[]{obsAC, statBC}, settings);
        this.values = new double[this.chopSize];
        double se33 = this.SE33(obsAB, statBC, obsAC);
        double se4 = this.SE4(obsAB, statBC, obsAC, se33);
        Iterator<Param> cs = Param.iterator(this.chopSize);
        while (cs.hasNext()) {
            Param c = cs.next();
            int i = c.getRawValue();
            this.values[i] = ((Beta)p1).getValueAt(i) * se4;
        }
        int counter = 0;
        String met = "";
        try {
            met = Chi.getParamDependancy(settings.chiType);
        }
        catch (Chi.ChiIncorrectlyImplementedException e) {
            e.printStackTrace();
        }
        if (met.equals("singleton")) {
            Obs w = ((SingletonChi)((Object)Chi.getChi(new Param(0.5, settings.chopSize), statBC, settings))).getPoint();
            BetaSF p2 = new BetaSF(new Obs[]{obsAC, w}, settings);
            double se3 = this.SE3(w, obsAB, statBC, obsAC, se33);
            Iterator<Param> cs2 = Param.iterator(this.chopSize);
            while (cs2.hasNext()) {
                int i;
                Param c = cs2.next();
                int n = i = c.getRawValue();
                this.values[n] = this.values[n] + ((Beta)p2).getValueAt(i) * se3 * (1.0 - se4);
            }
        } else {
            Iterator<Obs.Selection> ws = Obs.monteCarlo(this.sysDist);
            while (ws.hasNext()) {
                Obs.Selection os = ws.next();
                Obs w = os.observation;
                ++counter;
                double weight = os.weight;
                BetaSF p2 = new BetaSF(new Obs[]{obsAC, w}, settings);
                double se3 = this.SE3(w, obsAB, statBC, obsAC, se33);
                Iterator<Param> cs3 = Param.iterator(this.chopSize);
                while (cs3.hasNext()) {
                    int i;
                    Param c = cs3.next();
                    int n = i = c.getRawValue();
                    this.values[n] = this.values[n] + ((Beta)p2).getValueAt(i) * se3 * (1.0 - se4) * weight;
                }
            }
        }
    }

    private double SE31(Obs w, Obs x, Obs y) {
        try {
            double sum = 0.0;
            String met = Chi.getParamDependancy(this.settings.chiType);
            if (met.equals("quick") || met.equals("singleton")) {
                double t;
                sum = t = Chi.getChi(null, w, this.settings).getProb(y);
            } else if (met.equals("pDependent")) {
                BetaSF p1 = new BetaSF(x, this.settings);
                Iterator<Param> bs = Param.iterator(this.chopSize);
                while (bs.hasNext()) {
                    Param b = bs.next();
                    double val = Chi.getChi(b, w, this.settings).getProb(y) * p1.getValueAt(b);
                    sum += val;
                }
            }
            return sum;
        }
        catch (Chi.ChiIncorrectlyImplementedException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    private double SE32(Obs w, Obs z) {
        BetaSF p2 = new BetaSF(z, this.settings);
        double choose = HelpFunc.choose(w.s + w.f, w.s);
        double sum = 0.0;
        Iterator<Param> cs = Param.iterator(this.chopSize);
        while (cs.hasNext()) {
            Param c = cs.next();
            double par = c.getValue();
            double val = choose * Math.pow(par, w.s) * Math.pow(1.0 - par, w.f) * this.sysDist.getProb(w.s + w.f) * p2.getValueAt(c);
            sum += val;
        }
        return sum;
    }

    private double SE33(Obs x, Obs y, Obs z) {
        try {
            double sum = 0.0;
            String met = Chi.getParamDependancy(this.settings.chiType);
            if (met.equals("singleton")) {
                double t;
                Obs w = ((SingletonChi)((Object)Chi.getChi(new Param(0.5, this.settings.chopSize), y, this.settings))).getPoint();
                double ss1 = 0.0;
                ss1 = t = this.SE31(w, x, y);
                double ss2 = 0.0;
                BetaSF p2 = new BetaSF(z, this.settings);
                double choose = HelpFunc.choose(w.s + w.f, w.s);
                double prob = this.sysDist.getProb(w.s + w.f);
                Iterator<Param> cs = Param.iterator(this.chopSize);
                while (cs.hasNext()) {
                    Param c = cs.next();
                    double par = c.getValue();
                    double val = choose * Math.pow(par, w.s) * Math.pow(1.0 - par, w.f) * prob * p2.getValueAt(c);
                    ss2 += val;
                }
                return sum += ss1 * ss2;
            }
            Iterator<Obs.Selection> ws = Obs.monteCarlo(this.sysDist);
            while (ws.hasNext()) {
                double t;
                Obs.Selection os = ws.next();
                Obs w = os.observation;
                double weight = os.weight;
                double ss1 = 0.0;
                ss1 = t = this.SE31(w, x, y);
                double ss2 = 0.0;
                BetaSF p2 = new BetaSF(z, this.settings);
                double choose = HelpFunc.choose(w.s + w.f, w.s);
                double prob = this.sysDist.getProb(w.s + w.f);
                Iterator<Param> cs = Param.iterator(this.chopSize);
                while (cs.hasNext()) {
                    Param c = cs.next();
                    double par = c.getValue();
                    double val = choose * Math.pow(par, w.s) * Math.pow(1.0 - par, w.f) * prob * p2.getValueAt(c);
                    ss2 += val;
                }
                sum += ss1 * ss2 * weight;
            }
            return sum;
        }
        catch (Chi.ChiIncorrectlyImplementedException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    private double SE3(Obs w, Obs x, Obs y, Obs z, double se33) {
        double se31 = this.SE31(w, x, y);
        double se32 = this.SE32(w, z);
        if (se33 == 0.0 && se31 == 0.0) {
            return 0.0;
        }
        return se31 * se32 / se33;
    }

    private double SE41(Obs y, Obs z) {
        BetaSF p2 = new BetaSF(z, this.settings);
        double choose = HelpFunc.choose(y.s + y.f, y.s);
        double sum = 0.0;
        Iterator<Param> params = Param.iterator(this.chopSize);
        while (params.hasNext()) {
            Param param = params.next();
            double par = param.getValue();
            double val = choose * Math.pow(par, y.s) * Math.pow(1.0 - par, y.f) * this.sysDist.getProb(y.s + y.f) * p2.getValueAt(param);
            sum += val;
        }
        return sum;
    }

    private double SE42(Obs x) {
        BetaSF p2 = new BetaSF(x, this.settings);
        double sum = 0.0;
        Iterator<Param> params = Param.iterator(this.chopSize);
        while (params.hasNext()) {
            Param param = params.next();
            sum += param.getValue() * p2.getValueAt(param);
        }
        return sum;
    }

    private double SE4(Obs x, Obs y, Obs z, double se33) {
        double se41 = this.SE41(y, z);
        double se42 = this.SE42(x);
        return se41 * se42 / (se41 * se42 + se33 * (1.0 - se42));
    }

    @Override
    public double getValueAt(int loc) {
        return this.values[loc];
    }

    @Override
    public double getEV() {
        double r = 0.0;
        int i = 0;
        while (i < this.chopSize) {
            r += this.getValueAt(i) * ((double)i * this.chopStep + this.chopStep / 2.0);
            ++i;
        }
        return r;
    }

    @Override
    protected String betaFileHeader(String sep) {
        return String.valueOf(this.getClass().getName()) + sep + this.chopSize + sep + this.settings.speedVSExact + sep + this.settings.systemSizeDistribution.systDistFileHeader() + sep + this.settings.chiType;
    }

    public Pair<Obs, Pair<Obs, Obs>> getOriginals() {
        return new Pair<Obs, Pair<Obs, Obs>>(this.AB, new Pair<Obs, Obs>(this.AC, this.BC));
    }

    @Override
    public double getVariance() {
        double m = this.getEV();
        double v = 0.0;
        int i = 0;
        while (i < this.chopSize) {
            double div = (double)i * this.chopStep - m;
            v += div * div * this.getValueAt(i);
            ++i;
        }
        return v;
    }

    @Override
    public Obs getClosestBeta() {
        double min = Double.MAX_VALUE;
        Obs result = null;
        Iterator<Obs.Selection> sels = Obs.monteCarlo(this.sysDist);
        while (sels.hasNext()) {
            Obs obs = sels.next().observation;
            double comp = this.getKLDiv(new BetaSF(obs, this.settings));
            if (!(comp < min)) continue;
            min = comp;
            result = obs;
        }
        return result;
    }

    @Override
    public Beta.BetaData getEntryData() {
        try {
            return new Beta.BetaData(this.getClass(), null, this.AB, this.AC, this.BC, Chi.getUIName(this.settings.chiType), this.settings.systemSizeDistribution.getExpectedSize(), Entanglement.getUIName(this.settings.systemSizeDistribution.getClass()), 0.0, 0.0);
        }
        catch (Chi.ChiIncorrectlyImplementedException e) {
            e.printStackTrace();
        }
        catch (Entanglement.EntanglementIncorrectlyImplementedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public double getLieProb(Obs w) {
        return this.SE41(w, this.AC) * this.SE42(this.AB) + this.SE33(this.AB, w, this.AC) * (1.0 - this.SE42(this.AB));
    }
}

