/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import main.Beta;
import main.BetaCT;
import main.BetaPW;
import main.BetaSF;
import main.Graph;
import main.Main;
import main.MultiGraphView;
import main.Obs;
import main.Timer;

public class GraphView
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Graph graph;
    private final int BOTTOM_SPACE = 300;
    private JPanel iInterface;
    private JPanel iInterface2;
    private JPanel graphArea;
    private JPanel loader;
    private long time = -1L;
    private Timer t;
    protected boolean showCross;

    public GraphView() {
        this.setSize(900, 800);
        this.setTitle("[TCC] Graph");
        this.setLocation(Main.getNextWindowLocation());
        this.setVisible(true);
        this.getContentPane().setLayout(null);
        this.loader = new JPanel(null){
            private static final long serialVersionUID = 3594916543035568799L;

            @Override
            public void paint(Graphics g) {
                g.clearRect(0, 0, 61, 61);
                double d = Calendar.getInstance().getTimeInMillis() / 1L % 800L;
                g.setColor(Color.LIGHT_GRAY);
                if (d < 300.0) {
                    g.fillOval(0, 25, 10, 10);
                }
                if (d >= 100.0 && d < 400.0) {
                    g.fillOval(8, 8, 10, 10);
                }
                if (d >= 200.0 && d < 500.0) {
                    g.fillOval(25, 0, 10, 10);
                }
                if (d >= 300.0 && d < 600.0) {
                    g.fillOval(42, 8, 10, 10);
                }
                if (d >= 400.0 && d < 700.0) {
                    g.fillOval(50, 25, 10, 10);
                }
                if (d >= 500.0) {
                    g.fillOval(42, 42, 10, 10);
                }
                if (d >= 600.0 || d < 100.0) {
                    g.fillOval(25, 50, 10, 10);
                }
                if (d >= 700.0 || d < 200.0) {
                    g.fillOval(8, 42, 10, 10);
                }
                g.setColor(Color.GRAY);
                if (d < 200.0) {
                    g.fillOval(0, 25, 10, 10);
                }
                if (d >= 100.0 && d < 300.0) {
                    g.fillOval(8, 8, 10, 10);
                }
                if (d >= 200.0 && d < 400.0) {
                    g.fillOval(25, 0, 10, 10);
                }
                if (d >= 300.0 && d < 500.0) {
                    g.fillOval(42, 8, 10, 10);
                }
                if (d >= 400.0 && d < 600.0) {
                    g.fillOval(50, 25, 10, 10);
                }
                if (d >= 500.0 && d < 700.0) {
                    g.fillOval(42, 42, 10, 10);
                }
                if (d >= 600.0) {
                    g.fillOval(25, 50, 10, 10);
                }
                if (d >= 700.0 || d < 100.0) {
                    g.fillOval(8, 42, 10, 10);
                }
                g.setColor(Color.DARK_GRAY);
                if (d < 100.0) {
                    g.fillOval(0, 25, 10, 10);
                }
                if (d >= 100.0 && d < 200.0) {
                    g.fillOval(8, 8, 10, 10);
                }
                if (d >= 200.0 && d < 300.0) {
                    g.fillOval(25, 0, 10, 10);
                }
                if (d >= 300.0 && d < 400.0) {
                    g.fillOval(42, 8, 10, 10);
                }
                if (d >= 400.0 && d < 500.0) {
                    g.fillOval(50, 25, 10, 10);
                }
                if (d >= 500.0 && d < 600.0) {
                    g.fillOval(42, 42, 10, 10);
                }
                if (d >= 600.0 && d < 700.0) {
                    g.fillOval(25, 50, 10, 10);
                }
                if (d >= 700.0) {
                    g.fillOval(8, 42, 10, 10);
                }
            }
        };
        this.loader.setSize(61, 61);
        this.loader.setLocation(this.getWidth() / 2 - 30, this.getHeight() / 2 - 30);
        this.t = new Timer();
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (GraphView.this.loader != null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (GraphView.this.loader == null) continue;
                    GraphView.this.loader.repaint();
                }
            }
        }).start();
        this.getContentPane().add(this.loader);
        this.setDefaultCloseOperation(2);
    }

    public void addGraph(Graph gr) {
        JLabel ab;
        JLabel abT;
        this.time = this.t.stop(true);
        this.remove(this.loader);
        this.loader = null;
        this.graph = gr;
        Graph.CalcData d = gr.getGraphData();
        this.iInterface = new JPanel(null);
        this.iInterface.setLocation(30, this.getHeight() - 300 + 20);
        int x1 = 220;
        int x2 = 0;
        int y = 0;
        JLabel evT = new JLabel("Expected value:");
        evT.setLocation(x2, y);
        evT.setSize(evT.getPreferredSize());
        this.iInterface.add(evT);
        JLabel ev = new JLabel(new Double(d.ev).toString());
        ev.setLocation(x1, y);
        ev.setSize(ev.getPreferredSize());
        this.iInterface.add(ev);
        JLabel maxValT = new JLabel("Maximum value (value at mode):");
        maxValT.setLocation(x2, y += ev.getHeight() + 10);
        maxValT.setSize(maxValT.getPreferredSize());
        this.iInterface.add(maxValT);
        JLabel maxVal = new JLabel(new Double(d.maxVal).toString());
        maxVal.setLocation(x1, y);
        maxVal.setSize(maxVal.getPreferredSize());
        this.iInterface.add(maxVal);
        JLabel modeT = new JLabel("Mode (location of maximum value):");
        modeT.setLocation(x2, y += maxVal.getHeight() + 10);
        modeT.setSize(modeT.getPreferredSize());
        this.iInterface.add(modeT);
        JLabel mode = new JLabel(new Double(d.mode).toString());
        mode.setLocation(x1, y);
        mode.setSize(mode.getPreferredSize());
        this.iInterface.add(mode);
        JLabel varianceT = new JLabel("Variance:");
        varianceT.setLocation(x2, y += mode.getHeight() + 10);
        varianceT.setSize(varianceT.getPreferredSize());
        this.iInterface.add(varianceT);
        JLabel variance = new JLabel(new Double(d.variance).toString());
        variance.setLocation(x1, y);
        variance.setSize(variance.getPreferredSize());
        this.iInterface.add(variance);
        JLabel entropyT = new JLabel("Entropy (relative to itself):");
        entropyT.setLocation(x2, y += variance.getHeight() + 10);
        entropyT.setSize(entropyT.getPreferredSize());
        this.iInterface.add(entropyT);
        JLabel entropy = new JLabel(new Double(d.entropy).toString());
        entropy.setLocation(x1, y);
        entropy.setSize(entropy.getPreferredSize());
        this.iInterface.add(entropy);
        JLabel trueEntropyT = new JLabel("Entropy (relative to U[0,1]):");
        trueEntropyT.setLocation(x2, y += entropy.getHeight() + 10);
        trueEntropyT.setSize(trueEntropyT.getPreferredSize());
        this.iInterface.add(trueEntropyT);
        JLabel trueEntropy = new JLabel(new Double(d.trueEntropy).toString());
        trueEntropy.setLocation(x1, y);
        trueEntropy.setSize(trueEntropy.getPreferredSize());
        this.iInterface.add(trueEntropy);
        JLabel closestObsT = new JLabel("Beta distr. closest to this:");
        closestObsT.setLocation(x2, y += trueEntropy.getHeight() + 10);
        closestObsT.setSize(closestObsT.getPreferredSize());
        this.iInterface.add(closestObsT);
        Obs te = d.closestBeta;
        JLabel closestObs = null;
        closestObs = te != null ? new JLabel(te.toString()) : new JLabel("Undefined");
        closestObs.setLocation(x1, y);
        closestObs.setSize(closestObs.getPreferredSize());
        this.iInterface.add(closestObs);
        y += closestObs.getHeight() + 10;
        if (this.time >= 0L) {
            JLabel timeT = new JLabel("Calculation time:");
            timeT.setLocation(x2, y);
            timeT.setSize(timeT.getPreferredSize());
            this.iInterface.add(timeT);
            JLabel timeL = new JLabel(new Long(this.time).toString());
            timeL.setLocation(x1, y);
            timeL.setSize(timeL.getPreferredSize());
            this.iInterface.add(timeL);
            y += timeL.getHeight() + 10;
        }
        JButton save = new JButton("Save graph");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser jfc = new JFileChooser(Main.DEFAULT_DIR);
                int val = jfc.showSaveDialog(GraphView.this.iInterface);
                if (val == 0) {
                    File file = jfc.getSelectedFile();
                    GraphView.this.graph.saveToFile(file);
                }
            }
        });
        save.setSize(save.getPreferredSize());
        save.setLocation(x2, y);
        this.iInterface.add(save);
        this.iInterface.setSize(400, 280);
        this.iInterface2 = new JPanel(null);
        this.iInterface2.setLocation(480, this.getHeight() - 300 + 20);
        x1 = 220;
        x2 = 0;
        y = 0;
        Beta.BetaData bd = this.graph.getBetaData();
        if (bd.classStr.equals(BetaPW.class)) {
            abT = new JLabel("Obs subject->intermediate:");
            abT.setLocation(x2, y);
            abT.setSize(abT.getPreferredSize());
            this.iInterface2.add(abT);
            ab = new JLabel(bd.obsAB.toString());
            ab.setLocation(x1, y);
            ab.setSize(ab.getPreferredSize());
            this.iInterface2.add(ab);
            JLabel bcT = new JLabel("Stat intermediate->target:");
            bcT.setLocation(x2, y += ab.getHeight() + 10);
            bcT.setSize(bcT.getPreferredSize());
            this.iInterface2.add(bcT);
            JLabel bc = new JLabel(bd.statBC.toString());
            bc.setLocation(x1, y);
            bc.setSize(bc.getPreferredSize());
            this.iInterface2.add(bc);
            JLabel acT = new JLabel("Obs subject->target:");
            acT.setLocation(x2, y += bc.getHeight() + 10);
            acT.setSize(acT.getPreferredSize());
            this.iInterface2.add(acT);
            JLabel ac = new JLabel(bd.obsAC.toString());
            ac.setLocation(x1, y);
            ac.setSize(ac.getPreferredSize());
            this.iInterface2.add(ac);
            JLabel chiT = new JLabel("Lying strategy (chi):");
            chiT.setLocation(x2, y += ac.getHeight() + 10);
            chiT.setSize(chiT.getPreferredSize());
            this.iInterface2.add(chiT);
            JLabel chi = new JLabel(bd.strategy.toString());
            chi.setLocation(x1, y);
            chi.setSize(chi.getPreferredSize());
            this.iInterface2.add(chi);
            JLabel expT = new JLabel("Expected obs size:");
            expT.setLocation(x2, y += chi.getHeight() + 10);
            expT.setSize(expT.getPreferredSize());
            this.iInterface2.add(expT);
            JLabel exp = new JLabel(Integer.toString(bd.expectedSize));
            exp.setLocation(x1, y);
            exp.setSize(exp.getPreferredSize());
            this.iInterface2.add(exp);
            JLabel distT = new JLabel("Obs size distribution:");
            distT.setLocation(x2, y += exp.getHeight() + 10);
            distT.setSize(distT.getPreferredSize());
            this.iInterface2.add(distT);
            JLabel dist = new JLabel(bd.sizeDistName);
            dist.setLocation(x1, y);
            dist.setSize(dist.getPreferredSize());
            this.iInterface2.add(dist);
            y += dist.getHeight() + 10;
        } else if (bd.classStr.equals(BetaSF.class)) {
            JLabel acT = new JLabel("Observations:");
            acT.setLocation(x2, y);
            acT.setSize(acT.getPreferredSize());
            this.iInterface2.add(acT);
            JLabel ac = new JLabel(bd.self.toString());
            ac.setLocation(x1, y);
            ac.setSize(ac.getPreferredSize());
            this.iInterface2.add(ac);
            y += ac.getHeight() + 10;
        } else if (bd.classStr.equals(BetaCT.class)) {
            abT = new JLabel("Obs subject->intermediate:");
            abT.setLocation(x2, y);
            abT.setSize(abT.getPreferredSize());
            this.iInterface2.add(abT);
            ab = new JLabel(bd.obsAB.toString());
            ab.setLocation(x1, y);
            ab.setSize(ab.getPreferredSize());
            this.iInterface2.add(ab);
            JLabel acT = new JLabel("Obs subject->target:");
            acT.setLocation(x2, y += ab.getHeight() + 10);
            acT.setSize(acT.getPreferredSize());
            this.iInterface2.add(acT);
            JLabel ac = new JLabel(bd.obsAC.toString());
            ac.setLocation(x1, y);
            ac.setSize(ac.getPreferredSize());
            this.iInterface2.add(ac);
            JLabel chiT = new JLabel("Lying strategy (chi):");
            chiT.setLocation(x2, y += ac.getHeight() + 10);
            chiT.setSize(chiT.getPreferredSize());
            this.iInterface2.add(chiT);
            JLabel chi = new JLabel(bd.strategy.toString());
            chi.setLocation(x1, y);
            chi.setSize(chi.getPreferredSize());
            this.iInterface2.add(chi);
            JLabel expT = new JLabel("Expected size of entanglement:");
            expT.setLocation(x2, y += chi.getHeight() + 10);
            expT.setSize(expT.getPreferredSize());
            this.iInterface2.add(expT);
            JLabel exp = new JLabel(Integer.toString(bd.expectedSize));
            exp.setLocation(x1, y);
            exp.setSize(exp.getPreferredSize());
            this.iInterface2.add(exp);
            JLabel distT = new JLabel("Entanglement distribution:");
            distT.setLocation(x2, y += exp.getHeight() + 10);
            distT.setSize(distT.getPreferredSize());
            this.iInterface2.add(distT);
            JLabel dist = new JLabel(bd.sizeDistName);
            dist.setLocation(x1, y);
            dist.setSize(dist.getPreferredSize());
            this.iInterface2.add(dist);
            JLabel klT = new JLabel("KL divergence with original:");
            klT.setLocation(x2, y += exp.getHeight() + 10);
            klT.setSize(klT.getPreferredSize());
            this.iInterface2.add(klT);
            JLabel kl = new JLabel(Double.toString(bd.KLDiv));
            kl.setLocation(x1, y);
            kl.setSize(kl.getPreferredSize());
            this.iInterface2.add(kl);
            JLabel relT = new JLabel("Relative entropy:");
            relT.setLocation(x2, y += exp.getHeight() + 10);
            relT.setSize(relT.getPreferredSize());
            this.iInterface2.add(relT);
            JLabel rel = new JLabel(Double.toString(bd.relEntropy));
            rel.setLocation(x1, y);
            rel.setSize(rel.getPreferredSize());
            this.iInterface2.add(rel);
            y += rel.getHeight() + 10;
        } else {
            throw new RuntimeException("Class is not registered");
        }
        JButton colorchange = new JButton("Change color");
        colorchange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Color newColor = JColorChooser.showDialog(null, "test", GraphView.this.graph.getColor());
                GraphView.this.graph.changeColor(newColor);
                GraphView.this.repaint();
                Main.updateMultiGraphView();
            }
        });
        colorchange.setSize(colorchange.getPreferredSize());
        colorchange.setLocation(x2, y);
        this.iInterface2.add(colorchange);
        this.iInterface2.setSize(this.getWidth(), 280);
        this.graphArea = new JPanel(null){
            private static final long serialVersionUID = 603400452179412196L;

            @Override
            public void paint(Graphics g) {
                Point p = this.getMousePosition();
                g.setColor(Color.BLUE);
                if (GraphView.this.showCross && p != null && 30 < p.x && p.x < this.getWidth() - 30 && 30 < p.y && p.y < this.getHeight() - 30) {
                    g.drawLine(p.x, 0, p.x, this.getHeight() - 0);
                    g.drawLine(0, p.y, this.getWidth() - 0, p.y);
                }
                Point[] ps = GraphView.this.graph.getPointIterator(new Rectangle(30, 30, this.getWidth() - 60, this.getHeight() - 60));
                double mv = GraphView.this.graph.getMaxValue();
                String smv = Double.toString(Math.ceil(mv * 10.0) / 10.0);
                ((Graphics2D)g).setStroke(new BasicStroke(1.5f));
                g.setColor(GraphView.this.graph.getColor());
                int i = 1;
                while (i < ps.length) {
                    g.drawLine(ps[i - 1].x, this.getHeight() - ps[i - 1].y, ps[i].x, this.getHeight() - ps[i].y);
                    ++i;
                }
                g.setColor(Color.BLACK);
                g.drawLine(30, 30, 30, this.getHeight() - 30);
                g.drawString("0", 15, this.getHeight() - 25);
                i = 5;
                while ((double)i < mv * 10.0) {
                    g.drawLine(28, this.getHeight() - (int)(30.0 + (double)((this.getHeight() - 60) * i) / (10.0 * mv)), 32, this.getHeight() - (int)(30.0 + (double)((this.getHeight() - 60) * i) / (10.0 * mv)));
                    g.drawString(Double.toString((double)i / 10.0), 5, this.getHeight() - (int)(25.0 + (double)((this.getHeight() - 60) * i) / (10.0 * mv)));
                    i += 5;
                }
                g.drawLine(28, 30, 32, 30);
                g.drawLine(30, this.getHeight() - 30, this.getWidth() - 30, this.getHeight() - 30);
                g.drawString("0", 27, this.getHeight() - 12);
                g.drawString("0.1", 22 + (this.getWidth() - 59) / 10, this.getHeight() - 12);
                g.drawLine(30 + (this.getWidth() - 60) / 10, this.getHeight() - 32, 30 + (this.getWidth() - 60) / 10, this.getHeight() - 28);
                g.drawString("0.2", 22 + (this.getWidth() - 59) / 5, this.getHeight() - 12);
                g.drawLine(30 + 2 * (this.getWidth() - 60) / 10, this.getHeight() - 32, 30 + 2 * (this.getWidth() - 60) / 10, this.getHeight() - 28);
                g.drawString("0.3", 22 + 3 * (this.getWidth() - 59) / 10, this.getHeight() - 12);
                g.drawLine(30 + 3 * (this.getWidth() - 60) / 10, this.getHeight() - 32, 30 + 3 * (this.getWidth() - 60) / 10, this.getHeight() - 28);
                g.drawString("0.4", 22 + 2 * (this.getWidth() - 59) / 5, this.getHeight() - 12);
                g.drawLine(30 + 4 * (this.getWidth() - 60) / 10, this.getHeight() - 32, 30 + 4 * (this.getWidth() - 60) / 10, this.getHeight() - 28);
                g.drawString("0.5", this.getWidth() / 2 - 8, this.getHeight() - 12);
                g.drawLine(this.getWidth() / 2, this.getHeight() - 32, this.getWidth() / 2, this.getHeight() - 28);
                g.drawString("0.6", 22 + 3 * (this.getWidth() - 59) / 5, this.getHeight() - 12);
                g.drawLine(30 + 6 * (this.getWidth() - 60) / 10, this.getHeight() - 32, 30 + 6 * (this.getWidth() - 60) / 10, this.getHeight() - 28);
                g.drawString("0.7", 22 + 7 * (this.getWidth() - 59) / 10, this.getHeight() - 12);
                g.drawLine(30 + 7 * (this.getWidth() - 60) / 10, this.getHeight() - 32, 30 + 7 * (this.getWidth() - 60) / 10, this.getHeight() - 28);
                g.drawString("0.8", 22 + 4 * (this.getWidth() - 59) / 5, this.getHeight() - 12);
                g.drawLine(30 + 8 * (this.getWidth() - 60) / 10, this.getHeight() - 32, 30 + 8 * (this.getWidth() - 60) / 10, this.getHeight() - 28);
                g.drawString("0.9", 22 + 9 * (this.getWidth() - 59) / 10, this.getHeight() - 12);
                g.drawLine(30 + 9 * (this.getWidth() - 60) / 10, this.getHeight() - 32, 30 + 9 * (this.getWidth() - 60) / 10, this.getHeight() - 28);
                g.drawString("1", this.getWidth() - 32, this.getHeight() - 12);
                g.drawLine(this.getWidth() - 30, this.getHeight() - 32, this.getWidth() - 30, this.getHeight() - 28);
            }
        };
        this.graphArea.setLocation(0, 0);
        this.graphArea.setSize(this.getWidth(), this.getHeight() - 300);
        final JToolTip jtt = new JToolTip();
        jtt.setComponent(this.graphArea);
        jtt.setSize(jtt.getPreferredSize());
        jtt.setVisible(false);
        this.add(jtt);
        this.getContentPane().add(this.graphArea);
        this.getContentPane().add(this.iInterface);
        this.getContentPane().add(this.iInterface2);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                GraphView.this.showCross = false;
                jtt.setVisible(false);
                GraphView.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                Graph.Info info = GraphView.this.graph.getInfoOn(GraphView.this.getRelativeX(arg0.getX()), GraphView.this.getRelativeY(arg0.getY()));
                if (info != null) {
                    GraphView.this.showCross = true;
                    jtt.setVisible(true);
                    GraphView.this.setXY(jtt, info);
                } else {
                    GraphView.this.showCross = false;
                    jtt.setVisible(false);
                }
                GraphView.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }

            @Override
            public void mouseDragged(MouseEvent arg0) {
                Graph.Info info = GraphView.this.graph.getInfoOn(GraphView.this.getRelativeX(arg0.getX()), GraphView.this.getRelativeY(arg0.getY()));
                if (info != null) {
                    GraphView.this.showCross = true;
                    jtt.setVisible(true);
                    GraphView.this.setXY(jtt, info);
                    GraphView.this.repaint();
                } else {
                    GraphView.this.showCross = false;
                    jtt.setVisible(false);
                }
                GraphView.this.repaint();
            }
        });
        this.getContentPane().addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorResized(HierarchyEvent arg0) {
                GraphView.this.iInterface.setLocation(GraphView.this.iInterface.getX(), GraphView.this.getHeight() - 300 + 20);
                GraphView.this.graphArea.setSize(GraphView.this.getWidth(), GraphView.this.getHeight() - 300);
                GraphView.this.iInterface2.setLocation(GraphView.this.iInterface2.getX(), GraphView.this.getHeight() - 300 + 20);
                GraphView.this.repaint();
            }

            @Override
            public void ancestorMoved(HierarchyEvent arg0) {
            }
        });
        this.repaint();
    }

    protected double getRelativeY(int y) {
        double t = (double)(this.graphArea.getHeight() - 7 - y) / (double)(this.graphArea.getHeight() - 60);
        return this.graph.getMaxValue() * t;
    }

    protected double getRelativeX(int x) {
        return (double)(x - 30) / (double)(this.graphArea.getWidth() - 60);
    }

    private void setXY(JToolTip jtt, Graph.Info i) {
        jtt.setTipText("<html><table><tr><td>x position:</td><td>" + this.shortPrint(i.x) + "</td></tr><tr><td>y position:</td><td>" + this.shortPrint(i.y) + "</td></tr><tr><td>f(x):</td><td>" + this.shortPrint(i.fx) + "</td></tr><tr><td>Expected entropy for x:</td><td>" + this.shortPrint(i.ex) + "</td></tr></table></html>");
        jtt.setSize(jtt.getPreferredSize());
        Point mp = this.getMousePosition();
        if (mp == null) {
            return;
        }
        jtt.setLocation(mp.x, mp.y - 15);
        if (jtt.getX() + jtt.getWidth() > this.getWidth()) {
            jtt.setLocation(jtt.getX() - jtt.getWidth() - 6, jtt.getY());
        }
    }

    private String shortPrint(double x) {
        String s = "" + Math.round(x * 1000.0);
        if (s.length() >= 4) {
            return String.valueOf(s.substring(0, s.length() - 3)) + "." + s.substring(s.length() - 3);
        }
        if (s.length() == 3) {
            return "0." + s;
        }
        if (s.length() == 2) {
            return "0.0" + s;
        }
        if (s.length() == 1) {
            return "0.00" + s;
        }
        return "";
    }

    @Override
    public void dispose() {
        super.dispose();
        MultiGraphView.removeGraph(this.graph);
    }
}

