/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Iterator;
import main.Entanglement;
import main.Main;

public class Obs {
    public int s;
    public int f;

    public Obs(int i, int j) {
        this.s = i;
        this.f = j;
    }

    public String toString() {
        return this.s + ", " + this.f;
    }

    public boolean equals(Object ob) {
        try {
            Obs o = (Obs)ob;
            return o.s == this.s && o.f == this.f;
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public static Iterator<Selection> monteCarlo(final Entanglement dist) {
        return new Iterator<Selection>(){
            private int i = 0;
            private int h = 0;
            private int size;
            private int s;
            {
                this.size = entanglement.getMaxSize();
                this.s = 0;
            }

            @Override
            public boolean hasNext() {
                return this.h < this.size;
            }

            @Override
            public Selection next() {
                if (dist.getImpact(this.h) == this.h) {
                    Selection result = new Selection(new Obs(this.s, this.h - this.s), 1.0);
                    ++this.i;
                    ++this.s;
                    if (this.i > this.h) {
                        ++this.h;
                        this.s = 0;
                        this.i = 0;
                    }
                    return result;
                }
                this.s = Main.rand.nextInt(this.h + 1);
                Selection result = new Selection(new Obs(this.s, this.h - this.s), (double)this.h / (double)dist.getImpact(this.h));
                ++this.i;
                if (this.i > dist.getImpact(this.h)) {
                    ++this.h;
                    this.i = 0;
                }
                return result;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Code should never be reached.");
            }
        };
    }

    public static class Selection {
        public Obs observation;
        public double weight;

        public Selection(Obs observation, double weight) {
            this.observation = observation;
            this.weight = weight;
        }
    }
}

