/*
 * ============================================================================
 *
 *       Filename:  main_test.cc
 *
 *    Description:  Test of main function
 *
 *        Version:  1.0
 *        Created:  10/19/2011 06:36:14 AM
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  Piotr Kordy (),
 *
 * ============================================================================
 */

#include "gtest/gtest.h"
#include "option.h"
#include "smart.h"
#include "project.h"
#include "commRes.h"
#include "diffRes.h"
bool compareFile(const std::string &name, unsigned char* content,uint_32t size){
  FILE *pFile;
  unsigned char ch1;
  pFile = fopen (name.c_str(), "rb");
  if(pFile==NULL) return false;
  uint_32t i=0;
  while(!feof(pFile)) {
    ch1 = fgetc(pFile);
    if(ferror(pFile)||i>size){
      fclose(pFile);
      return false;
    }
    if(ch1!=content[i]&&(!feof(pFile))){
      fclose(pFile);
      return false;
    }
    i++;
  }
  fclose(pFile);
  return true;
}

void createFile(const std::string &name,const char *content,uint_32t size){
  FILE * pFile;
  pFile = fopen (name.c_str(), "wb");
  fwrite (content , 1 ,size, pFile );
  fclose(pFile);
}

void createFiles(uint_32t size)
{
  createFile("__tmp_project", (char *) projContent,strlen(projContent));
  createFile("__tmp_sma01_mfd", (char *) sma01_mfd,size);
  createFile("__tmp_sma02_mfd", (char *) sma02_mfd,size);
  createFile("__tmp_sma03_mfd", (char *) sma03_mfd,size);
  createFile("__tmp_sma04_mfd", (char *) sma04_mfd,size);
  createFile("__tmp_sma05_mfd", (char *) sma05_mfd,size);
  createFile("__tmp_sma06_mfd", (char *) sma06_mfd,size);
  createFile("__tmp_sma07_mfd", (char *) sma07_mfd,size);
  createFile("__tmp_sma08_mfd", (char *) sma08_mfd,size);
  createFile("__tmp_sma09_mfd", (char *) sma09_mfd,size);
  createFile("__tmp_sma10_mfd", (char *) sma10_mfd,size);
  createFile("__tmp_sma11_mfd", (char *) sma11_mfd,size);
  createFile("__tmp_sma12_mfd", (char *) sma12_mfd,size);
  createFile("__tmp_sma13_mfd", (char *) sma13_mfd,size);
  createFile("__tmp_smb01_mfd", (char *) smb01_mfd,size);
  createFile("__tmp_smb02_mfd", (char *) smb02_mfd,size);
  createFile("__tmp_smb03_mfd", (char *) smb03_mfd,size);
  createFile("__tmp_smb04_mfd", (char *) smb04_mfd,size);
  createFile("__tmp_smb05_mfd", (char *) smb05_mfd,size);
  createFile("__tmp_smb06_mfd", (char *) smb06_mfd,size);
  createFile("__tmp_smb07_mfd", (char *) smb07_mfd,size);
  createFile("__tmp_smb08_mfd", (char *) smb08_mfd,size);
  createFile("__tmp_smb09_mfd", (char *) smb09_mfd,size);
  createFile("__tmp_smb10_mfd", (char *) smb10_mfd,size);
  createFile("__tmp_smb11_mfd", (char *) smb11_mfd,size);
  createFile("__tmp_smb12_mfd", (char *) smb12_mfd,size);
  createFile("__tmp_smb13_mfd", (char *) smb13_mfd,size);
  createFile("__tmp_smb14_mfd", (char *) smb14_mfd,size);
  createFile("__tmp_smb15_mfd", (char *) smb15_mfd,size);
  createFile("__tmp_smb16_mfd", (char *) smb16_mfd,size);
  createFile("__tmp_smm01_mfd", (char *) smm01_mfd,size);
  createFile("__tmp_smm02_mfd", (char *) smm02_mfd,size);
  createFile("__tmp_smm03_mfd", (char *) smm03_mfd,size);
  createFile("__tmp_smm04_mfd", (char *) smm04_mfd,size);
  createFile("__tmp_smm05_mfd", (char *) smm05_mfd,size);
  createFile("__tmp_smm07_mfd", (char *) smm07_mfd,size);
}

void removeFiles(){
  remove("__tmp_project");
  remove("__tmp_sma01_mfd");
  remove("__tmp_sma02_mfd");
  remove("__tmp_sma03_mfd");
  remove("__tmp_sma04_mfd");
  remove("__tmp_sma05_mfd");
  remove("__tmp_sma06_mfd");
  remove("__tmp_sma07_mfd");
  remove("__tmp_sma08_mfd");
  remove("__tmp_sma09_mfd");
  remove("__tmp_sma10_mfd");
  remove("__tmp_sma11_mfd");
  remove("__tmp_sma12_mfd");
  remove("__tmp_sma13_mfd");
  remove("__tmp_smb01_mfd");
  remove("__tmp_smb02_mfd");
  remove("__tmp_smb03_mfd");
  remove("__tmp_smb04_mfd");
  remove("__tmp_smb05_mfd");
  remove("__tmp_smb06_mfd");
  remove("__tmp_smb07_mfd");
  remove("__tmp_smb08_mfd");
  remove("__tmp_smb09_mfd");
  remove("__tmp_smb10_mfd");
  remove("__tmp_smb11_mfd");
  remove("__tmp_smb12_mfd");
  remove("__tmp_smb13_mfd");
  remove("__tmp_smb14_mfd");
  remove("__tmp_smb15_mfd");
  remove("__tmp_smb16_mfd");
  remove("__tmp_smm01_mfd");
  remove("__tmp_smm02_mfd");
  remove("__tmp_smm03_mfd");
  remove("__tmp_smm04_mfd");
  remove("__tmp_smm05_mfd");
  remove("__tmp_smm07_mfd");
}

TEST(MainTest,common){
  Options opts;
  {
    Project project = Project(&opts);
    createFiles(4096);
    opts.projectFile="__tmp_project";
    opts.commonalFile="__tmp_common";
    opts.separateBytes=false;
    opts.outputFormat=ASCII_OUTPUT;
    opts.attributesVect.push_back("common");
    project.doWork();
    EXPECT_TRUE(compareFile("__tmp_common",common,sizeof(common)));
    remove("__tmp_common");
  }

  {
    opts.dissimilFile="__tmp_dissim";
    opts.useLinear = true;
    Project project = Project(&opts);
    opts.attributesVect[0]="dissim";
    project.doWork();
    //dissimP is defined in diffRes.h
    EXPECT_TRUE(compareFile("__tmp_dissim",(unsigned char*) dissimP,
                sizeof(dissimP)));
    remove("__tmp_dissim");
  }
  {
    opts.dissimilFile="__tmp_dissim";
    opts.useLinear = false;
    Project project = Project(&opts);
    opts.attributesVect[0]="dissim";
    project.doWork();
    EXPECT_TRUE(compareFile("__tmp_dissim",(unsigned char*) dissimP,
                sizeof(dissimP)));
    remove("__tmp_dissim");
  }

  {
    Project project = Project(&opts);
    opts.useLinear = true;
    opts.memLimit=2000;
    opts.exclude=true;
    project.doWork();
    EXPECT_TRUE(compareFile("__tmp_dissim",(unsigned char*) dissimP,
                sizeof(dissimP)));
    remove("__tmp_dissim");
  }

  {
    Project project = Project(&opts);
    opts.memLimit=2000;
    opts.useLinear = false;
    opts.exclude=true;
    project.doWork();
    EXPECT_TRUE(compareFile("__tmp_dissim",(unsigned char*) dissimP,
                sizeof(dissimP)));
    remove("__tmp_dissim");
  }

  {
    opts.exclude=false;
    opts.useLinear = true;
    opts.dissimilFile="";
    opts.memLimit=2000;
    opts.attributesVect[0]="common";
    Project project = Project(&opts);
    project.doWork();
    EXPECT_TRUE(compareFile("__tmp_common",common,sizeof(common)));
    remove("__tmp_common");
  }

  {
    opts.memLimit=3000;
    opts.attributesVect[0]="rides left";
    opts.useLinear = false;
    Project project = Project(&opts);
    project.doWork();
    EXPECT_TRUE(compareFile("__tmp_common",rides,sizeof(rides)));
    remove("__tmp_common");
  }

  {
    opts.memLimit=3861;
    opts.attributesVect[0]="rl cy 2 sec 7";
    Project project = Project(&opts);
    project.doWork();
    EXPECT_TRUE(compareFile("__tmp_common",sec7,sizeof(sec7)));
    remove("__tmp_common");
  }
  {
    opts.memLimit=4096;
    opts.attributesVect[0]="rl cy 2 sec 7";
    opts.attributesVect.push_back("rl cy 2 sec 1");
    Project project = Project(&opts);
    project.doWork();
    EXPECT_TRUE(compareFile("__tmp_common_0",sec7,sizeof(sec7)));
    EXPECT_TRUE(compareFile("__tmp_common_1",sec1,sizeof(sec1)));
    remove("__tmp_common_0");
    remove("__tmp_common_1");
  }
  {
    opts.memLimit=3542;
    opts.attributesVect.clear();
    opts.dissimilFile="__tmp_dissim2";
    opts.attributesVect.push_back("rl cy 2 sec 1");
    Project project = Project(&opts);
    project.doWork();
    EXPECT_TRUE(compareFile("__tmp_common",sec1,sizeof(sec1)));
    remove("__tmp_common");
    remove("__tmp_dissim2");
  }
  {
    opts.memLimit=9000;
    opts.attributesVect[0]="id";
    Project project = Project(&opts);
    project.doWork();
    EXPECT_TRUE(compareFile("__tmp_common",id,sizeof(id)));
    remove("__tmp_common");
    remove("__tmp_dissim2");
    removeFiles();
  }
  {
    createFiles(23);//testing file length that is not divisible by 8

    opts.memLimit=5542;
    opts.attributesVect.clear();
    opts.attributesVect.push_back("rl cy 2 sec 1");
    Project project =  Project(&opts);
    project.doWork();
    EXPECT_TRUE(compareFile("__tmp_common",sec1,23));
    remove("__tmp_dissim2");
    remove("__tmp_common");
  }
  {
    opts.memLimit=1542;
    opts.attributesVect.clear();
    opts.attributesVect.push_back("rl cy 2 sec 1");
    opts.noBytesEndian = 2;//this option should be ignored
    Project project =  Project(&opts);
    project.doWork();
    EXPECT_TRUE(compareFile("__tmp_common",sec1,23));
    remove("__tmp_dissim2");
    remove("__tmp_common");
    removeFiles();
  }
}
