/*
 * ============================================================================
 *
 *       Filename:  option_test.cc
 *
 *    Description:  Testing of option class.
 *
 *        Version:  1.0
 *        Created:  10/06/2011 05:15:30 PM
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  Piotr Kordy,
 *        Company:
 *
 * ============================================================================
 */
#include "gtest/gtest.h"
#include "option.h"

class OptionTest;
//wrapper class to give access to protected members
class UnitOptions : public Options {
public:
  friend class OptionTest;
  UnitOptions (int argc,char ** argv):Options (argc,argv){
  }
};
class OptionTest : public testing::Test {
protected:
  virtual void SetUp() {
  }
};
typedef OptionTest OptionDeathTest;

/*TEST_F(OptionTest,FileNames){
  char * argv2[]= { (char *)"ccarve", (char *)"-i", (char *)"somefile",
  (char *)"-c", (char *)"cfile", (char *)"-d", (char *)"dfile", (char *)"attr"};
  UnitOptions opt(8,argv2);
  ASSERT_TRUE(opt.projectFile.compare("somefile")==0);
  ASSERT_TRUE(opt.dissimilFile.compare("dfile")==0);
  ASSERT_TRUE(opt.commonalFile.compare("cfile")==0);

  }*/
TEST_F(OptionDeathTest,NoProjectFileTest){
  char * argv1[] = { (char *)"ccarve", (char *)"-p", (char *)"somefile",
    (char *)"attr" };
  ASSERT_DEATH(Options opt(4,argv1),"Project file \"somefile\" does not .*");
}
TEST_F(OptionDeathTest,NoArgumentsTest){
  char * argv1[] = { (char *)"ccarve"};
  EXPECT_EXIT(Options opt(1,argv1),::testing::ExitedWithCode(0),".*");
}
TEST_F(OptionDeathTest,PrintVersionTest){
  char * argv1[] = { (char *)"ccarve", (char *)"--version"};
  EXPECT_EXIT(Options opt(2,argv1),::testing::ExitedWithCode(0),".*");
}
