#! /usr/bin/env python
import sys
import bitstring
import struct
import os

def debug(message):
    print message

def ones(n):
    # create bitstring of n ones
    return ~zeros(n)

def zeros(n):
    # create bistring of n zeros
    return bitstring.pack('int:m=0', m=n)

def common_bits_bundle(list_s, I):
    for ls in list_s[:]:
        s = ls.pop()
        I = common_bits(s, ls, I)
    return I    

def common_bits(s, list_s, I):
    # computes the common bits between s and a random element in
    # list_s and returns the intersection with I
    ss = list_s[:]
    if list_s == []:
        return I
    else:
        s2 = ss.pop()
        return common_bits(s2, ss, ~(s^s2) & I)
        
def same_length(ss):
    if ss == []:
        return True
    else:
        return max([len(s) for s in ss]) == min([len(s) for s in ss])

def different_mask(s, I, pb):
    if same_length(s+[I]) == False:
        raise Exception("Make sure all strings and mask are of the same length")
    elif s == []:
        raise Exception("Make sure you have at least one element in your list")        
    
    # Initialization of the grand result
    r = [float('-inf')]*len(s[0])
    
    # debug:
    e = 0
    n = len(s)

    # Initializing progressbar
    pb.setMinimum(0)
    pb.setMaximum(((n-1)*n)/2)

    # Examine every pair of bitstrings
    for i in range(n):
        for j in range(i+1, n):
            # debug
            e += 1
            pb.setValue(e)
            
            # Compute differences between s[i] and s[j]
            d = s[i]^s[j]
            
            # Traverse differences string in reverse order
            c = float('inf')
            for k in reversed(range(len(d))):
                if I[k] == False:
                    # Mask is false: attribute cannot be encoded here
                    c = float('inf')
                elif d[k] == True:
                    # Difference: reset c
                    c = 1
                else:
                    # No difference: increment c
                    c = c+1
                r[k] = max(c, r[k])
    
    pb.setValue(0)
    
    return r
    
def different_mask_minimal(s, I, pb):
    r = different_mask(s, I, pb)
    rr = different_minimize(r)
    return rr    
    
def different(s, pb=None):
    if same_length(s) == False:
        raise Exception("Make sure all strings are of the same length")
    elif s == []:
        raise Exception("Make sure you have at least one element in your list")        
    
    # Initialization of the grand result
    r = [float('-inf')]*len(s[0])
    
    # debug:
    e = 0
    n = len(s)
    
    # Initializing progressbar
    if pb <> None:
        pb.setMinimum(0)
        pb.setMaximum(((n-1)*n)/2)
    
    # Examine every pair of bitstrings
    for i in range(n):
        for j in range(i+1, n):
            # debug
            e += 1
            if pb <> None:
                pb.setValue(e)
            
            # Compute differences between s[i] and s[j]
            d = s[i]^s[j]
            
            # Traverse differences string in reverse order
            c = float('inf')
            for k in reversed(range(len(d))):
                if d[k] == True:
                    # Difference: reset c
                    c = 1
                else:
                    # No difference: increment c
                    c = c+1
                r[k] = max(c, r[k])
    
    if pb <> None:
        pb.setValue(0)
    return r
    
def different_minimize(l):
    r = []
    for i in range(1, len(l)):
        if (l[i-1] <= l[i]) & (l[i-1] < float('inf')):
            r.append((i-1, l[i-1]))
    return r        
    
def different_minimal(s, pb=None):
    r = different(s, pb)
    rr = different_minimize(r)
    return rr
  
