# -*- coding: utf-8 -*-

"""
Module implementing Carve.
"""
from PyQt4 import QtGui, QtCore
from PyQt4.QtGui import QDialog
from PyQt4.QtCore import pyqtSignature

import bitstring
import carving
import layout
import time

from Ui_carve import Ui_Carve

class Carve(QDialog, Ui_Carve):
    """
    Class documentation goes here.
    """
    def __init__(self, parent = None):
        """
        Constructor
        """
        self.base = 16
        self.i = 0
        QDialog.__init__(self, parent)
        self.setupUi(self)
        
        self.txtFile.setFontFamily('courier')
        self.txtFile.setFontPointSize(12)
        self.mask = bitstring.BitString('0x0')
        self.differences = []

        self.column = 0
        self.row = 0
        self.file = None
        self.edtColumns.setText('64')
        #self.edtRows.setText('32')
        
        self.edtFrom.setText('0')
        self.edtTo.setText('8192')
        
        self.pbProgress.setValue(0)
        
        self.bitlist = []
        self.span = []
        
        self.tc = 0
        
        self.show_all = True
        

    def working_dir(self):
        return str(QtCore.QDir.currentPath()).split('/ui')[0]
        
    def set_bold(self, a):
        f = a.font()
        f.setBold(True)
        a.setFont(f)
        return a
        
    def setTable(self, table):
        r = table.rowCount()
        c = table.columnCount()
        self.tblFiles.setRowCount(r)
        self.tblFiles.setColumnCount(c)

        for j in range(c):
            a = QtGui.QTableWidgetItem(table.item(0, j).text())
            a = self.set_bold(a)
            self.tblFiles.setItem(0, j, a)
            
        for i in range(1, r):
            for j in range(c):
                try:
                    t = table.item(i, j).text()
                except AttributeError:
                    t = ""
                a = QtGui.QTableWidgetItem(t)
                self.tblFiles.setItem(i, j, a)
    
    @pyqtSignature("QString")
    def on_comboBox_textChanged(self, p0):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
        
    def display_file(self):
        # Remember scrollbar position
        sb = self.txtFile.verticalScrollBar().value()
        
        self.txtFile.clear()
        file = self.filename
        
        #obtain display values
        cols = int(self.edtColumns.text())
        ub = int(self.edtTo.text())
        mode = self.cmbMode.currentText()
        
            
        if mode == "Bin":
            dump = bitstring.BitString(filename=file).bin[2:ub+2]
                
            # First create spans for commons bits
            if self.mask == bitstring.BitString('0x0'):
                self.span = ['w']*(len(dump))
            else:    
                self.span = layout.bin_to_span(self.mask)
                
            # Add differences to the spans
            if self.differences != []:
                if self.show_all == True:
                    # Show all
                    for s in self.differences:
                        self.span = layout.add_differences(self.span, s[0], s[0]+s[1])
                else:
                    # Show one
                    r = self.currentDifferences
                    min = self.differences[r][0]
                    max = self.differences[r][0]+self.differences[r][1]
                    self.span = layout.add_differences(self.span, min, max)
            
            l = layout.add_span_to_bin(layout.bin_to_list(dump), self.span)

            #Dump the common/span bits in a latex processable file
            #
            #(Apologies for putting this code here and not in a "def".
            #Feel free to reposition.)
            filename = "commonfile.tex"
            thebits = layout.bin_to_list(bitstring.BitString(filename=self.filename).bin[2:ub+2])
            themask = self.span
            linelen = 128 # determines when lines are wrapped
            commonbits = "" # to build the file
            for i in range(0,len(thebits)):
              # wrap a line
              if i%linelen == 0 and i != 0:
                 commonbits += r"\myendline" + "\n"
              # add extra horizontal lines
              #if i == 0 or i == linelen or (i+linelen)%(4*linelen) == 0:
              if i%(4*linelen) == 0:
                 commonbits += r"\extraline" + "\n"
              # construct the bits
              if themask[i] == 'r':
                 commonbits += r"\x"  # a red bit (ignore 0/1)
              else:
                 if thebits[i] == 1:
                    commonbits += r"\n" # a 1 in green part
                 else:
                    commonbits += r"\z" # a 0 in green part
            commonbits += r"\myendline" + "\n"
            # write to file
            file = open(filename, "w")
            file.write(commonbits)

            
        if mode == "Hex":
            dump = bitstring.BitString(filename=file).hex[2:ub+2]
            
            # First create spans for commons bits
            if self.mask == bitstring.BitString('0x0'):
                self.span = ['w']*(len(dump))
            else:    
                self.span = layout.hex_to_span(self.mask.hex)
            
            
            # Add differences to the spans
            if self.differences != []:
                if self.show_all == True:
                    # Show all
                    for s in self.differences:
                        min = s[0]/4
                        max = (s[0]+s[4]+3)/4
                        self.span = layout.add_differences(self.span, min, max)
                else:
                    # Show one
                    r = self.currentDifferences
                    min = self.differences[r][0]/4
                    max = (self.differences[r][0]+self.differences[r][1]+3)/4
                    self.span = layout.add_differences(self.span, min, max)
            
            l = layout.add_span_to_bin(layout.hex_to_list(dump), self.span)
       
        # Wrapping
        l = layout.list_add_linebreaks(l, cols)
        
        # Create HTML
        self.txtFile.setHtml(layout.html(l))
        
        # Restore Scrollbar position
        self.txtFile.verticalScrollBar().setValue(sb)

    @pyqtSignature("int, int, int, int")
    def on_tblFiles_currentCellChanged(self, currentRow, currentColumn, previousRow, previousColumn):
        """
        Slot documentation goes here.
        """
        if (currentRow <> previousRow) & (currentRow <> 0):
            f = self.tblFiles.item(currentRow, 0).text()
            self.row = currentRow
            self.column = currentColumn
            self.filename = self.working_dir() + f
            self.display_file()
    
    @pyqtSignature("")
    def bundles(self, c):
        # bounds
        lb = int(self.edtFrom.text())
        ub = int(self.edtTo.text())
        
        # Which items are selected
        if self.chkSelectedOnly.isChecked() == True:
           selected = self.tblFiles.selectedIndexes()
           selected = [x.row() for x in selected]
           if 0 in selected:
               selected.remove(0)
        else:
           selected = range(1, self.tblFiles.rowCount()) 
        
        # Create dictionary structure for all files
        d = {}
        for i in selected:
            file = str(self.tblFiles.item(i, 0).text())
            value = str(self.tblFiles.item(i, c).text())
            try:
                d[value].append(file)
            except KeyError:
                d[value] = []
                d[value].append(file)
                
        bundles = []
        for i in d:
            bundle = []             
            for j in d[i]:
                el = bitstring.BitString(filename=self.working_dir() + j)[lb:ub]
                bundle.append(el)            
            bundles.append(bundle)
        return bundles
        
    def on_btnCommon_clicked(self):
        """
        Slot documentation goes here.
        """
        # Reset differences
        self.differences = []
        
        # Analyze all values in dictionary
        c = self.tblFiles.currentColumn()
        b = self.bundles(c)
        
        if len(b) > 1:
            I = carving.ones(len(b[0][0]))
            I = carving.common_bits_bundle(b, I)
        
            self.mask = I
            self.display_file()
        else:
            self.txtLog.append("Please select more than one bitstring.")
    
    @pyqtSignature("")
    def on_btnRefresh_clicked(self):
        """
        Slot documentation goes here.
        """
        self.display_file()
    
    @pyqtSignature("")
    def on_btnDifferent_clicked(self):
        """
        Slot documentation goes here.
        """

        c = self.tblFiles.currentColumn()
        bb = self.bundles(c)
        
        # Select one candidate from every bundle
        sb = []
        for b in bb:
            sb.append(b[0])
        
        # Apply different_mask
        if len(sb) > 1:
            I = carving.different_minimal(sb, self.pbProgress)
            self.differences = I
     
            self.currentDifferences = 0
            self.show_all = True
            self.display_differences()
        else:
            self.txtLog.setText("Please select bitstrings of more than one bundle")
  
    def display_differences(self):
        self.lstDifferences.clear()
        for d in self.differences:
            self.lstDifferences.addItem(str(d[0]) + '-' + str(d[0]+d[1]-1))
            
    @pyqtSignature("")
    def on_btnCombined_clicked(self):
        """
        Slot documentation goes here.
        """
        
        c = self.tblFiles.selectedItems()[0].column()
        bb = self.bundles(c)
                
        # Apply common
        I = carving.ones(len(bb[0][0]))
        I = carving.common_bits_bundle(bb, I)
        self.mask = I
        
        # Bundles of bitstrings really are bundles of pointers....
        # therefore, need to be recreated.
        bb = self.bundles(c)
                
        # Select one candidate from every bundle
        sb = []
        for b in bb:
            sb.append(b[0])
            
        # Apply different_mask
        if len(sb) > 1:
            I = carving.different_mask_minimal(sb, I, self.pbProgress)
            self.differences = I
            self.currentDifferences = 0
            self.show_all = True
            self.display_differences()
        else:
            self.txtLog.append("Nothing to carve: Less than two bitstrings.")
        
        
    @pyqtSignature("")
    def on_txtFile_selectionChanged(self):
        """
        Slot documentation goes here.
        """
        if self.differences == []:
            return False
        
        t = self.txtFile.textCursor()
        i = int(t.position())
        cols = int(self.edtColumns.text())
                
        # For some reason whitespace at the end of the line counts as a character
        i = i-i/(cols+1)
        
        if self.cmbMode.currentText() == 'Hex':
            i = i*4
        
        z = -1
        x = 0
        while (z == -1):
            if self.differences[x][0] + self.differences[x][1] < i:
                x +=1
            else:
                z = x
        self.lstDifferences.setCurrentRow(z)
        
    @pyqtSignature("QString")
    def on_cmbMode_currentIndexChanged(self, p0):
        """
        Slot documentation goes here.
        """
        # Position cursor at start of document
        cursor = self.txtFile.textCursor()
        cursor.setPosition(self.tc)
        self.txtFile.setTextCursor(cursor)
     
        self.display_file()
    
    @pyqtSignature("int")
    def on_lstDifferences_currentRowChanged(self, currentRow):
        """
        Slot documentation goes here.
        """
        self.currentDifferences = currentRow
        
        self.show_all = False
        self.display_file()
    
    @pyqtSignature("")
    def on_btnShowAll_clicked(self):
        """
        Slot documentation goes here.
        """
        self.show_all = True
        self.display_file()
    
    @pyqtSignature("")
    def on_btnRunTest_clicked(self):
        """
        Slot documentation goes here.
        """
        self.txtLog.append("==============================================")
        self.txtLog.append("= Test 1: ")
        self.txtLog.append("= Timing of the combined procedure")
        self.txtLog.append("==============================================")

        # Select attribute
        c = self.tblFiles.currentColumn()
        
        # Unselect all cells except for the first one
        for i in range(0, self.tblFiles.rowCount()):
            for j in range(0, self.tblFiles.columnCount()):
                self.tblFiles.item(i, j).setSelected(False)
        self.tblFiles.item(1, c).setSelected(True)
        
            
        for i in range(2, self.tblFiles.rowCount()):
            # Select one more item
            self.tblFiles.item(i, c).setSelected(True)
        
            # Start timer
            start = time.time()
            
            # Execute code
            self.on_btnCombined_clicked()
            
            # End timer
            stop = time.time()
            
            # Log
            self.txtLog.append("Number of dumps: " + str(i) + "; Time: " + str(stop-start) + " seconds." )

    @pyqtSignature("")
    def on_btnRunTest2_clicked(self):
        """
        Slot documentation goes here.
        """
        self.txtLog.append("==============================================")
        self.txtLog.append("= Test 2:")
        self.txtLog.append("= Convergence of the combined procedure")
        self.txtLog.append("==============================================")
        max_num_attributes = 20
        
        # Select attribute
        for c in range(1, min(self.tblFiles.columnCount(), max_num_attributes)):
            # Unselect all cells except for the first one
            for i in range(0, self.tblFiles.rowCount()):
                for j in range(0, self.tblFiles.columnCount()):
                    self.tblFiles.item(i, j).setSelected(False)
            self.tblFiles.item(1, c).setSelected(True)
                
            s = str(self.tblFiles.item(0, c).text())    
            lower = int(s.split()[1].split("+")[0])
            upper = int(s.split()[1].split("+")[1]) + lower
                
                   
            for i in range(2, self.tblFiles.rowCount()):
                # Select one more item
                self.tblFiles.item(i, c).setSelected(True)
                       
                # Execute code
                self.on_btnCombined_clicked()
         
                # number of intervals            
                n = len(self.differences)
                
                # Log
                self.txtLog.append("Attribute: " + str(c) + "; #dumps: " + str(i) + "; #intervals: " + str(n))
    
                low = self.differences[0][0]
                high = self.differences[n-1][0]+self.differences[n-1][1]
                
                if ((low >= lower) & (high <= upper)):
                    self.txtLog.append("Attribute: " + str(c) + "; Convergence at #dumps = " + str(i))
                    break
