#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
This module implements a dialog that allows users to set their preferences
"""

from PyQt4.QtGui import QDialog, QApplication, QColorDialog, QPainter, QPixmap, QBrush, QPainter, QColor
from PyQt4.QtCore import pyqtSignature, Qt, QSignalMapper, SIGNAL, SLOT

from Ui_preferences import Ui_dlgPreferences

class dlgPreferences(QDialog, Ui_dlgPreferences):
    def __init__(self, parent = None):
        """
        Constructor
        """
        QDialog.__init__(self, parent)
        self.setupUi(self)
        
        # Set initial colors
        self.labels = [self.lblColorCommon, self.lblColorUncommon, self.lblColorDissim]
        self.colors = [QColor(0, 255, 0, 255), 
                       QColor(0, 0, 255, 255), 
                       QColor(255, 255, 0, 255)]
        self.set_colors(self.colors)
        self.edtFrom.setEnabled(False)
        self.lblFrom.setEnabled(False)
                
        # Connect signals to slots
        signal_mapper = QSignalMapper(self)
        signal_mapper.setMapping(self.btnColorCommon, 0)
        signal_mapper.setMapping(self.btnColorUncommon, 1)
        signal_mapper.setMapping(self.btnColorDissim, 2)
        self.connect(self.btnColorCommon, SIGNAL("clicked()"), signal_mapper, SLOT("map()"))
        self.connect(self.btnColorUncommon, SIGNAL("clicked()"), signal_mapper, SLOT("map()"))
        self.connect(self.btnColorDissim, SIGNAL("clicked()"), signal_mapper, SLOT("map()"))
        signal_mapper.mapped.connect(self.set_color)
        
    def set_colors(self, colors):
        self.colors = colors
        for i in range(3):
            self.color_label(i, colors[i])
    
    def set_color(self, i):
        color = QColorDialog.getColor(Qt.black, self)
        self.colors[i] = color
        if color.isValid():
            self.color_label(i, color)
        
    def color_label(self, i, color):
        pixmap = QPixmap(50, 20)
        painter = QPainter(pixmap)
        brush = QBrush(color)
        painter.fillRect(pixmap.rect(), brush)
        self.labels[i].setPixmap(pixmap)        
        painter.end()
        
    def get_colors(self):
        colors = []
        for i in range(3):
            colors.append(self.colors[i].getRgb())
        return colors

if __name__ == "__main__":
    import sys

    app = QApplication(sys.argv)
    form = dlgPreferences()
    form.show()
    app.exec_()
