%%% Functors:
    fun  penc/2.
    fun  pub/1.
    fun  h/1.
    fun  a/0.   % the honest users
    fun  b/0.   % 
    fun  c/0.   % the intruder
    fun  k/1.   % participant private keys
    fun  ra/0.
    fun  rb/0.

    % nonces
    fun  n/3. 
    fun  m/3. 

    fun end/1.

%%% Auxiliary predicates:
    part(a).
    part(b).
    part(c).

    talksA(a,b).
    talksA(a,c).
    talksB(b,a).
    talksB(b,c).

    nonce m(_,_,_).
    nonce n(_,_,_).

    	
%%% RULES:

%%% Intruder rules

    rule  X, pub(K) -> penc(X,pub(K)).
    rule  penc(X,pub(K)), K -> X.
    rule  X -> h(X).

%%% Initial knowledge
    rule   A   :-  part(A).
    rule   pub(k(A)) :- part(A).
    rule   k(c).

%%% Rule (1):  [A -> B]   {NA, A}KB

    rule  th(A,B,1,ra,I),penc((n(A,B,I), A), pub(k(B)))
    :- talksA(A,B).

%%% Rule (2):  [B -> A]   {X, A}KB -> {MB, MB+X+B}KA

    rule  th(B,A,2,rb,I),penc((X, A), pub(k(B))) -> penc((m(B,A,I),m(B,A,I)+X+B), pub(k(A)))
    :- talksB(B,A).

%%% Rule (3):  [A -> B]   {Y, Y+NA+B}KA -> {Y}KB

    rule  th(A,B,3,ra,I),begin((A,B,Y)),  
          penc((Y,Y+n(A,B,I)+B), pub(k(A))) ->  penc(Y, pub(k(B)))  
    :- 
        talksA(A,B).

%%% Rule (4):

    rule 
          th(b,a,4,rb,I),penc(m(b,a,I), pub(k(b))) 
            ->  end((a,b,m(b,a,I))).

%%% The goal:
    query end((a,b,m(b,a,_I))).
